/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v26.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v26.group.RAS_O17_COMPONENTS;
import ca.uhn.hl7v2.model.v26.segment.NTE;
import ca.uhn.hl7v2.model.v26.segment.RXR;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RAS_O17_ORDER_DETAIL_SUPPLEMENT
extends AbstractGroup {
    public RAS_O17_ORDER_DETAIL_SUPPLEMENT(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(NTE.class, true, true, false);
            this.add(RXR.class, true, true, false);
            this.add(RAS_O17_COMPONENTS.class, false, true, false);
        }
        catch (HL7Exception e) {
            this.log.error("Unexpected error creating RAS_O17_ORDER_DETAIL_SUPPLEMENT - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.6";
    }

    public NTE getNTE() {
        NTE retVal = (NTE)this.getTyped("NTE", NTE.class);
        return retVal;
    }

    public NTE getNTE(int rep) {
        NTE retVal = (NTE)this.getTyped("NTE", rep, NTE.class);
        return retVal;
    }

    public int getNTEReps() {
        return this.getReps("NTE");
    }

    public List<NTE> getNTEAll() throws HL7Exception {
        return this.getAllAsList("NTE", NTE.class);
    }

    public void insertNTE(NTE structure, int rep) throws HL7Exception {
        super.insertRepetition("NTE", (Structure)structure, rep);
    }

    public NTE insertNTE(int rep) throws HL7Exception {
        return (NTE)super.insertRepetition("NTE", rep);
    }

    public NTE removeNTE(int rep) throws HL7Exception {
        return (NTE)super.removeRepetition("NTE", rep);
    }

    public RXR getRXR() {
        RXR retVal = (RXR)this.getTyped("RXR", RXR.class);
        return retVal;
    }

    public RXR getRXR(int rep) {
        RXR retVal = (RXR)this.getTyped("RXR", rep, RXR.class);
        return retVal;
    }

    public int getRXRReps() {
        return this.getReps("RXR");
    }

    public List<RXR> getRXRAll() throws HL7Exception {
        return this.getAllAsList("RXR", RXR.class);
    }

    public void insertRXR(RXR structure, int rep) throws HL7Exception {
        super.insertRepetition("RXR", (Structure)structure, rep);
    }

    public RXR insertRXR(int rep) throws HL7Exception {
        return (RXR)super.insertRepetition("RXR", rep);
    }

    public RXR removeRXR(int rep) throws HL7Exception {
        return (RXR)super.removeRepetition("RXR", rep);
    }

    public RAS_O17_COMPONENTS getCOMPONENTS() {
        RAS_O17_COMPONENTS retVal = (RAS_O17_COMPONENTS)this.getTyped("COMPONENTS", RAS_O17_COMPONENTS.class);
        return retVal;
    }

    public RAS_O17_COMPONENTS getCOMPONENTS(int rep) {
        RAS_O17_COMPONENTS retVal = (RAS_O17_COMPONENTS)this.getTyped("COMPONENTS", rep, RAS_O17_COMPONENTS.class);
        return retVal;
    }

    public int getCOMPONENTSReps() {
        return this.getReps("COMPONENTS");
    }

    public List<RAS_O17_COMPONENTS> getCOMPONENTSAll() throws HL7Exception {
        return this.getAllAsList("COMPONENTS", RAS_O17_COMPONENTS.class);
    }

    public void insertCOMPONENTS(RAS_O17_COMPONENTS structure, int rep) throws HL7Exception {
        super.insertRepetition("COMPONENTS", (Structure)structure, rep);
    }

    public RAS_O17_COMPONENTS insertCOMPONENTS(int rep) throws HL7Exception {
        return (RAS_O17_COMPONENTS)super.insertRepetition("COMPONENTS", rep);
    }

    public RAS_O17_COMPONENTS removeCOMPONENTS(int rep) throws HL7Exception {
        return (RAS_O17_COMPONENTS)super.removeRepetition("COMPONENTS", rep);
    }
}

