/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cactus.integration.ant.container.jboss;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.apache.cactus.integration.ant.container.AbstractJavaContainer;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.Java;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.util.FileUtils;

public class JBoss3xContainer
extends AbstractJavaContainer {
    private File dir;
    private String config = "default";
    private transient int port = 8080;
    private transient String version;

    public final void setDir(File theDir) throws BuildException {
        this.dir = theDir;
    }

    public final void setConfig(String theConfig) {
        this.config = theConfig;
    }

    public final void setPort(int thePort) {
        this.port = thePort;
    }

    public final String getName() {
        return "JBoss " + this.version;
    }

    public final int getPort() {
        return this.port;
    }

    public final void init() {
        this.version = this.getVersion(this.dir);
        if (this.version == null) {
            throw new BuildException(this.dir + " not recognized as a JBoss 3.x installation");
        }
        if (!this.version.startsWith("3")) {
            throw new BuildException("This element doesn't support version " + this.version + " of JBoss");
        }
    }

    public final void startUp() {
        try {
            this.prepare("cactus/jboss3x");
            File binDir = new File(this.dir, "bin");
            File configDir = new File(this.dir, "server");
            Java java = this.createJavaForStartUp();
            java.setDir(binDir);
            java.addSysproperty(this.createSysProperty("program.name", new File(binDir, "run.bat")));
            java.addSysproperty(this.createSysProperty("jboss.server.home.dir", new File(configDir, this.config)));
            java.addSysproperty(this.createSysProperty("jboss.server.home.url", new File(configDir, this.config).toURL().toString()));
            Path classPath = java.createClasspath();
            classPath.createPathElement().setLocation(new File(binDir, "run.jar"));
            try {
                classPath.createPathElement().setLocation(this.getToolsJar());
            }
            catch (FileNotFoundException fnfe) {
                this.getLog().warn((Object)"Couldn't find tools.jar (needed for JSP compilation)");
            }
            java.setClassname("org.jboss.Main");
            java.createArg().setValue("-c");
            java.createArg().setValue(this.config);
            java.execute();
        }
        catch (IOException ioe) {
            this.getLog().error((Object)"Failed to startup the container", (Throwable)ioe);
            throw new BuildException((Throwable)ioe);
        }
    }

    public final void shutDown() {
        File binDir = new File(this.dir, "bin");
        Java java = this.createJavaForShutDown();
        java.setFork(true);
        Path classPath = java.createClasspath();
        classPath.createPathElement().setLocation(new File(binDir, "shutdown.jar"));
        java.setClassname("org.jboss.Shutdown");
        if (this.version.startsWith("3.2")) {
            java.createArg().setValue("--shutdown");
        } else {
            java.createArg().setValue("localhost");
            java.createArg().setValue(String.valueOf(this.getPort()));
        }
        java.execute();
    }

    private void prepare(String theDirName) throws IOException {
        FileUtils fileUtils = FileUtils.newFileUtils();
        File configDir = new File(this.dir, "server");
        File deployDir = new File(configDir, this.config + "/deploy");
        fileUtils.copyFile(this.getDeployableFile().getFile(), new File(deployDir, this.getDeployableFile().getFile().getName()), null, true);
    }

    private String getVersion(File theDir) {
        String retVal = null;
        try {
            JarFile runJar = new JarFile(new File(theDir, "bin/run.jar"));
            Manifest mf = runJar.getManifest();
            if (mf != null) {
                Attributes attrs = mf.getMainAttributes();
                retVal = attrs.getValue(Attributes.Name.SPECIFICATION_VERSION);
            } else {
                this.getLog().warn((Object)("Couldn't find MANIFEST.MF in " + runJar));
            }
        }
        catch (IOException ioe) {
            this.getLog().warn((Object)"Couldn't retrieve JBoss version information", (Throwable)ioe);
        }
        return retVal;
    }
}

