/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cactus.integration.ant.container;

import java.io.File;
import java.io.FileNotFoundException;
import org.apache.cactus.integration.ant.container.AbstractContainer;
import org.apache.tools.ant.taskdefs.Java;
import org.apache.tools.ant.types.Environment;
import org.apache.tools.ant.types.Path;

public abstract class AbstractJavaContainer
extends AbstractContainer {
    private File output;
    private boolean append;

    public final void setOutput(File theOutput) {
        this.output = theOutput;
    }

    public final void setAppend(boolean isAppend) {
        this.append = isAppend;
    }

    protected final Java createJavaForShutDown() {
        Java java = (Java)this.createAntTask("java");
        java.setFork(true);
        return java;
    }

    protected final Java createJavaForStartUp() {
        Java java = (Java)this.createAntTask("java");
        java.setFork(true);
        java.setOutput(this.output);
        java.setAppend(this.append);
        for (int i = 0; i < this.getSystemProperties().length; ++i) {
            java.addSysproperty(this.createSysProperty(this.getSystemProperties()[i].getKey(), this.getSystemProperties()[i].getValue()));
        }
        return java;
    }

    protected final Environment.Variable createSysProperty(String theKey, File theFile) {
        Environment.Variable var = new Environment.Variable();
        var.setKey(theKey);
        var.setFile(theFile);
        return var;
    }

    protected final Environment.Variable createSysProperty(String theKey, Path thePath) {
        Environment.Variable var = new Environment.Variable();
        var.setKey(theKey);
        var.setPath(thePath);
        return var;
    }

    protected final Environment.Variable createSysProperty(String theKey, String theValue) {
        Environment.Variable var = new Environment.Variable();
        var.setKey(theKey);
        var.setValue(theValue);
        return var;
    }

    protected final File getToolsJar() throws FileNotFoundException {
        String javaHome = System.getProperty("java.home");
        File toolsJar = new File(javaHome + "/../lib/tools.jar");
        if (!toolsJar.isFile()) {
            throw new FileNotFoundException(toolsJar.getAbsolutePath());
        }
        return toolsJar;
    }
}

