/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cactus.integration.ant;

import java.io.File;
import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.cactus.integration.ant.deployment.WebXml;
import org.apache.cactus.integration.ant.deployment.WebXmlIo;
import org.apache.cactus.integration.ant.deployment.WebXmlMerger;
import org.apache.cactus.integration.ant.util.AntLog;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.XMLCatalog;
import org.xml.sax.EntityResolver;
import org.xml.sax.SAXException;

public class WebXmlMergeTask
extends Task {
    private File srcFile;
    private File mergeFile;
    private File destFile;
    private boolean force = false;
    private boolean indent = false;
    private String encoding;
    private XMLCatalog xmlCatalog = null;

    public void execute() throws BuildException {
        block10: {
            if (this.srcFile == null || !this.srcFile.isFile()) {
                throw new BuildException("The [srcfile] attribute is required");
            }
            if (this.destFile == null) {
                throw new BuildException("The [destfile] attribute is required");
            }
            try {
                if (this.mergeFile != null) {
                    if (!this.mergeFile.isFile()) {
                        throw new BuildException("The merge file doesn't exist");
                    }
                    if (this.force || this.srcFile.lastModified() > this.destFile.lastModified() || this.mergeFile.lastModified() > this.destFile.lastModified()) {
                        WebXml srcWebXml = WebXmlIo.parseWebXmlFromFile(this.srcFile, (EntityResolver)this.xmlCatalog);
                        WebXml mergeWebXml = WebXmlIo.parseWebXmlFromFile(this.mergeFile, (EntityResolver)this.xmlCatalog);
                        WebXmlMerger merger = new WebXmlMerger(srcWebXml);
                        merger.setLog(new AntLog(this));
                        merger.merge(mergeWebXml);
                        WebXmlIo.writeWebXml(srcWebXml, this.destFile);
                    } else {
                        this.log("The destination file is up to date", 3);
                    }
                    break block10;
                }
                throw new BuildException("The [mergefile] attribute is required");
            }
            catch (ParserConfigurationException pce) {
                throw new BuildException("XML parser configuration problem: " + pce.getMessage(), (Throwable)pce);
            }
            catch (SAXException saxe) {
                throw new BuildException("Failed to parse descriptor: " + saxe.getMessage(), (Throwable)saxe);
            }
            catch (IOException ioe) {
                throw new BuildException("An I/O error occurred: " + ioe.getMessage(), (Throwable)ioe);
            }
        }
    }

    public final void addConfiguredXMLCatalog(XMLCatalog theXmlCatalog) {
        if (this.xmlCatalog == null) {
            this.xmlCatalog = new XMLCatalog();
            this.xmlCatalog.setProject(this.getProject());
        }
        this.xmlCatalog.addConfiguredXMLCatalog(theXmlCatalog);
    }

    public final void setSrcFile(File theSrcFile) {
        this.srcFile = theSrcFile;
    }

    public final void setMergeFile(File theMergeFile) {
        this.mergeFile = theMergeFile;
    }

    public final void setDestFile(File theDestFile) {
        this.destFile = theDestFile;
    }

    public final void setForce(boolean isForce) {
        this.force = isForce;
    }

    public final void setEncoding(String theEncoding) {
        this.encoding = theEncoding;
    }

    public final void setIndent(boolean isIndent) {
        this.indent = isIndent;
    }
}

