/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cactus.integration.ant;

import java.net.URL;
import org.apache.cactus.integration.ant.container.ContainerRunner;
import org.apache.cactus.integration.ant.container.GenericContainer;
import org.apache.cactus.integration.ant.util.AntLog;
import org.apache.cactus.integration.ant.util.AntTaskFactory;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class RunServerTestsTask
extends Task {
    private GenericContainer container = new GenericContainer();
    private GenericContainer.Hook testHook;
    private URL testUrl;
    private long timeout = 180000L;
    private transient AntTaskFactory antTaskFactory = new AntTaskFactory(){

        public Task createTask(String theName) {
            Task retVal = RunServerTestsTask.this.getProject().createTask(theName);
            if (retVal != null) {
                retVal.setTaskName(RunServerTestsTask.this.getTaskName());
                retVal.setLocation(RunServerTestsTask.this.getLocation());
                retVal.setOwningTarget(RunServerTestsTask.this.getOwningTarget());
            }
            return retVal;
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws BuildException {
        if (!this.container.isStartUpSet()) {
            throw new BuildException("You must specify either a nested [start] element or the [starttarget] attribute");
        }
        if (!this.container.isShutDownSet()) {
            throw new BuildException("You must specify either a nested [stop] element or the [stoptarget] attribute");
        }
        if (this.testHook == null) {
            throw new BuildException("You must specify either a nested [test] element or the [testtarget] attribute");
        }
        if (this.testUrl == null) {
            throw new BuildException("The [testurl] attribute must be specified");
        }
        this.container.setAntTaskFactory(this.antTaskFactory);
        ContainerRunner runner = new ContainerRunner(this.container);
        runner.setLog(new AntLog(this));
        runner.setUrl(this.testUrl);
        runner.setTimeout(this.timeout);
        runner.startUpContainer();
        try {
            this.testHook.execute();
        }
        finally {
            runner.shutDownContainer();
        }
    }

    public GenericContainer.Hook createStart() {
        if (this.container.isStartUpSet()) {
            throw new BuildException("This task supports only one nested [start] element");
        }
        return this.container.createStartUp();
    }

    public void setStartTarget(String theStartTarget) {
        if (this.container.isStartUpSet()) {
            throw new BuildException("Either specify the [starttarget] attribute or the nested [start] element, but not both");
        }
        this.container.setStartUpTarget(theStartTarget);
    }

    public GenericContainer.Hook createStop() {
        if (this.container.isShutDownSet()) {
            throw new BuildException("This task supports only one nested [stop] element");
        }
        return this.container.createShutDown();
    }

    public void setStopTarget(String theStopTarget) {
        if (this.container.isShutDownSet()) {
            throw new BuildException("Either specify the [stoptarget] attribute or the nested [stop] element, but not both");
        }
        this.container.setShutDownTarget(theStopTarget);
    }

    public GenericContainer.Hook createTest() {
        if (this.testHook != null) {
            throw new BuildException("This task supports only one nested [test] element");
        }
        this.testHook = this.container.new GenericContainer.Hook();
        return this.testHook;
    }

    public void setTestTarget(String theTestTarget) {
        if (this.testHook != null) {
            throw new BuildException("Either specify the [testtarget] attribute or the nested [test] element, but not both");
        }
        this.testHook = this.container.new GenericContainer.Hook();
        this.testHook.setTarget(theTestTarget);
    }

    public void setTestUrl(URL theTestUrl) {
        this.testUrl = theTestUrl;
    }

    public void setTimeout(long theTimeout) {
        this.timeout = theTimeout;
    }
}

