/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cactus.integration.ant.deployment;

import java.util.ArrayList;
import java.util.Iterator;
import org.apache.cactus.integration.ant.deployment.WebXmlTag;
import org.apache.cactus.integration.ant.deployment.WebXmlVersion;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class WebXml {
    private static final WebXmlTag[] ELEMENT_ORDER = new WebXmlTag[]{WebXmlTag.ICON, WebXmlTag.DISPLAY_NAME, WebXmlTag.DESCRIPTION, WebXmlTag.DISTRIBUTABLE, WebXmlTag.FILTER, WebXmlTag.FILTER_MAPPING, WebXmlTag.LISTENER, WebXmlTag.SERVLET, WebXmlTag.SERVLET_MAPPING, WebXmlTag.SESSION_CONFIG, WebXmlTag.MIME_MAPPING, WebXmlTag.WELCOME_FILE_LIST, WebXmlTag.ERROR_PAGE, WebXmlTag.TAGLIB, WebXmlTag.RESOURCE_ENV_REF, WebXmlTag.RESOURCE_REF, WebXmlTag.SECURITY_CONSTRAINT, WebXmlTag.LOGIN_CONFIG, WebXmlTag.SECURITY_ROLE, WebXmlTag.ENV_ENTRY, WebXmlTag.EJB_REF, WebXmlTag.EJB_LOCAL_REF};
    private final Document document;
    private final Element rootElement;

    public WebXml(Document theDocument) {
        this.document = theDocument;
        this.rootElement = theDocument.getDocumentElement();
    }

    public final Document getDocument() {
        return this.document;
    }

    public final WebXmlVersion getVersion() {
        DocumentType docType = this.document.getDoctype();
        if (docType != null) {
            return WebXmlVersion.valueOf(docType);
        }
        return null;
    }

    public final void addFilter(String theFilterName, String theFilterClass) {
        if (theFilterName == null) {
            throw new NullPointerException();
        }
        if (this.hasFilter(theFilterName)) {
            throw new IllegalStateException("Filter '" + theFilterName + "' already defined");
        }
        Element filterElement = this.document.createElement(WebXmlTag.FILTER.getTagName());
        filterElement.appendChild(this.createNestedText(WebXmlTag.FILTER_NAME, theFilterName));
        filterElement.appendChild(this.createNestedText(WebXmlTag.FILTER_CLASS, theFilterClass));
        this.addElement(WebXmlTag.FILTER, filterElement);
    }

    public final void addFilter(Element theFilter) {
        this.checkElement(theFilter, WebXmlTag.FILTER);
        String filterName = this.getNestedText(theFilter, WebXmlTag.FILTER_NAME);
        if (filterName == null) {
            throw new IllegalArgumentException("Not a valid filter element");
        }
        if (this.hasFilter(filterName)) {
            throw new IllegalStateException("Filter '" + filterName + "' already defined");
        }
        this.addElement(WebXmlTag.FILTER, theFilter);
    }

    public final void addFilterInitParam(String theFilterName, String theParamName, String theParamValue) {
        Element filterElement = this.getFilter(theFilterName);
        if (filterElement == null) {
            throw new IllegalStateException("Filter '" + theFilterName + "' not defined");
        }
        this.addInitParam(filterElement, theParamName, theParamValue);
    }

    public final void addFilterMapping(String theFilterName, String theUrlPattern) {
        if (!this.hasFilter(theFilterName)) {
            throw new IllegalStateException("Filter '" + theFilterName + "' not defined");
        }
        Element filterMappingElement = this.document.createElement(WebXmlTag.FILTER_MAPPING.getTagName());
        filterMappingElement.appendChild(this.createNestedText(WebXmlTag.FILTER_NAME, theFilterName));
        filterMappingElement.appendChild(this.createNestedText(WebXmlTag.URL_PATTERN, theUrlPattern));
        this.addElement(WebXmlTag.FILTER_MAPPING, filterMappingElement);
    }

    public final Element getFilter(String theFilterName) {
        if (theFilterName == null) {
            throw new NullPointerException();
        }
        Iterator filterElements = this.getElements(WebXmlTag.FILTER);
        while (filterElements.hasNext()) {
            Element filterElement = (Element)filterElements.next();
            if (!theFilterName.equals(this.getNestedText(filterElement, WebXmlTag.FILTER_NAME))) continue;
            return filterElement;
        }
        return null;
    }

    public final Iterator getFilterNamesForClass(String theClassName) {
        if (theClassName == null) {
            throw new NullPointerException();
        }
        Iterator filterElements = this.getElements(WebXmlTag.FILTER);
        ArrayList<String> filterNames = new ArrayList<String>();
        while (filterElements.hasNext()) {
            Element filterElement = (Element)filterElements.next();
            if (!theClassName.equals(this.getNestedText(filterElement, WebXmlTag.FILTER_CLASS))) continue;
            filterNames.add(this.getNestedText(filterElement, WebXmlTag.FILTER_NAME));
        }
        return filterNames.iterator();
    }

    public final String getFilterInitParam(String theFilterName, String theParamName) {
        return this.getInitParam(this.getFilter(theFilterName), theParamName);
    }

    public final Iterator getFilterInitParamNames(String theFilterName) {
        return this.getInitParamNames(this.getFilter(theFilterName));
    }

    public final Iterator getFilterMappings(String theFilterName) {
        if (theFilterName == null) {
            throw new NullPointerException();
        }
        ArrayList<String> filterMappings = new ArrayList<String>();
        Iterator filterMappingElements = this.getElements(WebXmlTag.FILTER_MAPPING);
        while (filterMappingElements.hasNext()) {
            String urlPattern;
            Element filterMappingElement = (Element)filterMappingElements.next();
            if (!theFilterName.equals(this.getNestedText(filterMappingElement, WebXmlTag.FILTER_NAME)) || (urlPattern = this.getNestedText(filterMappingElement, WebXmlTag.URL_PATTERN)) == null) continue;
            filterMappings.add(urlPattern);
        }
        return filterMappings.iterator();
    }

    public final Iterator getFilterNames() {
        ArrayList<String> filterNames = new ArrayList<String>();
        Iterator filterElements = this.getElements(WebXmlTag.FILTER);
        while (filterElements.hasNext()) {
            Element filterElement = (Element)filterElements.next();
            String filterName = this.getNestedText(filterElement, WebXmlTag.FILTER_NAME);
            if (filterName == null) continue;
            filterNames.add(filterName);
        }
        return filterNames.iterator();
    }

    public final boolean hasFilter(String theFilterName) {
        return this.getFilter(theFilterName) != null;
    }

    public final void addJspFile(String theServletName, String theJspFile) {
        if (theServletName == null) {
            throw new NullPointerException();
        }
        if (this.hasFilter(theServletName)) {
            throw new IllegalStateException("Servlet '" + theServletName + "' already defined");
        }
        Element servletElement = this.document.createElement(WebXmlTag.SERVLET.getTagName());
        servletElement.appendChild(this.createNestedText(WebXmlTag.SERVLET_NAME, theServletName));
        servletElement.appendChild(this.createNestedText(WebXmlTag.JSP_FILE, theJspFile));
        this.addElement(WebXmlTag.SERVLET, servletElement);
    }

    public final void addServlet(String theServletName, String theServletClass) {
        if (theServletName == null) {
            throw new NullPointerException();
        }
        if (this.hasFilter(theServletName)) {
            throw new IllegalStateException("Servlet '" + theServletName + "' already defined");
        }
        Element servletElement = this.document.createElement(WebXmlTag.SERVLET.getTagName());
        servletElement.appendChild(this.createNestedText(WebXmlTag.SERVLET_NAME, theServletName));
        servletElement.appendChild(this.createNestedText(WebXmlTag.SERVLET_CLASS, theServletClass));
        this.addElement(WebXmlTag.SERVLET, servletElement);
    }

    public final void addServlet(Element theServlet) {
        this.checkElement(theServlet, WebXmlTag.SERVLET);
        String servletName = this.getNestedText(theServlet, WebXmlTag.SERVLET_NAME);
        if (servletName == null) {
            throw new IllegalArgumentException("Not a valid servlet element");
        }
        if (this.hasServlet(servletName)) {
            throw new IllegalStateException("Servlet '" + servletName + "' already defined");
        }
        this.addElement(WebXmlTag.SERVLET, theServlet);
    }

    public final void addServletInitParam(String theServletName, String theParamName, String theParamValue) {
        Element servletElement = this.getServlet(theServletName);
        if (servletElement == null) {
            throw new IllegalStateException("Servlet '" + theServletName + "' not defined");
        }
        this.addInitParam(servletElement, theParamName, theParamValue);
    }

    public final void addServletMapping(String theServletName, String theUrlPattern) {
        if (!this.hasServlet(theServletName)) {
            throw new IllegalStateException("Servlet '" + theServletName + "' not defined");
        }
        Element servletMappingElement = this.document.createElement(WebXmlTag.SERVLET_MAPPING.getTagName());
        servletMappingElement.appendChild(this.createNestedText(WebXmlTag.SERVLET_NAME, theServletName));
        servletMappingElement.appendChild(this.createNestedText(WebXmlTag.URL_PATTERN, theUrlPattern));
        this.addElement(WebXmlTag.SERVLET_MAPPING, servletMappingElement);
    }

    public final Element getServlet(String theServletName) {
        if (theServletName == null) {
            throw new NullPointerException();
        }
        Iterator servletElements = this.getElements(WebXmlTag.SERVLET);
        while (servletElements.hasNext()) {
            Element servletElement = (Element)servletElements.next();
            if (!theServletName.equals(this.getNestedText(servletElement, WebXmlTag.SERVLET_NAME))) continue;
            return servletElement;
        }
        return null;
    }

    public final String getServletInitParam(String theServletName, String theParamName) {
        return this.getInitParam(this.getServlet(theServletName), theParamName);
    }

    public final Iterator getServletInitParamNames(String theServletName) {
        return this.getInitParamNames(this.getServlet(theServletName));
    }

    public final Iterator getServletMappings(String theServletName) {
        if (theServletName == null) {
            throw new NullPointerException();
        }
        ArrayList<String> servletMappings = new ArrayList<String>();
        Iterator servletMappingElements = this.getElements(WebXmlTag.SERVLET_MAPPING);
        while (servletMappingElements.hasNext()) {
            String urlPattern;
            Element servletMappingElement = (Element)servletMappingElements.next();
            if (!theServletName.equals(this.getNestedText(servletMappingElement, WebXmlTag.SERVLET_NAME)) || (urlPattern = this.getNestedText(servletMappingElement, WebXmlTag.URL_PATTERN)) == null) continue;
            servletMappings.add(urlPattern);
        }
        return servletMappings.iterator();
    }

    public final Iterator getServletNames() {
        ArrayList<String> servletNames = new ArrayList<String>();
        Iterator servletElements = this.getElements(WebXmlTag.SERVLET);
        while (servletElements.hasNext()) {
            Element servletElement = (Element)servletElements.next();
            String servletName = this.getNestedText(servletElement, WebXmlTag.SERVLET_NAME);
            if (servletName == null) continue;
            servletNames.add(servletName);
        }
        return servletNames.iterator();
    }

    public final Iterator getServletNamesForClass(String theClassName) {
        if (theClassName == null) {
            throw new NullPointerException();
        }
        Iterator servletElements = this.getElements(WebXmlTag.SERVLET);
        ArrayList<String> servletNames = new ArrayList<String>();
        while (servletElements.hasNext()) {
            Element servletElement = (Element)servletElements.next();
            if (!theClassName.equals(this.getNestedText(servletElement, WebXmlTag.SERVLET_CLASS))) continue;
            servletNames.add(this.getNestedText(servletElement, WebXmlTag.SERVLET_NAME));
        }
        return servletNames.iterator();
    }

    public final Iterator getServletNamesForJspFile(String theJspFile) {
        if (theJspFile == null) {
            throw new NullPointerException();
        }
        Iterator servletElements = this.getElements(WebXmlTag.SERVLET);
        ArrayList<String> servletNames = new ArrayList<String>();
        while (servletElements.hasNext()) {
            Element servletElement = (Element)servletElements.next();
            if (!theJspFile.equals(this.getNestedText(servletElement, WebXmlTag.JSP_FILE))) continue;
            servletNames.add(this.getNestedText(servletElement, WebXmlTag.SERVLET_NAME));
        }
        return servletNames.iterator();
    }

    public final boolean hasServlet(String theServletName) {
        return this.getServlet(theServletName) != null;
    }

    public final Iterator getElements(WebXmlTag theTag) {
        ArrayList<Node> elements = new ArrayList<Node>();
        NodeList nodeList = this.rootElement.getElementsByTagName(theTag.getTagName());
        for (int i = 0; i < nodeList.getLength(); ++i) {
            elements.add(nodeList.item(i));
        }
        return elements.iterator();
    }

    public final void addElement(WebXmlTag theTag, Element theElement) {
        this.checkElement(theElement, theTag);
        if (!theTag.isMultipleAllowed() && this.getElements(theTag).hasNext()) {
            throw new IllegalStateException("The tag '" + theTag + "' may not occur more than once in the descriptor");
        }
        Node importedNode = this.document.importNode(theElement, true);
        Node refNode = this.getInsertionPointFor(theTag);
        this.rootElement.insertBefore(importedNode, refNode);
    }

    public final void replaceElement(WebXmlTag theTag, Element theElement) {
        Iterator elements = this.getElements(theTag);
        while (elements.hasNext()) {
            Element element = (Element)elements.next();
            element.getParentNode().removeChild(element);
        }
        this.addElement(theTag, theElement);
    }

    private void addInitParam(Element theElement, String theParamName, String theParamValue) {
        Element initParamElement = this.document.createElement(WebXmlTag.INIT_PARAM.getTagName());
        initParamElement.appendChild(this.createNestedText(WebXmlTag.PARAM_NAME, theParamName));
        initParamElement.appendChild(this.createNestedText(WebXmlTag.PARAM_VALUE, theParamValue));
        theElement.appendChild(initParamElement);
    }

    private void checkElement(Element theElement, WebXmlTag theExpectedTag) throws IllegalArgumentException {
        if (!theExpectedTag.getTagName().equals(theElement.getNodeName())) {
            throw new IllegalArgumentException("Not a '" + theExpectedTag + "' element");
        }
    }

    private Element createNestedText(WebXmlTag theTag, String theText) {
        Element element = this.document.createElement(theTag.getTagName());
        element.appendChild(this.document.createTextNode(theText));
        return element;
    }

    private String getInitParam(Element theElement, String theParamName) {
        if (theElement != null) {
            NodeList initParamElements = theElement.getElementsByTagName(WebXmlTag.INIT_PARAM.getTagName());
            for (int i = 0; i < initParamElements.getLength(); ++i) {
                Element initParamElement = (Element)initParamElements.item(i);
                String paramName = this.getNestedText(initParamElement, WebXmlTag.PARAM_NAME);
                if (!theParamName.equals(paramName)) continue;
                return this.getNestedText(initParamElement, WebXmlTag.PARAM_VALUE);
            }
        }
        return null;
    }

    private Iterator getInitParamNames(Element theElement) {
        ArrayList<String> initParamNames = new ArrayList<String>();
        if (theElement != null) {
            NodeList initParamElements = theElement.getElementsByTagName(WebXmlTag.INIT_PARAM.getTagName());
            for (int i = 0; i < initParamElements.getLength(); ++i) {
                Element initParamElement = (Element)initParamElements.item(i);
                String paramName = this.getNestedText(initParamElement, WebXmlTag.PARAM_NAME);
                if (paramName == null) continue;
                initParamNames.add(paramName);
            }
        }
        return initParamNames.iterator();
    }

    private Node getInsertionPointFor(WebXmlTag theTag) {
        for (int i = 0; i < ELEMENT_ORDER.length; ++i) {
            if (ELEMENT_ORDER[i] != theTag) continue;
            for (int j = i + 1; j < ELEMENT_ORDER.length; ++j) {
                NodeList elements = this.rootElement.getElementsByTagName(ELEMENT_ORDER[j].getTagName());
                if (elements.getLength() <= 0) continue;
                Node result = elements.item(0);
                Node previous = result.getPreviousSibling();
                while (previous != null && (previous.getNodeType() == 8 || previous.getNodeType() == 3)) {
                    result = previous;
                    previous = result.getPreviousSibling();
                }
                return result;
            }
            break;
        }
        return null;
    }

    private String getNestedText(Element theElement, WebXmlTag theTag) {
        Node nestedText;
        NodeList nestedElements = theElement.getElementsByTagName(theTag.getTagName());
        if (nestedElements.getLength() > 0 && (nestedText = nestedElements.item(0).getFirstChild()) != null) {
            return nestedText.getNodeValue();
        }
        return null;
    }
}

