/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cactus.integration.ant;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import org.apache.cactus.integration.ant.util.HttpProbe;
import org.apache.cactus.integration.api.deployable.DeployableFile;
import org.apache.cactus.integration.api.deployable.EarParser;
import org.apache.cactus.integration.api.deployable.WarParser;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.optional.junit.JUnitTask;
import org.apache.tools.ant.taskdefs.optional.junit.JUnitTest;
import org.apache.tools.ant.types.Environment;
import org.apache.tools.ant.types.Path;

public class CactusTestTask
extends JUnitTask {
    private String serverName;
    private String servletPort;
    private String contextURL;
    private File toDir;
    private File logs;
    private File earFile;
    private File warFile;
    private boolean runLocal;
    private DeployableFile deployableFile;
    private Path additionalClasspath;
    private long timeout = 180000L;
    private long checkInterval = 500L;

    public void init() {
        super.init();
        this.addClasspathEntry("/org/apache/cactus/ServletTestCase.class");
        this.addClasspathEntry("/org/apache/commons/logging/Log.class");
        this.addClasspathEntry("/org/apache/commons/httpclient/HttpClient.class");
    }

    public void execute() throws BuildException {
        if (this.warFile != null && this.earFile != null) {
            throw new BuildException("You must specify either the [warfile] or the [earfile] attribute but not both");
        }
        if (this.warFile == null && this.earFile == null) {
            throw new BuildException("You must specify either the [warfile] or the [earfile] attribute");
        }
        this.deployableFile = this.warFile != null ? WarParser.parse((File)this.warFile) : EarParser.parse((File)this.earFile);
        this.addRedirectorNameProperties();
        if (this.runLocal) {
            this.log("Tests run locally", 3);
            super.execute();
            return;
        }
        if (this.contextURL == null) {
            if (this.servletPort == null) {
                this.log("Using default servletport=8080", 2);
                this.servletPort = "8080";
            }
            if (this.serverName == null) {
                this.log("Using default servername=localhost", 2);
                this.serverName = "localhost";
            }
        }
        if (this.toDir == null) {
            throw new BuildException("You must specify the test report directory");
        }
        Environment.Variable contextUrlVar = new Environment.Variable();
        contextUrlVar.setKey("cactus.contextURL");
        if (this.contextURL != null) {
            contextUrlVar.setValue(this.contextURL);
        } else {
            contextUrlVar.setValue("http://" + this.serverName + ":" + this.servletPort + "/" + this.deployableFile.getTestContext());
        }
        this.addSysproperty(contextUrlVar);
        this.setupLogs();
        this.testInContainer();
    }

    private void addRedirectorNameProperties() {
        String filterRedirectorMapping = this.deployableFile.getFilterRedirectorMapping();
        if (filterRedirectorMapping != null) {
            Environment.Variable filterRedirectorVar = new Environment.Variable();
            filterRedirectorVar.setKey("cactus.filterRedirectorName");
            filterRedirectorVar.setValue(filterRedirectorMapping.substring(1));
            this.addSysproperty(filterRedirectorVar);
        } else {
            this.log("No mapping of the filter redirector found", 3);
        }
        String jspRedirectorMapping = this.deployableFile.getJspRedirectorMapping();
        if (jspRedirectorMapping != null) {
            Environment.Variable jspRedirectorVar = new Environment.Variable();
            jspRedirectorVar.setKey("cactus.jspRedirectorName");
            jspRedirectorVar.setValue(jspRedirectorMapping.substring(1));
            this.addSysproperty(jspRedirectorVar);
        } else {
            this.log("No mapping of the JSP redirector found", 3);
        }
        String servletRedirectorMapping = this.deployableFile.getServletRedirectorMapping();
        if (servletRedirectorMapping == null) {
            throw new BuildException("The WAR has not been cactified");
        }
        Environment.Variable servletRedirectorVar = new Environment.Variable();
        servletRedirectorVar.setKey("cactus.servletRedirectorName");
        servletRedirectorVar.setValue(servletRedirectorMapping.substring(1));
        this.addSysproperty(servletRedirectorVar);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testInContainer() {
        URL testURL = null;
        try {
            testURL = this.contextURL == null ? new URL("http://" + this.serverName + ":" + this.servletPort + "/" + this.deployableFile.getTestContext() + this.deployableFile.getServletRedirectorMapping() + "?Cactus_Service=RUN_TEST") : new URL(this.contextURL + this.deployableFile.getServletRedirectorMapping() + "?Cactus_Service=RUN_TEST");
        }
        catch (MalformedURLException e) {
            throw new BuildException("Invalid URL format: " + testURL);
        }
        try {
            HttpProbe httpProbe = new HttpProbe(testURL);
            if (httpProbe.timeout(this.timeout, this.checkInterval)) {
                throw new BuildException("Failed to start the container after more than [" + this.timeout + "] ms. Trying to connect " + "to the [" + testURL + "] test URL yielded an " + "error code. Please run in debug mode for more details  " + "about the error.");
            }
        }
        catch (InterruptedException ie) {
            throw new BuildException("Unexpected thread interruption");
        }
        catch (IOException io) {
            throw new BuildException("Http reading exception");
        }
        this.log("Starting up tests", 3);
        try {
            Enumeration tests = this.getIndividualTests();
            while (tests.hasMoreElements()) {
                JUnitTest test = (JUnitTest)tests.nextElement();
                if (!test.shouldRun(this.getProject())) continue;
                test.setTodir(this.toDir);
                this.execute(test);
            }
        }
        finally {
            this.log("Finishing tests", 3);
        }
    }

    public final void setEarFile(File theEarFile) {
        if (this.warFile != null) {
            throw new BuildException("You may only specify one of [earfile] and [warfile]");
        }
        this.earFile = theEarFile;
    }

    public final void setWarFile(File theWarFile) {
        if (this.earFile != null) {
            throw new BuildException("You may only specify one of [earfile] and [warfile]");
        }
        this.warFile = theWarFile;
    }

    public final void setServerName(String theServerName) {
        this.serverName = theServerName;
    }

    public final void setServletPort(String theServletPort) {
        this.servletPort = theServletPort;
    }

    public final void setContextURL(String theContextURL) {
        this.contextURL = theContextURL;
    }

    public final void setToDir(File theToDir) {
        this.toDir = theToDir;
    }

    public final void setRunLocal(boolean theRunLocal) {
        this.runLocal = theRunLocal;
    }

    public final void setLogs(File theLogs) {
        this.logs = theLogs;
    }

    public void setTimeout(long theTimeout) {
        this.timeout = theTimeout;
    }

    public void setupLogs() {
        if (this.logs == null) {
            throw new BuildException("Missing 'logs' attribute");
        }
        PropertyResourceBundle bundle = null;
        try {
            bundle = new PropertyResourceBundle(new FileInputStream(this.logs));
        }
        catch (IOException e) {
            throw new BuildException("Failed to load properties file [" + this.logs + "]");
        }
        Enumeration<String> keys = ((ResourceBundle)bundle).getKeys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            Environment.Variable var = new Environment.Variable();
            var.setKey(key);
            var.setValue(bundle.getString(key));
            super.addSysproperty(var);
        }
    }
}

