/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cactus.integration.ant;

import java.net.URL;
import org.apache.cactus.container.ContainerRunner;
import org.apache.cactus.container.ContainerWrapper;
import org.apache.cactus.integration.ant.container.GenericContainer;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.codehaus.cargo.util.AntTaskFactory;
import org.codehaus.cargo.util.DefaultAntTaskFactory;
import org.codehaus.cargo.util.log.AntLogger;
import org.codehaus.cargo.util.log.Logger;

public class RunServerTestsTask
extends Task {
    private GenericContainer container = new GenericContainer();
    private GenericContainer.Hook testHook;
    private URL testURL;
    private long timeout = 180000L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws BuildException {
        if (!this.container.isStartUpSet()) {
            throw new BuildException("You must specify either a nested [start] element or the [starttarget] attribute");
        }
        if (!this.container.isShutDownSet()) {
            throw new BuildException("You must specify either a nested [stop] element or the [stoptarget] attribute");
        }
        if (this.testHook == null) {
            throw new BuildException("You must specify either a nested [test] element or the [testtarget] attribute");
        }
        if (this.testURL == null) {
            throw new BuildException("The [testurl] attribute must be specified");
        }
        this.container.setAntTaskFactory((AntTaskFactory)new DefaultAntTaskFactory(this.getProject(), this.getTaskName(), this.getLocation(), this.getOwningTarget()));
        ContainerRunner runner = new ContainerRunner((ContainerWrapper)this.container);
        runner.setLogger((Logger)new AntLogger(this.getProject()));
        runner.setURL(this.testURL);
        runner.setTimeout(this.timeout);
        runner.startUpContainer();
        try {
            this.testHook.execute();
        }
        finally {
            runner.shutDownContainer();
        }
    }

    public final GenericContainer.Hook createStart() {
        if (this.container.isStartUpSet()) {
            throw new BuildException("This task supports only one nested [start] element");
        }
        return this.container.createStartUp();
    }

    public void setStartTarget(String theStartTarget) {
        if (this.container.isStartUpSet()) {
            throw new BuildException("Either specify the [starttarget] attribute or the nested [start] element, but not both");
        }
        this.container.setStartUpTarget(theStartTarget);
    }

    public final GenericContainer.Hook createStop() {
        if (this.container.isShutDownSet()) {
            throw new BuildException("This task supports only one nested [stop] element");
        }
        return this.container.createShutDown();
    }

    public void setStopTarget(String theStopTarget) {
        if (this.container.isShutDownSet()) {
            throw new BuildException("Either specify the [stoptarget] attribute or the nested [stop] element, but not both");
        }
        this.container.setShutDownTarget(theStopTarget);
    }

    public final GenericContainer.Hook createTest() {
        if (this.testHook != null) {
            throw new BuildException("This task supports only one nested [test] element");
        }
        this.testHook = this.container.new GenericContainer.Hook();
        return this.testHook;
    }

    public void setTestTarget(String theTestTarget) {
        if (this.testHook != null) {
            throw new BuildException("Either specify the [testtarget] attribute or the nested [test] element, but not both");
        }
        this.testHook = this.container.new GenericContainer.Hook();
        this.testHook.setTarget(theTestTarget);
    }

    public void setTestURL(URL theTestURL) {
        this.testURL = theTestURL;
    }

    public void setTimeout(long theTimeout) {
        this.timeout = theTimeout;
    }
}

