/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cactus.integration.ant.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;

public class HttpProbe {
    private URL url;

    public HttpProbe(URL theUrl) {
        this.url = theUrl;
    }

    public boolean timeout(long theWaitedTime, long theCheckedInterval) throws InterruptedException, IOException {
        long startTime = System.currentTimeMillis();
        int responseCode = -1;
        do {
            if (System.currentTimeMillis() - startTime > theWaitedTime) {
                return true;
            }
            this.sleep(theCheckedInterval);
        } while (!this.isAvailable(responseCode = this.testConnectivity()));
        return false;
    }

    public int testConnectivity() throws IOException {
        int code = -1;
        HttpURLConnection connection = null;
        connection = (HttpURLConnection)this.url.openConnection();
        connection.setRequestProperty("Connection", "close");
        connection.connect();
        code = connection.getResponseCode();
        this.readFully(connection);
        connection.disconnect();
        return code;
    }

    private boolean isAvailable(int theCode) {
        boolean result = theCode != -1 && theCode < 300;
        return result;
    }

    private String retrieveServerName() throws IOException {
        String retVal = null;
        HttpURLConnection connection = (HttpURLConnection)this.url.openConnection();
        connection.connect();
        retVal = connection.getHeaderField("Server");
        connection.disconnect();
        return retVal;
    }

    private void readFully(HttpURLConnection theConnection) throws IOException {
        if (theConnection.getContentLength() != 0) {
            byte[] buf = new byte[256];
            InputStream in = theConnection.getInputStream();
            while (in.read(buf) != -1) {
            }
        }
    }

    private void sleep(long theMs) throws InterruptedException {
        Thread.sleep(theMs);
    }
}

