/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.spi.configuration;

import java.io.IOException;
import org.apache.tools.ant.types.FilterChain;
import org.codehaus.cargo.container.ContainerException;
import org.codehaus.cargo.container.configuration.ConfigurationType;
import org.codehaus.cargo.container.configuration.StandaloneLocalConfiguration;
import org.codehaus.cargo.container.spi.configuration.AbstractLocalConfiguration;

public abstract class AbstractStandaloneLocalConfiguration
extends AbstractLocalConfiguration
implements StandaloneLocalConfiguration {
    public AbstractStandaloneLocalConfiguration(String dir) {
        super(dir);
        this.setProperty("cargo.logging", "medium");
    }

    protected void setupConfigurationDir() throws IOException {
        String timestampFile = this.getFileHandler().append(this.getHome(), ".cargo");
        if (!(this.getFileHandler().exists(timestampFile) || this.getFileHandler().exists(this.getHome()) && this.getFileHandler().isDirectoryEmpty(this.getHome()) || !this.getFileHandler().exists(this.getHome()))) {
            throw new ContainerException("Invalid configuration dir [" + this.getHome() + "]. " + "When using standalone configurations, the configuration dir must point to an " + "empty directory. Note that everything in that dir will get deleted by Cargo.");
        }
        this.getFileHandler().delete(this.getHome());
        this.getFileHandler().mkdirs(this.getHome());
        this.getFileHandler().createFile(timestampFile);
    }

    protected final FilterChain createFilterChain() {
        FilterChain filterChain = new FilterChain();
        this.getAntUtils().addTokenToFilterChain(filterChain, "cargo.protocol", this.getPropertyValue("cargo.protocol"));
        this.getAntUtils().addTokenToFilterChain(filterChain, "cargo.servlet.port", this.getPropertyValue("cargo.servlet.port"));
        this.getAntUtils().addTokenToFilterChain(filterChain, "cargo.hostname", this.getPropertyValue("cargo.hostname"));
        return filterChain;
    }

    public void verify() {
        super.verify();
        this.verifyLogging();
    }

    private void verifyLogging() {
        String level = this.getPropertyValue("cargo.logging");
        if (!(level.equalsIgnoreCase("low") || level.equalsIgnoreCase("medium") || level.equalsIgnoreCase("high"))) {
            throw new ContainerException("Invalid logging level [" + level + "]. Valid levels are {\"low\", \"medium\", " + "\"high\"}");
        }
    }

    public ConfigurationType getType() {
        return ConfigurationType.STANDALONE;
    }
}

