/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.generic.deployable;

import java.lang.reflect.Constructor;
import org.codehaus.cargo.container.deployable.Deployable;
import org.codehaus.cargo.container.deployable.DeployableType;
import org.codehaus.cargo.container.deployable.EAR;
import org.codehaus.cargo.container.deployable.EJB;
import org.codehaus.cargo.container.deployable.WAR;
import org.codehaus.cargo.generic.deployable.DeployableFactory;
import org.codehaus.cargo.generic.internal.util.RegistrationKey;
import org.codehaus.cargo.generic.internal.util.SimpleContainerIdentity;
import org.codehaus.cargo.generic.spi.AbstractGenericHintFactory;
import org.codehaus.cargo.generic.spi.AbstractIntrospectionGenericHintFactory;

public class DefaultDeployableFactory
extends AbstractIntrospectionGenericHintFactory
implements DeployableFactory {
    private static final String DEFAULT_CONTAINER_ID = "default";

    public DefaultDeployableFactory() {
        this.registerDeployable(DEFAULT_CONTAINER_ID, DeployableType.WAR, WAR.class);
        this.registerDeployable(DEFAULT_CONTAINER_ID, DeployableType.EJB, EJB.class);
        this.registerDeployable(DEFAULT_CONTAINER_ID, DeployableType.EAR, EAR.class);
        this.registerDeployable("tomcat5x", DeployableType.WAR, "org.codehaus.cargo.container.tomcat.TomcatWAR");
        this.registerDeployable("geronimo1x", DeployableType.WAR, "org.codehaus.cargo.container.geronimo.deployable.GeronimoWAR");
        this.registerDeployable("geronimo1x", DeployableType.EJB, "org.codehaus.cargo.container.geronimo.deployable.GeronimoEJB");
        this.registerDeployable("geronimo1x", DeployableType.EAR, "org.codehaus.cargo.container.geronimo.deployable.GeronimoEAR");
    }

    public void registerDeployable(String containerId, DeployableType deployableType, Class deployableClass) {
        this.registerImplementation(new RegistrationKey(new SimpleContainerIdentity(containerId), deployableType.getType()), deployableClass);
    }

    public void registerDeployable(String containerId, DeployableType deployableType, String deployableClassName) {
        this.registerImplementation(new RegistrationKey(new SimpleContainerIdentity(containerId), deployableType.getType()), deployableClassName);
    }

    public boolean isDeployableRegistered(String containerId, DeployableType deployableType) {
        return this.hasMapping(new RegistrationKey(new SimpleContainerIdentity(containerId), deployableType.getType()));
    }

    public Deployable createDeployable(String containerId, String deployableLocation, DeployableType deployableType) {
        DeployableFactoryParameters parameters = new DeployableFactoryParameters();
        parameters.deployable = deployableLocation;
        Deployable deployable = this.isDeployableRegistered(containerId, deployableType) ? (Deployable)this.createImplementation(new RegistrationKey(new SimpleContainerIdentity(containerId), deployableType.getType()), parameters, "deployable") : (Deployable)this.createImplementation(new RegistrationKey(new SimpleContainerIdentity(DEFAULT_CONTAINER_ID), deployableType.getType()), parameters, "deployable");
        return deployable;
    }

    protected Constructor getConstructor(Class deployableClass, String hint, AbstractGenericHintFactory.GenericParameters parameters) throws NoSuchMethodException {
        return deployableClass.getConstructor(String.class);
    }

    protected Object createInstance(Constructor constructor, String hint, AbstractGenericHintFactory.GenericParameters parameters) throws Exception {
        String deployable = ((DeployableFactoryParameters)parameters).deployable;
        return constructor.newInstance(deployable);
    }

    private static class DeployableFactoryParameters
    implements AbstractGenericHintFactory.GenericParameters {
        public String deployable;

        private DeployableFactoryParameters() {
        }
    }
}

