/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.deployer;

import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.codehaus.cargo.container.deployer.DeployableMonitor;
import org.codehaus.cargo.container.deployer.DeployableMonitorListener;
import org.codehaus.cargo.container.internal.util.HttpUtils;
import org.codehaus.cargo.util.log.LoggedObject;

public class URLDeployableMonitor
extends LoggedObject
implements DeployableMonitor {
    private List listeners = new ArrayList();
    private URL pingURL;
    private HttpUtils httpUtils = new HttpUtils();
    private long timeout;

    public URLDeployableMonitor(URL pingURL) {
        this(pingURL, 20000L);
    }

    public URLDeployableMonitor(URL pingURL, long timeout) {
        this.timeout = timeout;
        this.pingURL = pingURL;
    }

    public String getDeployableName() {
        return this.pingURL.toString();
    }

    public void registerListener(DeployableMonitorListener listener) {
        this.listeners.add(listener);
    }

    public void monitor() {
        this.getLogger().debug("Checking URL [" + this.pingURL + "] for status using a timeout of [" + this.timeout + "] ms...", this.getClass().getName());
        HttpUtils.HttpResult results = new HttpUtils.HttpResult();
        boolean isDeployed = this.httpUtils.ping(this.pingURL, results);
        this.getLogger().debug("URL [" + this.pingURL + "] is " + (isDeployed ? "" : "not ") + "responding...", this.getClass().getName());
        Iterator it = this.listeners.iterator();
        while (it.hasNext()) {
            DeployableMonitorListener listener = (DeployableMonitorListener)it.next();
            this.getLogger().debug("Notifying monitor listener [" + listener + "]", this.getClass().getName());
            if (isDeployed) {
                listener.deployed();
                continue;
            }
            listener.undeployed();
        }
    }

    public long getTimeout() {
        return this.timeout;
    }
}

