/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.net;

import ch.qos.logback.core.AppenderBase;
import ch.qos.logback.core.Layout;
import ch.qos.logback.core.net.SyslogWriter;
import java.io.IOException;
import java.net.SocketException;
import java.net.UnknownHostException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SyslogAppenderBase<E>
extends AppenderBase<E> {
    static final String SYSLOG_LAYOUT_URL = "http://logback.qos.ch/codes.html#syslog_layout";
    static final int MSG_SIZE_LIMIT = 262144;
    int facility;
    String facilityStr;
    String syslogHost;
    protected String suffixPattern;
    SyslogWriter sw;
    int port = 514;

    @Override
    public void start() {
        int errorCount = 0;
        if (this.facilityStr == null) {
            this.addError("The Facility option is mandatory");
            ++errorCount;
        }
        this.facility = SyslogAppenderBase.facilityStringToint(this.facilityStr);
        try {
            this.sw = new SyslogWriter(this.syslogHost, this.port);
        }
        catch (UnknownHostException e) {
            this.addError("Could not create SyslogWriter", e);
            ++errorCount;
        }
        catch (SocketException e) {
            ++errorCount;
            this.addError("Failed to bind to a random datagram socket ", e);
        }
        if (this.layout == null) {
            this.layout = this.buildLayout(this.facilityStr);
        }
        if (errorCount == 0) {
            super.start();
        }
    }

    public abstract Layout<E> buildLayout(String var1);

    public abstract int getSeverityForEvent(Object var1);

    @Override
    protected void append(E eventObject) {
        if (!this.isStarted()) {
            return;
        }
        try {
            String msg = this.layout.doLayout(eventObject);
            if (msg != null && msg.length() > 262144) {
                msg = msg.substring(0, 262144);
            }
            this.sw.write(msg);
            this.sw.flush();
            this.postProcess(eventObject, this.sw);
        }
        catch (IOException ioe) {
            this.addError("Failed to send diagram to " + this.syslogHost, ioe);
            this.stop();
        }
    }

    protected void postProcess(Object event, SyslogWriter sw) {
    }

    public static int facilityStringToint(String facilityStr) {
        if ("KERN".equalsIgnoreCase(facilityStr)) {
            return 0;
        }
        if ("USER".equalsIgnoreCase(facilityStr)) {
            return 8;
        }
        if ("MAIL".equalsIgnoreCase(facilityStr)) {
            return 16;
        }
        if ("DAEMON".equalsIgnoreCase(facilityStr)) {
            return 24;
        }
        if ("AUTH".equalsIgnoreCase(facilityStr)) {
            return 32;
        }
        if ("SYSLOG".equalsIgnoreCase(facilityStr)) {
            return 40;
        }
        if ("LPR".equalsIgnoreCase(facilityStr)) {
            return 48;
        }
        if ("NEWS".equalsIgnoreCase(facilityStr)) {
            return 56;
        }
        if ("UUCP".equalsIgnoreCase(facilityStr)) {
            return 64;
        }
        if ("CRON".equalsIgnoreCase(facilityStr)) {
            return 72;
        }
        if ("AUTHPRIV".equalsIgnoreCase(facilityStr)) {
            return 80;
        }
        if ("FTP".equalsIgnoreCase(facilityStr)) {
            return 88;
        }
        if ("LOCAL0".equalsIgnoreCase(facilityStr)) {
            return 128;
        }
        if ("LOCAL1".equalsIgnoreCase(facilityStr)) {
            return 136;
        }
        if ("LOCAL2".equalsIgnoreCase(facilityStr)) {
            return 144;
        }
        if ("LOCAL3".equalsIgnoreCase(facilityStr)) {
            return 152;
        }
        if ("LOCAL4".equalsIgnoreCase(facilityStr)) {
            return 160;
        }
        if ("LOCAL5".equalsIgnoreCase(facilityStr)) {
            return 168;
        }
        if ("LOCAL6".equalsIgnoreCase(facilityStr)) {
            return 176;
        }
        if ("LOCAL7".equalsIgnoreCase(facilityStr)) {
            return 184;
        }
        throw new IllegalArgumentException(facilityStr + " is not a valid syslog facility string");
    }

    public String getSyslogHost() {
        return this.syslogHost;
    }

    public void setSyslogHost(String syslogHost) {
        this.syslogHost = syslogHost;
    }

    public String getFacility() {
        return this.facilityStr;
    }

    public void setFacility(String facilityStr) {
        if (facilityStr != null) {
            facilityStr = facilityStr.trim();
        }
        this.facilityStr = facilityStr;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    @Override
    public Layout<E> getLayout() {
        return this.layout;
    }

    @Override
    public void setLayout(Layout<E> layout) {
        this.addWarn("The layout of a SyslogAppender cannot be set directly. See also http://logback.qos.ch/codes.html#syslog_layout");
    }

    @Override
    public void stop() {
        this.sw.close();
        super.stop();
    }

    public String getSuffixPattern() {
        return this.suffixPattern;
    }

    public void setSuffixPattern(String suffixPattern) {
        this.suffixPattern = suffixPattern;
    }
}

