/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.rolling;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.ContextBase;
import ch.qos.logback.core.encoder.EchoEncoder;
import ch.qos.logback.core.rolling.helper.FileFilterUtil;
import ch.qos.logback.core.rolling.helper.FileNamePattern;
import ch.qos.logback.core.testUtil.FileToBufferUtil;
import ch.qos.logback.core.testUtil.RandomUtil;
import java.io.File;
import java.io.IOException;
import java.sql.Date;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.List;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.junit.Assert;

public class ScaffoldingForRollingTests {
    public static final String DATE_PATTERN_WITH_SECONDS = "yyyy-MM-dd_HH_mm_ss";
    public static final String DATE_PATTERN_BY_DAY = "yyyy-MM-dd";
    public static final SimpleDateFormat SDF = new SimpleDateFormat("yyyy-MM-dd_HH_mm_ss");
    int diff = RandomUtil.getPositiveInt();
    protected String randomOutputDir = "target/test-output/" + this.diff + "/";
    EchoEncoder<Object> encoder = new EchoEncoder();
    Context context = new ContextBase();
    protected List<String> expectedFilenameList = new ArrayList<String>();
    protected long nextRolloverThreshold;
    protected long currentTime;
    protected List<Future<?>> futureList = new ArrayList();
    Calendar calendar = Calendar.getInstance();

    public void setUp() {
        this.context.setName("test");
        this.calendar.set(14, 333);
        this.currentTime = this.calendar.getTimeInMillis();
        this.recomputeRolloverThreshold(this.currentTime);
    }

    public static void existenceCheck(String filename) {
        Assert.assertTrue((String)("File " + filename + " does not exist"), (boolean)new File(filename).exists());
    }

    public static File[] getFilesInDirectory(String outputDirStr) {
        File outputDir = new File(outputDirStr);
        return outputDir.listFiles();
    }

    public static void fileContentCheck(File[] fileArray, int runLength, String prefix) throws IOException {
        ScaffoldingForRollingTests.fileContentCheck(fileArray, runLength, prefix, 0);
    }

    public static void fileContentCheck(File[] fileArray, int runLength, String prefix, int runStart) throws IOException {
        ArrayList<String> stringList = new ArrayList<String>();
        for (File file : fileArray) {
            FileToBufferUtil.readIntoList(file, stringList);
        }
        ArrayList<String> witnessList = new ArrayList<String>();
        for (int i = runStart; i < runLength; ++i) {
            witnessList.add(prefix + i);
        }
        Assert.assertEquals(witnessList, stringList);
    }

    public static void sortedContentCheck(String outputDirStr, int runLength, String prefix) throws IOException {
        ScaffoldingForRollingTests.sortedContentCheck(outputDirStr, runLength, prefix, 0);
    }

    public static void sortedContentCheck(String outputDirStr, int runLength, String prefix, int runStart) throws IOException {
        File[] fileArray = ScaffoldingForRollingTests.getFilesInDirectory(outputDirStr);
        FileFilterUtil.sortFileArrayByName((File[])fileArray);
        ScaffoldingForRollingTests.fileContentCheck(fileArray, runLength, prefix, runStart);
    }

    public static void reverseSortedContentCheck(String outputDirStr, int runLength, String prefix) throws IOException {
        File[] fileArray = ScaffoldingForRollingTests.getFilesInDirectory(outputDirStr);
        FileFilterUtil.reverseSortFileArrayByName((File[])fileArray);
        ScaffoldingForRollingTests.fileContentCheck(fileArray, runLength, prefix);
    }

    public static void existenceCheck(List<String> filenameList) {
        for (String filename : filenameList) {
            Assert.assertTrue((String)("File " + filename + " does not exist"), (boolean)new File(filename).exists());
        }
    }

    public static int existenceCount(List<String> filenameList) {
        int existenceCounter = 0;
        for (String filename : filenameList) {
            if (!new File(filename).exists()) continue;
            ++existenceCounter;
        }
        return existenceCounter;
    }

    String testId2FileName(String testId) {
        return this.randomOutputDir + testId + ".log";
    }

    protected void recomputeRolloverThreshold(long ct) {
        long delta = ct % 1000L;
        this.nextRolloverThreshold = ct - delta + 1000L;
    }

    protected boolean passThresholdTime(long nextRolloverThreshold) {
        return this.currentTime >= nextRolloverThreshold;
    }

    protected void incCurrentTime(long increment) {
        this.currentTime += increment;
    }

    protected Date getDateOfCurrentPeriodsStart() {
        long delta = this.currentTime % 1000L;
        return new Date(this.currentTime - delta);
    }

    protected Date getDateOfPreviousPeriodsStart() {
        long delta = this.currentTime % 1000L;
        return new Date(this.currentTime - delta - 1000L);
    }

    protected long getMillisOfCurrentPeriodsStart() {
        long delta = this.currentTime % 1000L;
        return this.currentTime - delta;
    }

    protected void addExpectedFileName_ByDate(String patternStr, long millis) {
        FileNamePattern fileNamePattern = new FileNamePattern(patternStr, this.context);
        String fn = fileNamePattern.convert((Object)new Date(millis));
        this.expectedFilenameList.add(fn);
    }

    void addExpectedFileNamedIfItsTime_ByDate(String fileNamePatternStr) {
        if (this.passThresholdTime(this.nextRolloverThreshold)) {
            this.addExpectedFileName_ByDate(fileNamePatternStr, this.getMillisOfCurrentPeriodsStart());
            this.recomputeRolloverThreshold(this.currentTime);
        }
    }

    protected void addExpectedFileName_ByDate(String outputDir, String testId, Date date, boolean gzExtension) {
        String fn = outputDir + testId + "-" + SDF.format(date);
        if (gzExtension) {
            fn = fn + ".gz";
        }
        this.expectedFilenameList.add(fn);
    }

    protected void addExpectedFileName_ByFileIndexCounter(String randomOutputDir, String testId, long millis, int fileIndexCounter, String compressionSuffix) {
        String fn = randomOutputDir + testId + "-" + SDF.format(millis) + "-" + fileIndexCounter + ".txt" + compressionSuffix;
        this.expectedFilenameList.add(fn);
    }

    protected List<String> filterElementsInListBySuffix(String suffix) {
        ArrayList<String> zipFiles = new ArrayList<String>();
        for (String filename : this.expectedFilenameList) {
            if (!filename.endsWith(suffix)) continue;
            zipFiles.add(filename);
        }
        return zipFiles;
    }

    protected void addExpectedFileNamedIfItsTime_ByDate(String outputDir, String testId, boolean gzExtension) {
        if (this.passThresholdTime(this.nextRolloverThreshold)) {
            this.addExpectedFileName_ByDate(outputDir, testId, this.getDateOfCurrentPeriodsStart(), gzExtension);
            this.recomputeRolloverThreshold(this.currentTime);
        }
    }

    void massageExpectedFilesToCorresponToCurrentTarget(String fileName, boolean fileOptionIsSet) {
        int lastIndex = this.expectedFilenameList.size() - 1;
        String last = this.expectedFilenameList.remove(lastIndex);
        if (fileOptionIsSet) {
            this.expectedFilenameList.add(fileName);
        } else if (last.endsWith(".gz")) {
            int lastLen = last.length();
            String stem = last.substring(0, lastLen - 3);
            this.expectedFilenameList.add(stem);
        }
    }

    String addGZIfNotLast(int i) {
        int lastIndex = this.expectedFilenameList.size() - 1;
        if (i != lastIndex) {
            return ".gz";
        }
        return "";
    }

    void zipEntryNameCheck(List<String> expectedFilenameList, String pattern) throws IOException {
        for (String filepath : expectedFilenameList) {
            this.checkZipEntryName(filepath, pattern);
        }
    }

    void checkZipEntryMatchesZipFilename(List<String> expectedFilenameList) throws IOException {
        for (String filepath : expectedFilenameList) {
            String stripped = this.stripStemFromZipFilename(filepath);
            this.checkZipEntryName(filepath, stripped);
        }
    }

    String stripStemFromZipFilename(String filepath) {
        File filepathAsFile = new File(filepath);
        String stem = filepathAsFile.getName();
        int stemLen = stem.length();
        return stem.substring(0, stemLen - ".zip".length());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkZipEntryName(String filepath, String pattern) throws IOException {
        System.out.println("Checking [" + filepath + "]");
        ZipFile zf = new ZipFile(filepath);
        try {
            Enumeration<? extends ZipEntry> entries = zf.entries();
            assert (entries.hasMoreElements());
            ZipEntry firstZipEntry = entries.nextElement();
            assert (!entries.hasMoreElements());
            System.out.println("Testing zip entry [" + firstZipEntry.getName() + "]");
            Assert.assertTrue((boolean)firstZipEntry.getName().matches(pattern));
        }
        finally {
            if (zf != null) {
                zf.close();
            }
        }
    }

    protected void add(Future<?> future) {
        if (future == null) {
            return;
        }
        if (!this.futureList.contains(future)) {
            this.futureList.add(future);
        }
    }

    protected void waitForJobsToComplete() {
        for (Future<?> future : this.futureList) {
            try {
                future.get(10L, TimeUnit.SECONDS);
            }
            catch (Exception e) {
                new RuntimeException("unexpected exception while testing", e);
            }
        }
        this.futureList.clear();
    }
}

