/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.util;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipInputStream;

public class Compare {
    static final int B1_NULL = -1;
    static final int B2_NULL = -2;

    public static boolean compare(String file1, String file2) throws FileNotFoundException, IOException {
        if (file1.endsWith(".gz")) {
            return Compare.gzFileCompare(file1, file2);
        }
        if (file1.endsWith(".zip")) {
            return Compare.zipFileCompare(file1, file2);
        }
        return Compare.regularFileCompare(file1, file2);
    }

    static BufferedReader gzFileToBufferedReader(String file) throws IOException {
        FileInputStream fis = new FileInputStream(file);
        GZIPInputStream gzis = new GZIPInputStream(fis);
        return new BufferedReader(new InputStreamReader(gzis));
    }

    static BufferedReader zipFileToBufferedReader(String file) throws IOException {
        FileInputStream fis = new FileInputStream(file);
        ZipInputStream zis = new ZipInputStream(fis);
        zis.getNextEntry();
        return new BufferedReader(new InputStreamReader(zis));
    }

    public static boolean gzFileCompare(String file1, String file2) throws IOException {
        BufferedReader in1 = Compare.gzFileToBufferedReader(file1);
        BufferedReader in2 = Compare.gzFileToBufferedReader(file2);
        return Compare.bufferCompare(in1, in2, file1, file2);
    }

    public static boolean zipFileCompare(String file1, String file2) throws IOException {
        BufferedReader in1 = Compare.zipFileToBufferedReader(file1);
        BufferedReader in2 = Compare.zipFileToBufferedReader(file2);
        return Compare.bufferCompare(in1, in2, file1, file2);
    }

    public static boolean regularFileCompare(String file1, String file2) throws FileNotFoundException, IOException {
        BufferedReader in1 = new BufferedReader(new FileReader(file1));
        BufferedReader in2 = new BufferedReader(new FileReader(file2));
        return Compare.bufferCompare(in1, in2, file1, file2);
    }

    public static boolean bufferCompare(BufferedReader in1, BufferedReader in2, String file1, String file2) throws FileNotFoundException, IOException {
        String s1;
        int lineCounter = 0;
        while ((s1 = in1.readLine()) != null) {
            ++lineCounter;
            String s2 = in2.readLine();
            if (s1.equals(s2)) continue;
            System.out.println("Files [" + file1 + "] and [" + file2 + "] differ on line " + lineCounter);
            System.out.println("One reads:  [" + s1 + "].");
            System.out.println("Other reads:[" + s2 + "].");
            Compare.outputFile(file1);
            Compare.outputFile(file2);
            return false;
        }
        if (in2.read() != -1) {
            System.out.println("File [" + file2 + "] longer than file [" + file1 + "].");
            Compare.outputFile(file1);
            Compare.outputFile(file2);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void outputFile(String file) throws FileNotFoundException, IOException {
        BufferedReader in1 = null;
        try {
            String s1;
            in1 = new BufferedReader(new FileReader(file));
            int lineCounter = 0;
            System.out.println("--------------------------------");
            System.out.println("Contents of " + file + ":");
            while ((s1 = in1.readLine()) != null) {
                System.out.print(++lineCounter);
                if (lineCounter < 10) {
                    System.out.print("   : ");
                } else if (lineCounter < 100) {
                    System.out.print("  : ");
                } else if (lineCounter < 1000) {
                    System.out.print(" : ");
                } else {
                    System.out.print(": ");
                }
                System.out.println(s1);
            }
        }
        catch (Throwable throwable) {
            Compare.close(in1);
            throw throwable;
        }
        Compare.close(in1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean gzCompare(String file1, String file2) throws FileNotFoundException, IOException {
        boolean bl;
        BufferedReader in2;
        BufferedReader in1;
        block5: {
            block6: {
                boolean bl2;
                in1 = null;
                in2 = null;
                try {
                    String s1;
                    in1 = new BufferedReader(new InputStreamReader(new GZIPInputStream(new FileInputStream(file1))));
                    in2 = new BufferedReader(new InputStreamReader(new GZIPInputStream(new FileInputStream(file2))));
                    int lineCounter = 0;
                    while ((s1 = in1.readLine()) != null) {
                        ++lineCounter;
                        String s2 = in2.readLine();
                        if (s1.equals(s2)) continue;
                        System.out.println("Files [" + file1 + "] and [" + file2 + "] differ on line " + lineCounter);
                        System.out.println("One reads:  [" + s1 + "].");
                        System.out.println("Other reads:[" + s2 + "].");
                        Compare.outputFile(file1);
                        Compare.outputFile(file2);
                        bl = false;
                        break block5;
                    }
                    if (in2.read() == -1) break block6;
                    System.out.println("File [" + file2 + "] longer than file [" + file1 + "].");
                    Compare.outputFile(file1);
                    Compare.outputFile(file2);
                    bl2 = false;
                }
                catch (Throwable throwable) {
                    Compare.close(in1);
                    Compare.close(in2);
                    throw throwable;
                }
                Compare.close(in1);
                Compare.close(in2);
                return bl2;
            }
            boolean bl3 = true;
            Compare.close(in1);
            Compare.close(in2);
            return bl3;
        }
        Compare.close(in1);
        Compare.close(in2);
        return bl;
    }

    static void close(Reader r) {
        if (r != null) {
            try {
                r.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

