/*
 * Decompiled with CFR 0.152.
 */
package cn.jpush.api.image;

import cn.jiguang.common.ClientConfig;
import cn.jiguang.common.ServiceHelper;
import cn.jiguang.common.connection.HttpProxy;
import cn.jiguang.common.connection.IHttpClient;
import cn.jiguang.common.connection.NativeHttpClient;
import cn.jiguang.common.resp.APIConnectionException;
import cn.jiguang.common.resp.APIRequestException;
import cn.jiguang.common.resp.ResponseWrapper;
import cn.jiguang.common.utils.Preconditions;
import cn.jiguang.common.utils.StringUtils;
import cn.jpush.api.image.model.ImageFilePayload;
import cn.jpush.api.image.model.ImageSource;
import cn.jpush.api.image.model.ImageUploadResult;
import cn.jpush.api.image.model.ImageUrlPayload;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonSyntaxException;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImageClient {
    protected static final Logger LOG = LoggerFactory.getLogger(ImageClient.class);
    private IHttpClient _httpClient;
    private String _baseUrl;
    private String _imagesPath;
    private Gson _gson = new Gson();

    public ImageClient(String masterSecret, String appKey) {
        this(masterSecret, appKey, null, ClientConfig.getInstance());
    }

    public ImageClient(String masterSecret, String appKey, HttpProxy proxy, ClientConfig conf) {
        this._baseUrl = (String)conf.get((Object)"push.host.name");
        this._imagesPath = (String)conf.get((Object)"jpush.v3.images.path");
        String authCode = ServiceHelper.getBasicAuthorization((String)appKey, (String)masterSecret);
        this._httpClient = new NativeHttpClient(authCode, proxy, conf);
    }

    public ImageUploadResult uploadImage(ImageUrlPayload imageUrlPayload) throws APIConnectionException, APIRequestException {
        Preconditions.checkArgument((imageUrlPayload.getImageType() != null ? 1 : 0) != 0, (Object)"Image type should not be null");
        this.checkImageUrlPayload(imageUrlPayload);
        NativeHttpClient client = (NativeHttpClient)this._httpClient;
        String url = this._baseUrl + this._imagesPath + "/" + ImageSource.URL.value();
        JsonElement jsonElement = imageUrlPayload.toJSON();
        String content = this._gson.toJson(jsonElement);
        ResponseWrapper responseWrapper = client.sendPost(url, content);
        if (responseWrapper.responseCode != 200) {
            LOG.error("upload image failed: {}", (Object)responseWrapper);
        }
        ImageUploadResult imageUploadResult = (ImageUploadResult)this._gson.fromJson(responseWrapper.responseContent, ImageUploadResult.class);
        LOG.info("upload image result:{}", (Object)imageUploadResult);
        return imageUploadResult;
    }

    public ImageUploadResult uploadImage(ImageFilePayload imageFilePayload) {
        ImageUploadResult imageUploadResult;
        Preconditions.checkArgument((imageFilePayload.getImageType() != null ? 1 : 0) != 0, (Object)"Image type should not be null");
        this.checkImageFilePayload(imageFilePayload);
        NativeHttpClient client = (NativeHttpClient)this._httpClient;
        String url = this._baseUrl + this._imagesPath + "/" + ImageSource.FILE.value();
        HashMap<String, String> textMap = new HashMap<String, String>();
        textMap.put("image_type", String.valueOf(imageFilePayload.getImageType().value()));
        Map<String, String> fileMap = imageFilePayload.toFileMap();
        LOG.debug("upload fileMap: {}", fileMap);
        String response = client.formUploadByPost(url, textMap, fileMap, null);
        LOG.debug("upload image result: {}", (Object)response);
        try {
            imageUploadResult = (ImageUploadResult)this._gson.fromJson(response, ImageUploadResult.class);
        }
        catch (JsonSyntaxException e) {
            LOG.error("could not parse response: {}", (Object)response);
            throw new IllegalStateException("could not parse response", e);
        }
        LOG.info("upload image result:{}", (Object)imageUploadResult);
        return imageUploadResult;
    }

    public ImageUploadResult modifyImage(String mediaId, ImageUrlPayload imageUrlPayload) throws APIConnectionException, APIRequestException {
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((String)mediaId), (Object)"mediaId should not be empty");
        this.checkImageUrlPayload(imageUrlPayload);
        NativeHttpClient client = (NativeHttpClient)this._httpClient;
        String url = this._baseUrl + this._imagesPath + "/" + ImageSource.URL.value() + "/" + mediaId;
        JsonElement jsonElement = imageUrlPayload.toJSON();
        String content = this._gson.toJson(jsonElement);
        ResponseWrapper responseWrapper = client.sendPut(url, content);
        if (responseWrapper.responseCode != 200) {
            LOG.error("upload image failed: {}", (Object)responseWrapper);
        }
        ImageUploadResult imageUploadResult = (ImageUploadResult)this._gson.fromJson(responseWrapper.responseContent, ImageUploadResult.class);
        LOG.info("upload image result:{}", (Object)imageUploadResult);
        return imageUploadResult;
    }

    public ImageUploadResult modifyImage(String mediaId, ImageFilePayload imageFilePayload) {
        ImageUploadResult imageUploadResult;
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((String)mediaId), (Object)"mediaId should not be empty");
        this.checkImageFilePayload(imageFilePayload);
        NativeHttpClient client = (NativeHttpClient)this._httpClient;
        String url = this._baseUrl + this._imagesPath + "/" + ImageSource.FILE.value() + "/" + mediaId;
        Map<String, String> fileMap = imageFilePayload.toFileMap();
        LOG.debug("upload image fileMap: {}", fileMap);
        String response = client.formUploadByPut(url, null, fileMap, null);
        LOG.debug("upload image result: {}", (Object)response);
        try {
            imageUploadResult = (ImageUploadResult)this._gson.fromJson(response, ImageUploadResult.class);
        }
        catch (JsonSyntaxException e) {
            LOG.error("could not parse response: {}", (Object)response);
            throw new IllegalStateException("could not parse response", e);
        }
        LOG.info("upload image result:{}", (Object)imageUploadResult);
        return imageUploadResult;
    }

    private void checkImageUrlPayload(ImageUrlPayload imageUrlPayload) {
        boolean anyUrlNotEmpty = StringUtils.isNotEmpty((String)imageUrlPayload.getImageUrl()) || StringUtils.isNotEmpty((String)imageUrlPayload.getFcmImageUrl()) || StringUtils.isNotEmpty((String)imageUrlPayload.getHuaweiImageUrl()) || StringUtils.isNotEmpty((String)imageUrlPayload.getOppoImageUrl()) || StringUtils.isNotEmpty((String)imageUrlPayload.getXiaomiImageUrl()) || StringUtils.isNotEmpty((String)imageUrlPayload.getJiguangImageUrl());
        Preconditions.checkArgument((boolean)anyUrlNotEmpty, (Object)"Require at least 1 non-empty url");
    }

    private void checkImageFilePayload(ImageFilePayload imageFilePayload) {
        boolean anyFileNotEmpty = StringUtils.isNotEmpty((String)imageFilePayload.getOppoFileName()) || StringUtils.isNotEmpty((String)imageFilePayload.getXiaomiFileName());
        Preconditions.checkArgument((boolean)anyFileNotEmpty, (Object)"Require at least 1 non-empty fileName. Currently only support Xiaomi and OPPO");
    }
}

