/*
 * Decompiled with CFR 0.152.
 */
package cn.springcloud.dubbo.eureka;

import cn.springcloud.dubbo.eureka.EurekaDubboRegistryAutoConfiguration;
import com.alibaba.dubbo.common.URL;
import com.alibaba.dubbo.registry.NotifyListener;
import com.alibaba.dubbo.registry.support.FailbackRegistry;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.netflix.appinfo.InstanceInfo;
import com.netflix.discovery.CacheRefreshedEvent;
import com.netflix.discovery.EurekaClient;
import com.netflix.discovery.EurekaEventListener;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class EurekaDubboRegistry
extends FailbackRegistry {
    private static final Logger logger = LoggerFactory.getLogger(EurekaDubboRegistry.class);
    private ConcurrentHashMap<URL, NotifyListener> subscribeMap = new ConcurrentHashMap();
    private EurekaClient eurekaClient = null;
    private ObjectMapper objectMapper = new ObjectMapper();
    private TypeReference<TreeSet<String>> stringListTypeReference = new TypeReference<TreeSet<String>>(){};
    private EurekaEventListener eurekaEventListener = event -> {
        if (event instanceof CacheRefreshedEvent) {
            HashSet registeredProviders = new HashSet();
            this.eurekaClient.getApplications().getRegisteredApplications().stream().forEach(application -> application.getInstances().stream().forEach(instanceInfo -> {
                String metadataCategory = (String)instanceInfo.getMetadata().get("providers");
                if (!StringUtils.isEmpty((Object)metadataCategory)) {
                    try {
                        TreeSet values = (TreeSet)this.objectMapper.readValue(metadataCategory, this.stringListTypeReference);
                        values.stream().forEach(s -> registeredProviders.add(URL.valueOf((String)s)));
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }));
            for (Map.Entry<URL, NotifyListener> entry : this.subscribeMap.entrySet()) {
                URL key = entry.getKey();
                if (!key.getParameter("category").contains("providers")) continue;
                List urlList = registeredProviders.stream().filter(url -> url.getServiceKey().equals(key.getServiceKey())).collect(Collectors.toList());
                entry.getValue().notify(urlList);
            }
        }
    };
    int waitCount = 0;
    private ConcurrentLinkedQueue<URL> registerQueue = new ConcurrentLinkedQueue();
    private Thread registerThread = new Thread("EurekaDubboRegistry.registerThread"){

        @Override
        public void run() {
            while (EurekaDubboRegistry.this.waitCount < 10 || !EurekaDubboRegistry.this.registerQueue.isEmpty()) {
                if (EurekaDubboRegistry.this.eurekaClient == null) {
                    try {
                        EurekaDubboRegistry.this.eurekaClient = (EurekaClient)EurekaDubboRegistryAutoConfiguration.getApplicationContext().getBean(EurekaClient.class);
                        EurekaDubboRegistry.this.eurekaClient.registerEventListener(EurekaDubboRegistry.this.eurekaEventListener);
                    }
                    catch (Exception e) {
                        try {
                            Thread.sleep(3000L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    continue;
                }
                URL url = (URL)EurekaDubboRegistry.this.registerQueue.poll();
                if (url == null) {
                    ++EurekaDubboRegistry.this.waitCount;
                    try {
                        Thread.sleep(3000L);
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                EurekaDubboRegistry.this.waitCount = 0;
                EurekaDubboRegistry.this.doRegister(url);
            }
            logger.info("==========registerThread done==========");
        }
    };

    public EurekaDubboRegistry(URL url) {
        super(url);
        this.registerThread.start();
    }

    protected void doRegister(URL url) {
        if (this.eurekaClient == null) {
            this.registerQueue.add(url);
        } else {
            String category = url.getParameter("category");
            if (StringUtils.isEmpty((Object)category)) {
                category = "providers";
            }
            this.addOrDeleteMetadata(url, category, true);
        }
    }

    protected void doUnregister(URL url) {
        if (this.eurekaClient == null) {
            this.registerQueue.remove(url);
        } else {
            String category = url.getParameter("category");
            this.addOrDeleteMetadata(url, category, false);
        }
    }

    protected void doSubscribe(URL url, NotifyListener listener) {
        this.subscribeMap.put(url, listener);
    }

    protected void doUnsubscribe(URL url, NotifyListener listener) {
        this.subscribeMap.remove(url);
    }

    public boolean isAvailable() {
        return true;
    }

    private void addOrDeleteMetadata(URL url, String category, boolean isAdd) {
        InstanceInfo instanceInfo = this.eurekaClient.getApplicationInfoManager().getInfo();
        Map metadata = instanceInfo.getMetadata();
        String metadataCategory = (String)metadata.get(category);
        try {
            TreeSet values;
            TreeSet treeSet = values = StringUtils.isEmpty((Object)metadataCategory) ? new TreeSet() : (TreeSet)this.objectMapper.readValue(metadataCategory, this.stringListTypeReference);
            if (isAdd) {
                values.add(url.toString());
            } else {
                values.remove(url.toString());
            }
            metadata.put(category, this.objectMapper.writeValueAsString((Object)values));
            this.eurekaClient.getApplicationInfoManager().registerAppMetadata(metadata);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

