/*
 * Decompiled with CFR 0.152.
 */
package cn.springcloud.feign;

import feign.Feign;
import feign.MethodMetadata;
import feign.Param;
import feign.RequestTemplate;
import feign.Util;
import feign.VenusBaseContract;
import io.swagger.annotations.ApiImplicitParam;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.openfeign.AnnotatedParameterProcessor;
import org.springframework.cloud.openfeign.annotation.PathVariableParameterProcessor;
import org.springframework.cloud.openfeign.annotation.RequestHeaderParameterProcessor;
import org.springframework.cloud.openfeign.annotation.RequestParamParameterProcessor;
import org.springframework.cloud.openfeign.support.SpringMvcContract;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.core.DefaultParameterNameDiscoverer;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.ResourceLoader;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

public class VenusSpringMvcContract
extends VenusBaseContract
implements ResourceLoaderAware {
    private static final Logger LOGGER = LoggerFactory.getLogger(VenusSpringMvcContract.class);
    private Pattern pattern = Pattern.compile("(\\{[^}]+\\})");
    private Field requestTemplateUrl = ReflectionUtils.findField(RequestTemplate.class, (String)"url");
    private static final String ACCEPT = "Accept";
    private static final String CONTENT_TYPE = "Content-Type";
    private static final ParameterNameDiscoverer PARAMETER_NAME_DISCOVERER = new DefaultParameterNameDiscoverer();
    private final Map<Class<? extends Annotation>, AnnotatedParameterProcessor> annotatedArgumentProcessors;
    private final Map<String, Method> processedMethods;
    private final ConversionService conversionService;
    private final Param.Expander expander;
    private ResourceLoader resourceLoader;

    public VenusSpringMvcContract() {
        this(Collections.emptyList());
    }

    public VenusSpringMvcContract(List<AnnotatedParameterProcessor> annotatedParameterProcessors) {
        this(annotatedParameterProcessors, (ConversionService)new DefaultConversionService());
    }

    public VenusSpringMvcContract(List<AnnotatedParameterProcessor> annotatedParameterProcessors, ConversionService conversionService) {
        this.requestTemplateUrl.setAccessible(true);
        this.processedMethods = new HashMap<String, Method>();
        this.resourceLoader = new DefaultResourceLoader();
        Assert.notNull(annotatedParameterProcessors, (String)"Parameter processors can not be null.");
        Assert.notNull((Object)conversionService, (String)"ConversionService can not be null.");
        List<AnnotatedParameterProcessor> processors = !annotatedParameterProcessors.isEmpty() ? new ArrayList<AnnotatedParameterProcessor>(annotatedParameterProcessors) : this.getDefaultAnnotatedArgumentsProcessors();
        this.annotatedArgumentProcessors = this.toAnnotatedArgumentProcessorMap(processors);
        this.conversionService = conversionService;
        this.expander = new SpringMvcContract.ConvertingExpander(conversionService);
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    protected void processAnnotationOnClass(MethodMetadata data, Class<?> clz) {
        RequestMapping classAnnotation;
        if (clz.getInterfaces().length == 0 && (classAnnotation = (RequestMapping)AnnotatedElementUtils.findMergedAnnotation(clz, RequestMapping.class)) != null && classAnnotation.value().length > 0) {
            String pathValue = Util.emptyToNull((String)classAnnotation.value()[0]);
            if (!(pathValue = this.resolve(pathValue)).startsWith("/")) {
                pathValue = "/" + pathValue;
            }
            data.template().insert(0, (CharSequence)pathValue);
        }
    }

    private String defaultValue(Method method, String pathVariable) {
        Set apiImplicitParams = AnnotatedElementUtils.findAllMergedAnnotations((AnnotatedElement)method, ApiImplicitParam.class);
        for (ApiImplicitParam apiImplicitParam : apiImplicitParams) {
            if (!pathVariable.equals(apiImplicitParam.name())) continue;
            return apiImplicitParam.allowableValues().split(",")[0].trim();
        }
        throw new IllegalArgumentException("no default value for " + pathVariable);
    }

    private boolean hasPathVariable(MethodMetadata methodMetadata, String pathVariable) {
        for (Collection names : methodMetadata.indexToName().values()) {
            if (!names.contains(pathVariable)) continue;
            return true;
        }
        return false;
    }

    @Override
    public MethodMetadata parseAndValidateMetadata(Class<?> targetType, Method method) {
        String rawUrl;
        this.processedMethods.put(Feign.configKey(targetType, (Method)method), method);
        MethodMetadata md = super.parseAndValidateMetadata(targetType, method);
        RequestMapping classAnnotation = (RequestMapping)AnnotatedElementUtils.findMergedAnnotation(targetType, RequestMapping.class);
        if (classAnnotation != null) {
            if (!md.template().headers().containsKey(ACCEPT)) {
                this.parseProduces(md, method, classAnnotation);
            }
            if (!md.template().headers().containsKey(CONTENT_TYPE)) {
                this.parseConsumes(md, method, classAnnotation);
            }
            this.parseHeaders(md, method, classAnnotation);
        }
        String url = rawUrl = md.template().url();
        ArrayList<String> pathVariableList = new ArrayList<String>();
        Matcher matcher = this.pattern.matcher(url);
        while (matcher.find()) {
            String rawPathVariable;
            String pathVariable = matcher.group();
            int endIndex = pathVariable.indexOf(":");
            if (endIndex != -1) {
                rawPathVariable = pathVariable.substring(1, endIndex);
                pathVariableList.add(rawPathVariable);
                url = url.replace(pathVariable, "{" + rawPathVariable + "}");
                continue;
            }
            rawPathVariable = pathVariable.substring(1, pathVariable.length() - 1);
            pathVariableList.add(rawPathVariable);
        }
        for (String pathVariable : pathVariableList) {
            if (this.hasPathVariable(md, pathVariable)) continue;
            url = url.replace("{" + pathVariable + "}", this.defaultValue(method, pathVariable));
            ReflectionUtils.setField((Field)this.requestTemplateUrl, (Object)md.template(), (Object)new StringBuilder(url));
        }
        LOGGER.info("{} > {}", (Object)rawUrl, (Object)url);
        return md;
    }

    protected void processAnnotationOnMethod(MethodMetadata data, Annotation methodAnnotation, Method method) {
        String pathValue;
        if (!RequestMapping.class.isInstance(methodAnnotation) && !methodAnnotation.annotationType().isAnnotationPresent(RequestMapping.class)) {
            return;
        }
        RequestMapping methodMapping = (RequestMapping)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, RequestMapping.class);
        Object[] methods = methodMapping.method();
        if (methods.length == 0) {
            methods = new RequestMethod[]{RequestMethod.GET};
        }
        this.checkOne(method, methods, "method");
        data.template().method(methods[0].name());
        this.checkAtMostOne(method, methodMapping.value(), "value");
        if (methodMapping.value().length > 0 && (pathValue = Util.emptyToNull((String)methodMapping.value()[0])) != null) {
            if (!(pathValue = this.resolve(pathValue)).startsWith("/") && !data.template().toString().endsWith("/")) {
                pathValue = "/" + pathValue;
            }
            data.template().append((CharSequence)pathValue);
        }
        this.parseProduces(data, method, methodMapping);
        this.parseConsumes(data, method, methodMapping);
        this.parseHeaders(data, method, methodMapping);
        data.indexToExpander(new LinkedHashMap());
    }

    private String resolve(String value) {
        if (StringUtils.hasText((String)value) && this.resourceLoader instanceof ConfigurableApplicationContext) {
            return ((ConfigurableApplicationContext)this.resourceLoader).getEnvironment().resolvePlaceholders(value);
        }
        return value;
    }

    private void checkAtMostOne(Method method, Object[] values, String fieldName) {
        Util.checkState((values != null && (values.length == 0 || values.length == 1) ? 1 : 0) != 0, (String)"Method %s can only contain at most 1 %s field. Found: %s", (Object[])new Object[]{method.getName(), fieldName, values == null ? null : Arrays.asList(values)});
    }

    private void checkOne(Method method, Object[] values, String fieldName) {
        Util.checkState((values != null && values.length == 1 ? 1 : 0) != 0, (String)"Method %s can only contain 1 %s field. Found: %s", (Object[])new Object[]{method.getName(), fieldName, values == null ? null : Arrays.asList(values)});
    }

    protected boolean processAnnotationsOnParameter(MethodMetadata data, Annotation[] annotations, int paramIndex) {
        boolean isHttpAnnotation = false;
        SimpleAnnotatedParameterContext context = new SimpleAnnotatedParameterContext(data, paramIndex);
        Method method = this.processedMethods.get(data.configKey());
        for (Annotation parameterAnnotation : annotations) {
            AnnotatedParameterProcessor processor = this.annotatedArgumentProcessors.get(parameterAnnotation.annotationType());
            if (processor == null) continue;
            Annotation processParameterAnnotation = this.synthesizeWithMethodParameterNameAsFallbackValue(parameterAnnotation, method, paramIndex);
            isHttpAnnotation |= processor.processArgument((AnnotatedParameterProcessor.AnnotatedParameterContext)context, processParameterAnnotation, method);
        }
        if (isHttpAnnotation && data.indexToExpander().get(paramIndex) == null && this.conversionService.canConvert(method.getParameterTypes()[paramIndex], String.class)) {
            data.indexToExpander().put(paramIndex, this.expander);
        }
        return isHttpAnnotation;
    }

    private void parseProduces(MethodMetadata md, Method method, RequestMapping annotation) {
        String clientAccepts;
        String[] serverProduces = annotation.produces();
        String string = clientAccepts = serverProduces.length == 0 ? null : Util.emptyToNull((String)serverProduces[0]);
        if (clientAccepts != null) {
            md.template().header(ACCEPT, new String[]{clientAccepts});
        }
    }

    private void parseConsumes(MethodMetadata md, Method method, RequestMapping annotation) {
        String clientProduces;
        String[] serverConsumes = annotation.consumes();
        String string = clientProduces = serverConsumes.length == 0 ? null : Util.emptyToNull((String)serverConsumes[0]);
        if (clientProduces != null) {
            md.template().header(CONTENT_TYPE, new String[]{clientProduces});
        }
    }

    private void parseHeaders(MethodMetadata md, Method method, RequestMapping annotation) {
        if (annotation.headers() != null && annotation.headers().length > 0) {
            for (String header : annotation.headers()) {
                int index = header.indexOf(61);
                if (header.contains("!=") || index < 0) continue;
                md.template().header(this.resolve(header.substring(0, index)), new String[]{this.resolve(header.substring(index + 1).trim())});
            }
        }
    }

    private Map<Class<? extends Annotation>, AnnotatedParameterProcessor> toAnnotatedArgumentProcessorMap(List<AnnotatedParameterProcessor> processors) {
        HashMap<Class<? extends Annotation>, AnnotatedParameterProcessor> result = new HashMap<Class<? extends Annotation>, AnnotatedParameterProcessor>();
        for (AnnotatedParameterProcessor processor : processors) {
            result.put(processor.getAnnotationType(), processor);
        }
        return result;
    }

    private List<AnnotatedParameterProcessor> getDefaultAnnotatedArgumentsProcessors() {
        ArrayList<AnnotatedParameterProcessor> annotatedArgumentResolvers = new ArrayList<AnnotatedParameterProcessor>();
        annotatedArgumentResolvers.add((AnnotatedParameterProcessor)new PathVariableParameterProcessor());
        annotatedArgumentResolvers.add((AnnotatedParameterProcessor)new RequestParamParameterProcessor());
        annotatedArgumentResolvers.add((AnnotatedParameterProcessor)new RequestHeaderParameterProcessor());
        return annotatedArgumentResolvers;
    }

    private Annotation synthesizeWithMethodParameterNameAsFallbackValue(Annotation parameterAnnotation, Method method, int parameterIndex) {
        String[] parameterNames;
        Type[] parameterTypes;
        Map annotationAttributes = AnnotationUtils.getAnnotationAttributes((Annotation)parameterAnnotation);
        Object defaultValue = AnnotationUtils.getDefaultValue((Annotation)parameterAnnotation);
        if (defaultValue instanceof String && defaultValue.equals(annotationAttributes.get("value")) && this.shouldAddParameterName(parameterIndex, parameterTypes = method.getGenericParameterTypes(), parameterNames = PARAMETER_NAME_DISCOVERER.getParameterNames(method))) {
            annotationAttributes.put("value", parameterNames[parameterIndex]);
        }
        return AnnotationUtils.synthesizeAnnotation((Map)annotationAttributes, parameterAnnotation.annotationType(), null);
    }

    private boolean shouldAddParameterName(int parameterIndex, Type[] parameterTypes, String[] parameterNames) {
        return parameterNames != null && parameterNames.length > parameterIndex && parameterTypes != null && parameterTypes.length > parameterIndex;
    }

    public static class ConvertingExpander
    implements Param.Expander {
        private final ConversionService conversionService;

        public ConvertingExpander(ConversionService conversionService) {
            this.conversionService = conversionService;
        }

        public String expand(Object value) {
            return (String)this.conversionService.convert(value, String.class);
        }
    }

    private class SimpleAnnotatedParameterContext
    implements AnnotatedParameterProcessor.AnnotatedParameterContext {
        private final MethodMetadata methodMetadata;
        private final int parameterIndex;

        public SimpleAnnotatedParameterContext(MethodMetadata methodMetadata, int parameterIndex) {
            this.methodMetadata = methodMetadata;
            this.parameterIndex = parameterIndex;
        }

        public MethodMetadata getMethodMetadata() {
            return this.methodMetadata;
        }

        public int getParameterIndex() {
            return this.parameterIndex;
        }

        public void setParameterName(String name) {
            VenusSpringMvcContract.this.nameParam(this.methodMetadata, name, this.parameterIndex);
        }

        public Collection<String> setTemplateParameter(String name, Collection<String> rest) {
            return VenusSpringMvcContract.this.addTemplatedParam(rest, name);
        }
    }
}

