/*
 * Decompiled with CFR 0.152.
 */
package cn.zvo.fileupload.storage.local;

import cn.zvo.fileupload.StorageInterface;
import cn.zvo.fileupload.bean.SubFileBean;
import cn.zvo.fileupload.vo.UploadFileVO;
import com.xnx3.BaseVO;
import com.xnx3.FileUtil;
import com.xnx3.Log;
import com.xnx3.StringUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class LocalStorage
implements StorageInterface {
    private String localFilePath;

    public LocalStorage() {
    }

    public LocalStorage(Map<String, String> map) {
        String path = map.get("path");
        if (path != null && path.length() > 0) {
            this.setLocalFilePath(path);
        }
    }

    public String getLocalFilePath() {
        if (this.localFilePath == null) {
            String path = this.getClass().getResource("/").getPath();
            this.localFilePath = path.replace("WEB-INF/classes/", "");
        }
        return this.localFilePath;
    }

    public void setLocalFilePath(String localFilePath) {
        this.localFilePath = localFilePath;
    }

    @Override
    public UploadFileVO upload(String path, InputStream inputStream) {
        UploadFileVO vo = new UploadFileVO();
        this.directoryInit(path);
        File file = new File(this.getLocalFilePath() + path);
        try {
            FileOutputStream os = new FileOutputStream(file);
            int bytesRead = 0;
            byte[] buffer = new byte[8192];
            while ((bytesRead = inputStream.read(buffer, 0, 8192)) != -1) {
                ((OutputStream)os).write(buffer, 0, bytesRead);
            }
            ((OutputStream)os).close();
            inputStream.close();
            vo.setName(file.getName());
            vo.setInfo("success");
            vo.setPath(path);
        }
        catch (IOException e) {
            vo.setBaseVO(0, e.getMessage());
            e.printStackTrace();
        }
        return vo;
    }

    @Override
    public BaseVO delete(String path) {
        try {
            FileUtil.deleteFile((String)(this.getLocalFilePath() + path));
            return BaseVO.success();
        }
        catch (Exception e) {
            e.printStackTrace();
            return BaseVO.failure((String)e.getMessage());
        }
    }

    @Override
    public void copyFile(String originalFilePath, String newFilePath) {
        this.directoryInit(newFilePath);
        FileUtil.copyFile((String)(this.getLocalFilePath() + originalFilePath), (String)(this.getLocalFilePath() + newFilePath));
    }

    public void directoryInit(String path) {
        if (path == null) {
            return;
        }
        if (path.indexOf("\\") > 1) {
            path = StringUtil.replaceAll((String)path, (String)"\\\\", (String)"/");
        }
        if (path.length() - path.lastIndexOf("/") > 1) {
            path = path.substring(0, path.lastIndexOf("/") + 1);
        }
        if (!FileUtil.exists((String)path)) {
            String[] ps = path.split("/");
            String xiangdui = "";
            for (int i = 0; i < ps.length; ++i) {
                if (ps[i].length() <= 0) continue;
                xiangdui = xiangdui + ps[i] + "/";
                if (FileUtil.exists((String)(this.getLocalFilePath() + xiangdui))) continue;
                File file = new File(this.getLocalFilePath() + xiangdui);
                file.mkdir();
            }
        }
    }

    @Override
    public List<SubFileBean> getSubFileList(String path) {
        ArrayList<SubFileBean> list = new ArrayList<SubFileBean>();
        if (path == null || path.length() == 0) {
            return list;
        }
        File file = new File(this.getLocalFilePath() + path);
        if (!file.exists()) {
            return list;
        }
        File[] subFiles = file.listFiles();
        for (int i = 0; i < subFiles.length; ++i) {
            File subFile = subFiles[i];
            SubFileBean bean = new SubFileBean();
            bean.setPath(subFile.getPath().replace(this.localFilePath + path, ""));
            bean.setSize(subFile.length());
            bean.setLastModified(subFile.lastModified());
            bean.setFolder(subFile.isDirectory());
            list.add(bean);
        }
        return list;
    }

    @Override
    public long getSize(String path) {
        File file = new File(this.getLocalFilePath() + path);
        if (!file.exists()) {
            return -1L;
        }
        if (file.isDirectory()) {
            this.directoryInit(path);
            return LocalStorage.sizeOfDirectory(new File(this.getLocalFilePath() + path));
        }
        return file.length();
    }

    @Override
    public BaseVO createFolder(String path) {
        this.directoryInit(path);
        return BaseVO.success();
    }

    @Override
    public InputStream get(String path) {
        File file = new File(this.getLocalFilePath() + path);
        if (!file.exists()) {
            return null;
        }
        try {
            FileInputStream in = new FileInputStream(file);
            return in;
        }
        catch (FileNotFoundException e) {
            Log.debug((String)e.getMessage());
            e.printStackTrace();
            return null;
        }
    }

    public static long sizeOfDirectory(File directory) {
        LocalStorage.checkDirectory(directory);
        File[] files = directory.listFiles();
        if (files == null) {
            return 0L;
        }
        long size = 0L;
        for (File file : files) {
            try {
                if (LocalStorage.isSymlink(file) || (size += LocalStorage.sizeOf(file)) >= 0L) continue;
                break;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return size;
    }

    private static void checkDirectory(File directory) {
        if (!directory.exists()) {
            throw new IllegalArgumentException(directory + " does not exist");
        }
        if (!directory.isDirectory()) {
            throw new IllegalArgumentException(directory + " is not a directory");
        }
    }

    public static boolean isSymlink(File file) throws IOException {
        if (file == null) {
            throw new NullPointerException("File must not be null");
        }
        char SYSTEM_SEPARATOR = File.separatorChar;
        char WINDOWS_SEPARATOR = '\\';
        if (SYSTEM_SEPARATOR == WINDOWS_SEPARATOR) {
            return false;
        }
        File fileInCanonicalDir = null;
        if (file.getParent() == null) {
            fileInCanonicalDir = file;
        } else {
            File canonicalDir = file.getParentFile().getCanonicalFile();
            fileInCanonicalDir = new File(canonicalDir, file.getName());
        }
        return !fileInCanonicalDir.getCanonicalFile().equals(fileInCanonicalDir.getAbsoluteFile());
    }

    public static long sizeOf(File file) {
        if (!file.exists()) {
            String message = file + " does not exist";
            throw new IllegalArgumentException(message);
        }
        if (file.isDirectory()) {
            return LocalStorage.sizeOfDirectory(file);
        }
        return file.length();
    }
}

