/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types;

import co.elastic.clients.elasticsearch._types.ScriptBase;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class InlineScript
extends ScriptBase {
    @Nullable
    private final String lang;
    private final Map<String, String> options;
    private final String source;
    public static final JsonpDeserializer<InlineScript> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, InlineScript::setupInlineScriptDeserializer);

    private InlineScript(Builder builder) {
        super(builder);
        this.lang = builder.lang;
        this.options = ApiTypeHelper.unmodifiable(builder.options);
        this.source = ApiTypeHelper.requireNonNull(builder.source, this, "source");
    }

    public static InlineScript of(Function<Builder, ObjectBuilder<InlineScript>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final String lang() {
        return this.lang;
    }

    public final Map<String, String> options() {
        return this.options;
    }

    public final String source() {
        return this.source;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.lang != null) {
            generator.writeKey("lang");
            generator.write(this.lang);
        }
        if (ApiTypeHelper.isDefined(this.options)) {
            generator.writeKey("options");
            generator.writeStartObject();
            for (Map.Entry<String, String> item0 : this.options.entrySet()) {
                generator.writeKey(item0.getKey());
                generator.write(item0.getValue());
            }
            generator.writeEnd();
        }
        generator.writeKey("source");
        generator.write(this.source);
    }

    protected static void setupInlineScriptDeserializer(ObjectDeserializer<Builder> op) {
        ScriptBase.setupScriptBaseDeserializer(op);
        op.add(Builder::lang, JsonpDeserializer.stringDeserializer(), "lang");
        op.add(Builder::options, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.stringDeserializer()), "options");
        op.add(Builder::source, JsonpDeserializer.stringDeserializer(), "source");
        op.shortcutProperty("source");
    }

    public static class Builder
    extends ScriptBase.AbstractBuilder<Builder>
    implements ObjectBuilder<InlineScript> {
        @Nullable
        private String lang;
        @Nullable
        private Map<String, String> options;
        private String source;

        public final Builder lang(@Nullable String value) {
            this.lang = value;
            return this;
        }

        public final Builder options(Map<String, String> map) {
            this.options = Builder._mapPutAll(this.options, map);
            return this;
        }

        public final Builder options(String key, String value) {
            this.options = Builder._mapPut(this.options, key, value);
            return this;
        }

        public final Builder source(String value) {
            this.source = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public InlineScript build() {
            this._checkSingleUse();
            return new InlineScript(this);
        }
    }
}

