/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.aggregations;

import co.elastic.clients.elasticsearch._types.aggregations.Aggregation;
import co.elastic.clients.elasticsearch._types.aggregations.AggregationVariant;
import co.elastic.clients.elasticsearch._types.aggregations.PipelineAggregationBase;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class SerialDifferencingAggregation
extends PipelineAggregationBase
implements AggregationVariant {
    @Nullable
    private final Integer lag;
    public static final JsonpDeserializer<SerialDifferencingAggregation> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, SerialDifferencingAggregation::setupSerialDifferencingAggregationDeserializer);

    private SerialDifferencingAggregation(Builder builder) {
        super(builder);
        this.lag = builder.lag;
    }

    public static SerialDifferencingAggregation of(Function<Builder, ObjectBuilder<SerialDifferencingAggregation>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Aggregation.Kind _aggregationKind() {
        return Aggregation.Kind.SerialDiff;
    }

    @Nullable
    public final Integer lag() {
        return this.lag;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.lag != null) {
            generator.writeKey("lag");
            generator.write(this.lag.intValue());
        }
    }

    protected static void setupSerialDifferencingAggregationDeserializer(ObjectDeserializer<Builder> op) {
        PipelineAggregationBase.setupPipelineAggregationBaseDeserializer(op);
        op.add(Builder::lag, JsonpDeserializer.integerDeserializer(), "lag");
    }

    public static class Builder
    extends PipelineAggregationBase.AbstractBuilder<Builder>
    implements ObjectBuilder<SerialDifferencingAggregation> {
        @Nullable
        private Integer lag;

        public final Builder lag(@Nullable Integer value) {
            this.lag = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public SerialDifferencingAggregation build() {
            this._checkSingleUse();
            return new SerialDifferencingAggregation(this);
        }
    }
}

