/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.transport.rest_client;

import co.elastic.clients.elasticsearch._types.ElasticsearchException;
import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.NdJsonpSerializable;
import co.elastic.clients.transport.ElasticsearchTransport;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.JsonEndpoint;
import co.elastic.clients.transport.TransportException;
import co.elastic.clients.transport.TransportOptions;
import co.elastic.clients.transport.Version;
import co.elastic.clients.transport.endpoints.BinaryEndpoint;
import co.elastic.clients.transport.endpoints.BooleanEndpoint;
import co.elastic.clients.transport.endpoints.BooleanResponse;
import co.elastic.clients.transport.rest_client.HttpClientBinaryResponse;
import co.elastic.clients.transport.rest_client.MultiBufferEntity;
import co.elastic.clients.transport.rest_client.RestClientOptions;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.BinaryData;
import co.elastic.clients.util.MissingRequiredPropertyException;
import jakarta.json.stream.JsonGenerator;
import jakarta.json.stream.JsonParser;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.entity.BufferedHttpEntity;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.elasticsearch.client.Cancellable;
import org.elasticsearch.client.Request;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.Response;
import org.elasticsearch.client.ResponseException;
import org.elasticsearch.client.ResponseListener;
import org.elasticsearch.client.RestClient;

public class RestClientTransport
implements ElasticsearchTransport {
    static final ContentType JsonContentType = Version.VERSION == null ? ContentType.APPLICATION_JSON : ContentType.create((String)"application/vnd.elasticsearch+json", (NameValuePair[])new NameValuePair[]{new BasicNameValuePair("compatible-with", String.valueOf(Version.VERSION.major()))});
    private final RestClient restClient;
    private final JsonpMapper mapper;
    private final RestClientOptions transportOptions;
    private static final ByteBuffer NdJsonSeparator = ByteBuffer.wrap("\n".getBytes(StandardCharsets.UTF_8));
    private static final Set<String> endpointsMissingProductHeader = new HashSet<String>(Arrays.asList("es/snapshot.create"));

    public RestClientTransport(RestClient restClient, JsonpMapper mapper, @Nullable TransportOptions options) {
        this.restClient = restClient;
        this.mapper = mapper;
        this.transportOptions = options == null ? RestClientOptions.initialOptions() : RestClientOptions.of(options);
    }

    public RestClientTransport(RestClient restClient, JsonpMapper mapper) {
        this(restClient, mapper, null);
    }

    public RestClient restClient() {
        return this.restClient;
    }

    public RestClientTransport withRequestOptions(@Nullable TransportOptions options) {
        return new RestClientTransport(this.restClient, this.mapper, options);
    }

    @Override
    public JsonpMapper jsonpMapper() {
        return this.mapper;
    }

    @Override
    public TransportOptions options() {
        return this.transportOptions;
    }

    @Override
    public void close() throws IOException {
        this.restClient.close();
    }

    @Override
    public <RequestT, ResponseT, ErrorT> ResponseT performRequest(RequestT request, Endpoint<RequestT, ResponseT, ErrorT> endpoint, @Nullable TransportOptions options) throws IOException {
        Request clientReq = this.prepareLowLevelRequest(request, endpoint, options);
        Response clientResp = this.restClient.performRequest(clientReq);
        return this.getHighLevelResponse(clientResp, endpoint);
    }

    @Override
    public <RequestT, ResponseT, ErrorT> CompletableFuture<ResponseT> performRequestAsync(RequestT request, final Endpoint<RequestT, ResponseT, ErrorT> endpoint, @Nullable TransportOptions options) {
        Request clientReq;
        final RequestFuture future = new RequestFuture();
        try {
            clientReq = this.prepareLowLevelRequest(request, endpoint, options);
        }
        catch (Exception e) {
            future.completeExceptionally(e);
            return future;
        }
        final boolean disableRequiredChecks = ApiTypeHelper.requiredPropertiesCheckDisabled();
        future.cancellable = this.restClient.performRequestAsync(clientReq, new ResponseListener(){

            public void onSuccess(Response clientResp) {
                try (ApiTypeHelper.DisabledChecksHandle h = ApiTypeHelper.DANGEROUS_disableRequiredPropertiesCheck(disableRequiredChecks);){
                    Object response = RestClientTransport.this.getHighLevelResponse(clientResp, endpoint);
                    future.complete(response);
                }
                catch (Exception e) {
                    future.completeExceptionally(e);
                }
            }

            public void onFailure(Exception e) {
                future.completeExceptionally(e);
            }
        });
        return future;
    }

    private <RequestT> Request prepareLowLevelRequest(RequestT request, Endpoint<RequestT, ?, ?> endpoint, @Nullable TransportOptions options) throws IOException {
        RequestOptions restOptions;
        String method = endpoint.method(request);
        String path = endpoint.requestUrl(request);
        Map<String, String> params = endpoint.queryParameters(request);
        Request clientReq = new Request(method, path);
        RequestOptions requestOptions = restOptions = options == null ? this.transportOptions.restClientRequestOptions() : RestClientOptions.of(options).restClientRequestOptions();
        if (restOptions != null) {
            clientReq.setOptions(restOptions);
        }
        clientReq.addParameters(params);
        if (endpoint.hasRequestBody()) {
            if (request instanceof NdJsonpSerializable) {
                ArrayList<ByteBuffer> lines = new ArrayList<ByteBuffer>();
                this.collectNdJsonLines(lines, (NdJsonpSerializable)request);
                clientReq.setEntity((HttpEntity)new MultiBufferEntity(lines, JsonContentType));
            } else {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                JsonGenerator generator = this.mapper.jsonProvider().createGenerator((OutputStream)baos);
                this.mapper.serialize(request, generator);
                generator.close();
                clientReq.setEntity((HttpEntity)new ByteArrayEntity(baos.toByteArray(), JsonContentType));
            }
        }
        clientReq.addParameter("ignore", "400,401,403,404,405");
        return clientReq;
    }

    private void collectNdJsonLines(List<ByteBuffer> lines, NdJsonpSerializable value) {
        Iterator<?> values = value._serializables();
        while (values.hasNext()) {
            Object item = values.next();
            if (item == null) continue;
            if (item instanceof NdJsonpSerializable && item != value) {
                this.collectNdJsonLines(lines, (NdJsonpSerializable)item);
                continue;
            }
            lines.add(BinaryData.of(item, this.mapper).asByteBuffer());
            lines.add(NdJsonSeparator);
        }
    }

    private void writeNdJson(NdJsonpSerializable value, ByteArrayOutputStream baos) throws IOException {
        Iterator<?> values = value._serializables();
        while (values.hasNext()) {
            Object item = values.next();
            if (item instanceof NdJsonpSerializable && item != value) {
                this.writeNdJson((NdJsonpSerializable)item, baos);
                continue;
            }
            JsonGenerator generator = this.mapper.jsonProvider().createGenerator((OutputStream)baos);
            this.mapper.serialize(item, generator);
            generator.close();
            baos.write(10);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <ResponseT, ErrorT> ResponseT getHighLevelResponse(Response clientResp, Endpoint<?, ResponseT, ErrorT> endpoint) throws IOException {
        int statusCode = clientResp.getStatusLine().getStatusCode();
        if (statusCode == 200) {
            this.checkProductHeader(clientResp, endpoint);
        }
        if (endpoint.isError(statusCode)) {
            JsonpDeserializer<ErrorT> errorDeserializer = endpoint.errorDeserializer(statusCode);
            if (errorDeserializer == null) {
                throw new TransportException("Request failed with status code '" + statusCode + "'", endpoint.id(), (Throwable)new ResponseException(clientResp));
            }
            HttpEntity entity = clientResp.getEntity();
            if (entity == null) {
                throw new TransportException("Expecting a response body, but none was sent", endpoint.id(), (Throwable)new ResponseException(clientResp));
            }
            entity = new BufferedHttpEntity(entity);
            try {
                InputStream content = entity.getContent();
                JsonParser parser = this.mapper.jsonProvider().createParser(content);
                try {
                    ErrorT error = errorDeserializer.deserialize(parser, this.mapper);
                    throw new ElasticsearchException(endpoint.id(), (ErrorResponse)error);
                }
                catch (Throwable throwable) {
                    if (parser != null) {
                        try {
                            parser.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
            }
            catch (MissingRequiredPropertyException errorEx) {
                ResponseT ResponseT;
                try {
                    ResponseT response;
                    ResponseT = response = this.decodeResponse(statusCode, entity, clientResp, endpoint);
                }
                catch (Exception respEx) {
                    throw new TransportException("Failed to decode error response", endpoint.id(), (Throwable)new ResponseException(clientResp));
                }
                if (!(endpoint instanceof BinaryEndpoint) || endpoint.isError(statusCode)) {
                    EntityUtils.consume((HttpEntity)clientResp.getEntity());
                }
                return ResponseT;
            }
        }
        ResponseT ResponseT = this.decodeResponse(statusCode, clientResp.getEntity(), clientResp, endpoint);
        return ResponseT;
        finally {
            if (!(endpoint instanceof BinaryEndpoint) || endpoint.isError(statusCode)) {
                EntityUtils.consume((HttpEntity)clientResp.getEntity());
            }
        }
    }

    private <ResponseT> ResponseT decodeResponse(int statusCode, @Nullable HttpEntity entity, Response clientResp, Endpoint<?, ResponseT, ?> endpoint) throws IOException {
        if (endpoint instanceof JsonEndpoint) {
            JsonEndpoint jsonEndpoint = (JsonEndpoint)endpoint;
            ResponseT response = null;
            JsonpDeserializer responseParser = jsonEndpoint.responseDeserializer();
            if (responseParser != null) {
                if (entity == null) {
                    throw new TransportException("Expecting a response body, but none was sent", endpoint.id(), (Throwable)new ResponseException(clientResp));
                }
                InputStream content = entity.getContent();
                try (JsonParser parser = this.mapper.jsonProvider().createParser(content);){
                    response = responseParser.deserialize(parser, this.mapper);
                }
            }
            return response;
        }
        if (endpoint instanceof BooleanEndpoint) {
            BooleanEndpoint bep = (BooleanEndpoint)endpoint;
            BooleanResponse response = new BooleanResponse(bep.getResult(statusCode));
            return (ResponseT)response;
        }
        if (endpoint instanceof BinaryEndpoint) {
            BinaryEndpoint bep = (BinaryEndpoint)endpoint;
            HttpClientBinaryResponse response = new HttpClientBinaryResponse(entity);
            return (ResponseT)response;
        }
        throw new TransportException("Unhandled endpoint type: '" + endpoint.getClass().getName() + "'", endpoint.id());
    }

    private void checkProductHeader(Response clientResp, Endpoint<?, ?, ?> endpoint) throws IOException {
        String header = clientResp.getHeader("X-Elastic-Product");
        if (header == null) {
            if (endpointsMissingProductHeader.contains(endpoint.id())) {
                return;
            }
            throw new TransportException("Missing [X-Elastic-Product] header. Please check that you are connecting to an Elasticsearch instance, and that any networking filters are preserving that header.", endpoint.id(), (Throwable)new ResponseException(clientResp));
        }
        if (!"Elasticsearch".equals(header)) {
            throw new TransportException("Invalid value '" + header + "' for 'X-Elastic-Product' header.", endpoint.id(), (Throwable)new ResponseException(clientResp));
        }
    }

    private static class RequestFuture<T>
    extends CompletableFuture<T> {
        private volatile Cancellable cancellable;

        private RequestFuture() {
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            boolean cancelled = super.cancel(mayInterruptIfRunning);
            if (cancelled && this.cancellable != null) {
                this.cancellable.cancel();
            }
            return cancelled;
        }
    }
}

