/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.cat.count;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.DateTime;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class CountRecord
implements JsonpSerializable {
    @Nullable
    private final DateTime epoch;
    @Nullable
    private final DateTime timestamp;
    @Nullable
    private final String count;
    public static final JsonpDeserializer<CountRecord> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, CountRecord::setupCountRecordDeserializer);

    private CountRecord(Builder builder) {
        this.epoch = builder.epoch;
        this.timestamp = builder.timestamp;
        this.count = builder.count;
    }

    public static CountRecord of(Function<Builder, ObjectBuilder<CountRecord>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final DateTime epoch() {
        return this.epoch;
    }

    @Nullable
    public final DateTime timestamp() {
        return this.timestamp;
    }

    @Nullable
    public final String count() {
        return this.count;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.epoch != null) {
            generator.writeKey("epoch");
            this.epoch.serialize(generator, mapper);
        }
        if (this.timestamp != null) {
            generator.writeKey("timestamp");
            this.timestamp.serialize(generator, mapper);
        }
        if (this.count != null) {
            generator.writeKey("count");
            generator.write(this.count);
        }
    }

    protected static void setupCountRecordDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::epoch, DateTime._DESERIALIZER, "epoch", "t", "time");
        op.add(Builder::timestamp, DateTime._DESERIALIZER, "timestamp", "ts", "hms", "hhmmss");
        op.add(Builder::count, JsonpDeserializer.stringDeserializer(), "count", "dc", "docs.count", "docsCount");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<CountRecord> {
        @Nullable
        private DateTime epoch;
        @Nullable
        private DateTime timestamp;
        @Nullable
        private String count;

        public final Builder epoch(@Nullable DateTime value) {
            this.epoch = value;
            return this;
        }

        public final Builder timestamp(@Nullable DateTime value) {
            this.timestamp = value;
            return this;
        }

        public final Builder count(@Nullable String value) {
            this.count = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public CountRecord build() {
            this._checkSingleUse();
            return new CountRecord(this);
        }
    }
}

