/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.security;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.Refresh;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.security.BulkPutRoleResponse;
import co.elastic.clients.elasticsearch.security.RoleDescriptor;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class BulkPutRoleRequest
extends RequestBase
implements JsonpSerializable {
    @Nullable
    private final Refresh refresh;
    private final Map<String, RoleDescriptor> roles;
    public static final JsonpDeserializer<BulkPutRoleRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, BulkPutRoleRequest::setupBulkPutRoleRequestDeserializer);
    public static final Endpoint<BulkPutRoleRequest, BulkPutRoleResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<BulkPutRoleRequest, BulkPutRoleResponse>("es/security.bulk_put_role", request -> "POST", request -> "/_security/role", request -> Collections.emptyMap(), request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.refresh != null) {
            params.put("refresh", request.refresh.jsonValue());
        }
        return params;
    }, SimpleEndpoint.emptyMap(), true, BulkPutRoleResponse._DESERIALIZER);

    private BulkPutRoleRequest(Builder builder) {
        this.refresh = builder.refresh;
        this.roles = ApiTypeHelper.unmodifiableRequired(builder.roles, (Object)this, "roles");
    }

    public static BulkPutRoleRequest of(Function<Builder, ObjectBuilder<BulkPutRoleRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Refresh refresh() {
        return this.refresh;
    }

    public final Map<String, RoleDescriptor> roles() {
        return this.roles;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.roles)) {
            generator.writeKey("roles");
            generator.writeStartObject();
            for (Map.Entry<String, RoleDescriptor> item0 : this.roles.entrySet()) {
                generator.writeKey(item0.getKey());
                item0.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    protected static void setupBulkPutRoleRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::roles, JsonpDeserializer.stringMapDeserializer(RoleDescriptor._DESERIALIZER), "roles");
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<BulkPutRoleRequest> {
        @Nullable
        private Refresh refresh;
        private Map<String, RoleDescriptor> roles;

        public final Builder refresh(@Nullable Refresh value) {
            this.refresh = value;
            return this;
        }

        public final Builder roles(Map<String, RoleDescriptor> map) {
            this.roles = Builder._mapPutAll(this.roles, map);
            return this;
        }

        public final Builder roles(String key, RoleDescriptor value) {
            this.roles = Builder._mapPut(this.roles, key, value);
            return this;
        }

        public final Builder roles(String key, Function<RoleDescriptor.Builder, ObjectBuilder<RoleDescriptor>> fn) {
            return this.roles(key, fn.apply(new RoleDescriptor.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public BulkPutRoleRequest build() {
            this._checkSingleUse();
            return new BulkPutRoleRequest(this);
        }
    }
}

