/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.xpack.usage;

import co.elastic.clients.elasticsearch.ilm.Phases;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class IlmPolicyStatistics
implements JsonpSerializable {
    private final int indicesManaged;
    private final Phases phases;
    public static final JsonpDeserializer<IlmPolicyStatistics> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, IlmPolicyStatistics::setupIlmPolicyStatisticsDeserializer);

    private IlmPolicyStatistics(Builder builder) {
        this.indicesManaged = ApiTypeHelper.requireNonNull(builder.indicesManaged, this, "indicesManaged");
        this.phases = ApiTypeHelper.requireNonNull(builder.phases, this, "phases");
    }

    public static IlmPolicyStatistics of(Function<Builder, ObjectBuilder<IlmPolicyStatistics>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final int indicesManaged() {
        return this.indicesManaged;
    }

    public final Phases phases() {
        return this.phases;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("indices_managed");
        generator.write(this.indicesManaged);
        generator.writeKey("phases");
        this.phases.serialize(generator, mapper);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupIlmPolicyStatisticsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::indicesManaged, JsonpDeserializer.integerDeserializer(), "indices_managed");
        op.add(Builder::phases, Phases._DESERIALIZER, "phases");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<IlmPolicyStatistics> {
        private Integer indicesManaged;
        private Phases phases;

        public final Builder indicesManaged(int value) {
            this.indicesManaged = value;
            return this;
        }

        public final Builder phases(Phases value) {
            this.phases = value;
            return this;
        }

        public final Builder phases(Function<Phases.Builder, ObjectBuilder<Phases>> fn) {
            return this.phases(fn.apply(new Phases.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public IlmPolicyStatistics build() {
            this._checkSingleUse();
            return new IlmPolicyStatistics(this);
        }
    }
}

