/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types;

import co.elastic.clients.elasticsearch._types.QueryVectorBuilder;
import co.elastic.clients.elasticsearch._types.QueryVectorBuilderVariant;
import co.elastic.clients.elasticsearch._types.RescoreVector;
import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import co.elastic.clients.elasticsearch._types.query_dsl.QueryVariant;
import co.elastic.clients.elasticsearch.core.search.InnerHits;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class KnnSearch
implements JsonpSerializable {
    private final String field;
    private final List<Float> queryVector;
    @Nullable
    private final QueryVectorBuilder queryVectorBuilder;
    @Nullable
    private final Integer k;
    @Nullable
    private final Integer numCandidates;
    @Nullable
    private final Float visitPercentage;
    @Nullable
    private final Float boost;
    private final List<Query> filter;
    @Nullable
    private final Float similarity;
    @Nullable
    private final InnerHits innerHits;
    @Nullable
    private final RescoreVector rescoreVector;
    public static final JsonpDeserializer<KnnSearch> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, KnnSearch::setupKnnSearchDeserializer);

    private KnnSearch(Builder builder) {
        this.field = ApiTypeHelper.requireNonNull(builder.field, this, "field");
        this.queryVector = ApiTypeHelper.unmodifiable(builder.queryVector);
        this.queryVectorBuilder = builder.queryVectorBuilder;
        this.k = builder.k;
        this.numCandidates = builder.numCandidates;
        this.visitPercentage = builder.visitPercentage;
        this.boost = builder.boost;
        this.filter = ApiTypeHelper.unmodifiable(builder.filter);
        this.similarity = builder.similarity;
        this.innerHits = builder.innerHits;
        this.rescoreVector = builder.rescoreVector;
    }

    public static KnnSearch of(Function<Builder, ObjectBuilder<KnnSearch>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String field() {
        return this.field;
    }

    public final List<Float> queryVector() {
        return this.queryVector;
    }

    @Nullable
    public final QueryVectorBuilder queryVectorBuilder() {
        return this.queryVectorBuilder;
    }

    @Nullable
    public final Integer k() {
        return this.k;
    }

    @Nullable
    public final Integer numCandidates() {
        return this.numCandidates;
    }

    @Nullable
    public final Float visitPercentage() {
        return this.visitPercentage;
    }

    @Nullable
    public final Float boost() {
        return this.boost;
    }

    public final List<Query> filter() {
        return this.filter;
    }

    @Nullable
    public final Float similarity() {
        return this.similarity;
    }

    @Nullable
    public final InnerHits innerHits() {
        return this.innerHits;
    }

    @Nullable
    public final RescoreVector rescoreVector() {
        return this.rescoreVector;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("field");
        generator.write(this.field);
        if (ApiTypeHelper.isDefined(this.queryVector)) {
            generator.writeKey("query_vector");
            generator.writeStartArray();
            for (Float f : this.queryVector) {
                generator.write((double)f.floatValue());
            }
            generator.writeEnd();
        }
        if (this.queryVectorBuilder != null) {
            generator.writeKey("query_vector_builder");
            this.queryVectorBuilder.serialize(generator, mapper);
        }
        if (this.k != null) {
            generator.writeKey("k");
            generator.write(this.k.intValue());
        }
        if (this.numCandidates != null) {
            generator.writeKey("num_candidates");
            generator.write(this.numCandidates.intValue());
        }
        if (this.visitPercentage != null) {
            generator.writeKey("visit_percentage");
            generator.write((double)this.visitPercentage.floatValue());
        }
        if (this.boost != null) {
            generator.writeKey("boost");
            generator.write((double)this.boost.floatValue());
        }
        if (ApiTypeHelper.isDefined(this.filter)) {
            generator.writeKey("filter");
            generator.writeStartArray();
            for (Query query : this.filter) {
                query.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.similarity != null) {
            generator.writeKey("similarity");
            generator.write((double)this.similarity.floatValue());
        }
        if (this.innerHits != null) {
            generator.writeKey("inner_hits");
            this.innerHits.serialize(generator, mapper);
        }
        if (this.rescoreVector != null) {
            generator.writeKey("rescore_vector");
            this.rescoreVector.serialize(generator, mapper);
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupKnnSearchDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::field, JsonpDeserializer.stringDeserializer(), "field");
        op.add(Builder::queryVector, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.floatDeserializer()), "query_vector");
        op.add(Builder::queryVectorBuilder, QueryVectorBuilder._DESERIALIZER, "query_vector_builder");
        op.add(Builder::k, JsonpDeserializer.integerDeserializer(), "k");
        op.add(Builder::numCandidates, JsonpDeserializer.integerDeserializer(), "num_candidates");
        op.add(Builder::visitPercentage, JsonpDeserializer.floatDeserializer(), "visit_percentage");
        op.add(Builder::boost, JsonpDeserializer.floatDeserializer(), "boost");
        op.add(Builder::filter, JsonpDeserializer.arrayDeserializer(Query._DESERIALIZER), "filter");
        op.add(Builder::similarity, JsonpDeserializer.floatDeserializer(), "similarity");
        op.add(Builder::innerHits, InnerHits._DESERIALIZER, "inner_hits");
        op.add(Builder::rescoreVector, RescoreVector._DESERIALIZER, "rescore_vector");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<KnnSearch> {
        private String field;
        @Nullable
        private List<Float> queryVector;
        @Nullable
        private QueryVectorBuilder queryVectorBuilder;
        @Nullable
        private Integer k;
        @Nullable
        private Integer numCandidates;
        @Nullable
        private Float visitPercentage;
        @Nullable
        private Float boost;
        @Nullable
        private List<Query> filter;
        @Nullable
        private Float similarity;
        @Nullable
        private InnerHits innerHits;
        @Nullable
        private RescoreVector rescoreVector;

        public final Builder field(String value) {
            this.field = value;
            return this;
        }

        public final Builder queryVector(List<Float> list) {
            this.queryVector = Builder._listAddAll(this.queryVector, list);
            return this;
        }

        public final Builder queryVector(Float value, Float ... values) {
            this.queryVector = Builder._listAdd(this.queryVector, value, values);
            return this;
        }

        public final Builder queryVectorBuilder(@Nullable QueryVectorBuilder value) {
            this.queryVectorBuilder = value;
            return this;
        }

        public final Builder queryVectorBuilder(Function<QueryVectorBuilder.Builder, ObjectBuilder<QueryVectorBuilder>> fn) {
            return this.queryVectorBuilder(fn.apply(new QueryVectorBuilder.Builder()).build());
        }

        public final Builder queryVectorBuilder(QueryVectorBuilderVariant value) {
            this.queryVectorBuilder = value._toQueryVectorBuilder();
            return this;
        }

        public final Builder k(@Nullable Integer value) {
            this.k = value;
            return this;
        }

        public final Builder numCandidates(@Nullable Integer value) {
            this.numCandidates = value;
            return this;
        }

        public final Builder visitPercentage(@Nullable Float value) {
            this.visitPercentage = value;
            return this;
        }

        public final Builder boost(@Nullable Float value) {
            this.boost = value;
            return this;
        }

        public final Builder filter(List<Query> list) {
            this.filter = Builder._listAddAll(this.filter, list);
            return this;
        }

        public final Builder filter(Query value, Query ... values) {
            this.filter = Builder._listAdd(this.filter, value, values);
            return this;
        }

        public final Builder filter(QueryVariant value, QueryVariant ... values) {
            this.filter = Builder._listAdd(this.filter, value._toQuery(), new Query[0]);
            for (QueryVariant v : values) {
                Builder._listAdd(this.filter, v._toQuery(), new Query[0]);
            }
            return this;
        }

        public final Builder filter(Function<Query.Builder, ObjectBuilder<Query>> fn) {
            return this.filter(fn.apply(new Query.Builder()).build(), new Query[0]);
        }

        public final Builder similarity(@Nullable Float value) {
            this.similarity = value;
            return this;
        }

        public final Builder innerHits(@Nullable InnerHits value) {
            this.innerHits = value;
            return this;
        }

        public final Builder innerHits(Function<InnerHits.Builder, ObjectBuilder<InnerHits>> fn) {
            return this.innerHits(fn.apply(new InnerHits.Builder()).build());
        }

        public final Builder rescoreVector(@Nullable RescoreVector value) {
            this.rescoreVector = value;
            return this;
        }

        public final Builder rescoreVector(Function<RescoreVector.Builder, ObjectBuilder<RescoreVector>> fn) {
            return this.rescoreVector(fn.apply(new RescoreVector.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public KnnSearch build() {
            this._checkSingleUse();
            return new KnnSearch(this);
        }
    }
}

