/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.connector;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.connector.SchedulingConfiguration;
import co.elastic.clients.elasticsearch.connector.UpdateSchedulingResponse;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Collections;
import java.util.HashMap;
import java.util.function.Function;

@JsonpDeserializable
public class UpdateSchedulingRequest
extends RequestBase
implements JsonpSerializable {
    private final String connectorId;
    private final SchedulingConfiguration scheduling;
    public static final JsonpDeserializer<UpdateSchedulingRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, UpdateSchedulingRequest::setupUpdateSchedulingRequestDeserializer);
    public static final Endpoint<UpdateSchedulingRequest, UpdateSchedulingResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<UpdateSchedulingRequest, UpdateSchedulingResponse>("es/connector.update_scheduling", request -> "PUT", request -> {
        boolean _connectorId = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_connector");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.connectorId, buf);
            buf.append("/_scheduling");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        boolean _connectorId = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            params.put("connectorId", request.connectorId);
        }
        return params;
    }, request -> Collections.emptyMap(), SimpleEndpoint.emptyMap(), true, UpdateSchedulingResponse._DESERIALIZER);

    private UpdateSchedulingRequest(Builder builder) {
        this.connectorId = ApiTypeHelper.requireNonNull(builder.connectorId, this, "connectorId");
        this.scheduling = ApiTypeHelper.requireNonNull(builder.scheduling, this, "scheduling");
    }

    public static UpdateSchedulingRequest of(Function<Builder, ObjectBuilder<UpdateSchedulingRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String connectorId() {
        return this.connectorId;
    }

    public final SchedulingConfiguration scheduling() {
        return this.scheduling;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("scheduling");
        this.scheduling.serialize(generator, mapper);
    }

    protected static void setupUpdateSchedulingRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::scheduling, SchedulingConfiguration._DESERIALIZER, "scheduling");
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<UpdateSchedulingRequest> {
        private String connectorId;
        private SchedulingConfiguration scheduling;

        public final Builder connectorId(String value) {
            this.connectorId = value;
            return this;
        }

        public final Builder scheduling(SchedulingConfiguration value) {
            this.scheduling = value;
            return this;
        }

        public final Builder scheduling(Function<SchedulingConfiguration.Builder, ObjectBuilder<SchedulingConfiguration>> fn) {
            return this.scheduling(fn.apply(new SchedulingConfiguration.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public UpdateSchedulingRequest build() {
            this._checkSingleUse();
            return new UpdateSchedulingRequest(this);
        }
    }
}

