/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.json.jackson;

import co.elastic.clients.json.BufferingJsonGenerator;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.jackson.Jackson3JsonBuffer;
import co.elastic.clients.json.jackson.Jackson3JsonpMapper;
import co.elastic.clients.json.jackson.Jackson3JsonpParser;
import co.elastic.clients.json.jackson.Jackson3Utils;
import jakarta.json.JsonNumber;
import jakarta.json.JsonString;
import jakarta.json.JsonValue;
import jakarta.json.stream.JsonGenerationException;
import jakarta.json.stream.JsonParser;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Map;
import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonGenerator;
import tools.jackson.core.TokenStreamContext;
import tools.jackson.databind.util.TokenBuffer;

public class Jackson3JsonpGenerator
implements jakarta.json.stream.JsonGenerator {
    private JsonGenerator generator;

    public Jackson3JsonpGenerator(JsonGenerator generator) {
        this.generator = generator;
    }

    public JsonGenerator jacksonGenerator() {
        return this.generator;
    }

    public jakarta.json.stream.JsonGenerator writeStartObject() {
        try {
            this.generator.writeStartObject();
        }
        catch (JacksonException e) {
            throw Jackson3Utils.convertException(e);
        }
        return this;
    }

    public jakarta.json.stream.JsonGenerator writeStartObject(String name) {
        try {
            this.generator.writeName(name);
            this.generator.writeStartObject();
        }
        catch (JacksonException e) {
            throw Jackson3Utils.convertException(e);
        }
        return this;
    }

    public jakarta.json.stream.JsonGenerator writeStartArray() {
        try {
            this.generator.writeStartArray();
        }
        catch (JacksonException e) {
            throw Jackson3Utils.convertException(e);
        }
        return this;
    }

    public jakarta.json.stream.JsonGenerator writeStartArray(String name) {
        try {
            this.generator.writeName(name);
            this.generator.writeStartArray();
        }
        catch (JacksonException e) {
            throw Jackson3Utils.convertException(e);
        }
        return this;
    }

    public jakarta.json.stream.JsonGenerator writeKey(String name) {
        try {
            this.generator.writeName(name);
        }
        catch (JacksonException e) {
            throw Jackson3Utils.convertException(e);
        }
        return this;
    }

    public jakarta.json.stream.JsonGenerator write(String name, JsonValue value) {
        try {
            this.generator.writeName(name);
            this.writeValue(value);
        }
        catch (JacksonException e) {
            throw Jackson3Utils.convertException(e);
        }
        return this;
    }

    public jakarta.json.stream.JsonGenerator write(String name, String value) {
        try {
            this.generator.writeName(name);
            this.generator.writeString(value);
        }
        catch (JacksonException e) {
            throw Jackson3Utils.convertException(e);
        }
        return this;
    }

    public jakarta.json.stream.JsonGenerator write(String name, BigInteger value) {
        try {
            this.generator.writeName(name);
            this.generator.writeNumber(value);
        }
        catch (JacksonException e) {
            throw Jackson3Utils.convertException(e);
        }
        return this;
    }

    public jakarta.json.stream.JsonGenerator write(String name, BigDecimal value) {
        try {
            this.generator.writeName(name);
            this.generator.writeNumber(value);
        }
        catch (JacksonException e) {
            throw Jackson3Utils.convertException(e);
        }
        return this;
    }

    public jakarta.json.stream.JsonGenerator write(String name, int value) {
        try {
            this.generator.writeName(name);
            this.generator.writeNumber(value);
        }
        catch (JacksonException e) {
            throw Jackson3Utils.convertException(e);
        }
        return this;
    }

    public jakarta.json.stream.JsonGenerator write(String name, long value) {
        try {
            this.generator.writeName(name);
            this.generator.writeNumber(value);
        }
        catch (JacksonException e) {
            throw Jackson3Utils.convertException(e);
        }
        return this;
    }

    public jakarta.json.stream.JsonGenerator write(String name, double value) {
        try {
            this.generator.writeName(name);
            this.generator.writeNumber(value);
        }
        catch (JacksonException e) {
            throw Jackson3Utils.convertException(e);
        }
        return this;
    }

    public jakarta.json.stream.JsonGenerator write(String name, boolean value) {
        try {
            this.generator.writeName(name);
            this.generator.writeBoolean(value);
        }
        catch (JacksonException e) {
            throw Jackson3Utils.convertException(e);
        }
        return this;
    }

    public jakarta.json.stream.JsonGenerator writeNull(String name) {
        try {
            this.generator.writeName(name);
            this.generator.writeNull();
        }
        catch (JacksonException e) {
            throw Jackson3Utils.convertException(e);
        }
        return this;
    }

    public jakarta.json.stream.JsonGenerator writeEnd() {
        block4: {
            try {
                TokenStreamContext ctx = this.generator.streamWriteContext();
                if (ctx.inObject()) {
                    this.generator.writeEndObject();
                    break block4;
                }
                if (ctx.inArray()) {
                    this.generator.writeEndArray();
                    break block4;
                }
                throw new JsonGenerationException("Unexpected context: '" + ctx.typeDesc() + "'");
            }
            catch (JacksonException e) {
                throw Jackson3Utils.convertException(e);
            }
        }
        return this;
    }

    public jakarta.json.stream.JsonGenerator write(JsonValue value) {
        try {
            this.writeValue(value);
        }
        catch (JacksonException e) {
            throw Jackson3Utils.convertException(e);
        }
        return this;
    }

    public jakarta.json.stream.JsonGenerator write(String value) {
        try {
            this.generator.writeString(value);
        }
        catch (JacksonException e) {
            throw Jackson3Utils.convertException(e);
        }
        return this;
    }

    public jakarta.json.stream.JsonGenerator write(BigDecimal value) {
        try {
            this.generator.writeNumber(value);
        }
        catch (JacksonException e) {
            throw Jackson3Utils.convertException(e);
        }
        return this;
    }

    public jakarta.json.stream.JsonGenerator write(BigInteger value) {
        try {
            this.generator.writeNumber(value);
        }
        catch (JacksonException e) {
            throw Jackson3Utils.convertException(e);
        }
        return this;
    }

    public jakarta.json.stream.JsonGenerator write(int value) {
        try {
            this.generator.writeNumber(value);
        }
        catch (JacksonException e) {
            throw Jackson3Utils.convertException(e);
        }
        return this;
    }

    public jakarta.json.stream.JsonGenerator write(long value) {
        try {
            this.generator.writeNumber(value);
        }
        catch (JacksonException e) {
            throw Jackson3Utils.convertException(e);
        }
        return this;
    }

    public jakarta.json.stream.JsonGenerator write(double value) {
        try {
            this.generator.writeNumber(value);
        }
        catch (JacksonException e) {
            throw Jackson3Utils.convertException(e);
        }
        return this;
    }

    public jakarta.json.stream.JsonGenerator write(boolean value) {
        try {
            this.generator.writeBoolean(value);
        }
        catch (JacksonException e) {
            throw Jackson3Utils.convertException(e);
        }
        return this;
    }

    public jakarta.json.stream.JsonGenerator writeNull() {
        try {
            this.generator.writeNull();
        }
        catch (JacksonException e) {
            throw Jackson3Utils.convertException(e);
        }
        return this;
    }

    public void close() {
        try {
            this.generator.close();
        }
        catch (JacksonException e) {
            throw Jackson3Utils.convertException(e);
        }
    }

    public void flush() {
        try {
            this.generator.flush();
        }
        catch (JacksonException e) {
            throw Jackson3Utils.convertException(e);
        }
    }

    private void writeValue(JsonValue value) {
        switch (value.getValueType()) {
            case OBJECT: {
                this.generator.writeStartObject();
                for (Map.Entry entry : value.asJsonObject().entrySet()) {
                    this.generator.writeName((String)entry.getKey());
                    this.writeValue((JsonValue)entry.getValue());
                }
                this.generator.writeEndObject();
                break;
            }
            case ARRAY: {
                this.generator.writeStartArray();
                for (JsonValue item : value.asJsonArray()) {
                    this.writeValue(item);
                }
                this.generator.writeEndArray();
                break;
            }
            case STRING: {
                this.generator.writeString(((JsonString)value).getString());
                break;
            }
            case FALSE: {
                this.generator.writeBoolean(false);
                break;
            }
            case TRUE: {
                this.generator.writeBoolean(true);
                break;
            }
            case NULL: {
                this.generator.writeNull();
                break;
            }
            case NUMBER: {
                JsonNumber n = (JsonNumber)value;
                if (n.isIntegral()) {
                    this.generator.writeNumber(n.longValue());
                    break;
                }
                this.generator.writeNumber(n.doubleValue());
            }
        }
    }

    public static class Buffering
    extends Jackson3JsonpGenerator
    implements BufferingJsonGenerator {
        private final Jackson3JsonpMapper mapper;

        public Buffering(Jackson3JsonpMapper mapper) {
            super((JsonGenerator)TokenBuffer.forGeneration());
            this.mapper = mapper;
        }

        @Override
        public JsonData getJsonData() {
            this.close();
            return new Jackson3JsonBuffer((TokenBuffer)this.jacksonGenerator(), this.mapper);
        }

        @Override
        public JsonParser getParser() {
            this.close();
            TokenBuffer tokenBuffer = (TokenBuffer)this.jacksonGenerator();
            return new Jackson3JsonpParser(tokenBuffer.asParser(), this.mapper);
        }

        @Override
        public void copyValue(JsonParser parser) {
            if (!(parser instanceof Jackson3JsonpGenerator)) {
                throw new IllegalArgumentException("Can only be used with a JacksonJsonpGenerator");
            }
            tools.jackson.core.JsonParser jkParser = ((Jackson3JsonpParser)parser).jacksonParser();
            try {
                this.jacksonGenerator().copyCurrentStructure(jkParser);
            }
            catch (JacksonException e) {
                throw Jackson3Utils.convertException(e);
            }
        }
    }
}

