/*
 * Decompiled with CFR 0.152.
 */
package com.ats.flex.messaging.amf.io;

import com.ats.flex.amf.AMF3Constants;
import com.ats.flex.messaging.amf.io.util.Converter;
import com.ats.flex.messaging.amf.io.util.DefaultClassGetter;
import com.ats.flex.messaging.amf.io.util.DefaultConverter;
import com.ats.flex.messaging.amf.io.util.DefaultJavaClassDescriptor;
import com.ats.flex.messaging.amf.io.util.IndexedJavaClassDescriptor;
import com.ats.flex.messaging.amf.io.util.JavaClassDescriptor;
import com.ats.flex.messaging.amf.io.util.LazyUtil;
import com.ats.flex.messaging.amf.io.util.externalizer.Externalizer;
import com.ats.flex.messaging.util.StringUtil;
import com.ats.flex.messaging.util.XMLUtil;
import flex.messaging.io.ArrayCollection;
import java.io.DataOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;

public class AMF3Serializer
extends DataOutputStream
implements ObjectOutput,
AMF3Constants {
    protected static final Log log = LogFactory.getLog(AMF3Serializer.class);
    protected static final Log logMore = LogFactory.getLog((String)(AMF3Serializer.class.getName() + ".MORE"));
    protected final boolean debug;
    protected final boolean debugMore;
    protected final Map<String, Integer> storedStrings = new HashMap<String, Integer>();
    protected final Map<Object, Integer> storedObjects = new IdentityHashMap<Object, Integer>();
    protected final Map<String, IndexedJavaClassDescriptor> storedClassDescriptors = new HashMap<String, IndexedJavaClassDescriptor>();
    protected final Converter converter = new DefaultConverter();
    protected final XMLUtil xmlUtil = new XMLUtil();

    public AMF3Serializer(OutputStream out) {
        super(out);
        this.debug = log.isDebugEnabled();
        this.debugMore = logMore.isDebugEnabled();
        if (this.debugMore) {
            this.debug("new AMF3Serializer(out=", out, ")");
        }
    }

    @Override
    public void writeObject(Object o) throws IOException {
        if (this.debugMore) {
            this.debug("writeObject(o=", o, ")");
        }
        if (o == null) {
            this.write(1);
        } else if (!(o instanceof Externalizable)) {
            if ((o = this.converter.convertForSerialization(o)) instanceof String || o instanceof Character) {
                this.writeAMF3String(o.toString());
            } else if (o instanceof Boolean) {
                this.write((Boolean)o != false ? 3 : 2);
            } else if (o instanceof Number) {
                if (o instanceof Integer || o instanceof Short || o instanceof Byte) {
                    this.writeAMF3Integer(((Number)o).intValue());
                } else {
                    this.writeAMF3Number(((Number)o).doubleValue());
                }
            } else if (o instanceof Date) {
                this.writeAMF3Date((Date)o);
            } else if (o instanceof Calendar) {
                this.writeAMF3Date(((Calendar)o).getTime());
            } else if (o instanceof Document) {
                this.writeAMF3Xml((Document)o);
            } else if (o instanceof Collection) {
                this.writeAMF3Collection((Collection)o);
            } else if (o.getClass().isArray()) {
                if (o.getClass().getComponentType() == Byte.TYPE) {
                    this.writeAMF3ByteArray((byte[])o);
                } else {
                    this.writeAMF3Array(o);
                }
            } else if (o instanceof Map) {
                this.writeAMF3AssociativeArray((Map)o);
            } else {
                this.writeAMF3Object(o);
            }
        } else {
            this.writeAMF3Object(o);
        }
    }

    protected void writeAMF3Integer(int i) throws IOException {
        if (this.debugMore) {
            this.debug("writeAMF3Integer(i=", String.valueOf(i), ")");
        }
        if (i < -268435456 || i > 0xFFFFFFF) {
            if (this.debugMore) {
                this.debug("writeAMF3Integer() - ", i, " is out of AMF3 int range, writing it as a Number");
            }
            this.writeAMF3Number(i);
        } else {
            this.write(4);
            this.writeAMF3IntegerData(i);
        }
    }

    protected void writeAMF3IntegerData(int i) throws IOException {
        if (this.debugMore) {
            this.debug("writeAMF3IntegerData(i=", String.valueOf(i), ")");
        }
        if (i < -268435456 || i > 0xFFFFFFF) {
            throw new IllegalArgumentException("Integer out of range: " + i);
        }
        if (i < 0 || i >= 0x200000) {
            this.write(i >> 22 & 0x7F | 0x80);
            this.write(i >> 15 & 0x7F | 0x80);
            this.write(i >> 8 & 0x7F | 0x80);
            this.write(i & 0xFF);
        } else {
            if (i >= 16384) {
                this.write(i >> 14 & 0x7F | 0x80);
            }
            if (i >= 128) {
                this.write(i >> 7 & 0x7F | 0x80);
            }
            this.write(i & 0x7F);
        }
    }

    protected void writeAMF3Number(double d) throws IOException {
        if (this.debugMore) {
            this.debug("writeAMF3Number(d=", d, ")");
        }
        this.write(5);
        this.writeDouble(d);
    }

    protected void writeAMF3String(String s) throws IOException {
        if (this.debugMore) {
            this.debug("writeAMF3String(s=", StringUtil.toString(s), ")");
        }
        this.write(6);
        this.writeAMF3StringData(s);
    }

    protected void writeAMF3StringData(String s) throws IOException {
        if (this.debugMore) {
            this.debug("writeAMF3StringData(s=", StringUtil.toString(s), ")");
        }
        if (s.length() == 0) {
            this.write(1);
            return;
        }
        int index = this.indexOfStoredStrings(s);
        if (index >= 0) {
            this.writeAMF3IntegerData(index << 1);
        } else {
            char c;
            int i;
            this.addToStoredStrings(s);
            int sLength = s.length();
            int uLength = 0;
            for (i = 0; i < sLength; ++i) {
                c = s.charAt(i);
                if (c >= '\u0001' && c <= '\u007f') {
                    ++uLength;
                    continue;
                }
                if (c > '\u07ff') {
                    uLength += 3;
                    continue;
                }
                uLength += 2;
            }
            this.writeAMF3IntegerData(uLength << 1 | 1);
            for (i = 0; i < sLength; ++i) {
                c = s.charAt(i);
                if (c >= '\u0001' && c <= '\u007f') {
                    this.write(c);
                    continue;
                }
                if (c > '\u07ff') {
                    this.write(0xE0 | c >> 12 & 0xF);
                    this.write(0x80 | c >> 6 & 0x3F);
                    this.write(0x80 | c >> 0 & 0x3F);
                    continue;
                }
                this.write(0xC0 | c >> 6 & 0x1F);
                this.write(0x80 | c >> 0 & 0x3F);
            }
        }
    }

    protected void writeAMF3Xml(Document doc) throws IOException {
        if (this.debugMore) {
            this.debug("writeAMF3Xml(doc=", doc, ")");
        }
        this.write(7);
        int index = this.indexOfStoredObjects(doc);
        if (index >= 0) {
            this.writeAMF3IntegerData(index << 1);
        } else {
            this.addToStoredObjects(doc);
            byte[] bytes = this.xmlUtil.toString(doc).getBytes("UTF-8");
            this.writeAMF3IntegerData(bytes.length << 1 | 1);
            this.write(bytes);
        }
    }

    protected void writeAMF3Date(Date date) throws IOException {
        if (this.debugMore) {
            this.debug("writeAMF3Date(date=", date, ")");
        }
        this.write(8);
        int index = this.indexOfStoredObjects(date);
        if (index >= 0) {
            this.writeAMF3IntegerData(index << 1);
        } else {
            this.addToStoredObjects(date);
            this.writeAMF3IntegerData(1);
            this.writeDouble(date.getTime());
        }
    }

    protected void writeAMF3Array(Object array) throws IOException {
        if (this.debugMore) {
            this.debug("writeAMF3Array(array=", array, ")");
        }
        this.write(9);
        int index = this.indexOfStoredObjects(array);
        if (index >= 0) {
            this.writeAMF3IntegerData(index << 1);
        } else {
            this.addToStoredObjects(array);
            int length = Array.getLength(array);
            this.writeAMF3IntegerData(length << 1 | 1);
            this.write(1);
            for (int i = 0; i < length; ++i) {
                this.writeObject(Array.get(array, i));
            }
        }
    }

    protected void writeAMF3AssociativeArray(Map<?, ?> map) throws IOException {
        if (this.debugMore) {
            this.debug("writeAMF3AssociativeArray(array=", map, ")");
        }
        this.write(9);
        int index = this.indexOfStoredObjects(map);
        if (index >= 0) {
            this.writeAMF3IntegerData(index << 1);
        } else {
            this.addToStoredObjects(map);
            this.write(1);
            for (Object key : map.keySet()) {
                this.writeAMF3StringData(key.toString());
                this.writeObject(map.get(key));
            }
            this.writeAMF3StringData("");
        }
    }

    protected void writeAMF3ByteArray(byte[] bytes) throws IOException {
        if (this.debugMore) {
            this.debug("writeAMF3ByteArray(bytes=", bytes, ")");
        }
        this.write(12);
        int index = this.indexOfStoredObjects(bytes);
        if (index >= 0) {
            this.writeAMF3IntegerData(index << 1);
        } else {
            this.addToStoredObjects(bytes);
            this.writeAMF3IntegerData(bytes.length << 1 | 1);
            this.write(bytes);
        }
    }

    protected void writeAMF3Collection(Collection<?> c) throws IOException {
        if (this.debugMore) {
            this.debug("writeAMF3Collection(c=", c, ")");
        }
        ArrayCollection ac = c instanceof ArrayCollection ? (ArrayCollection)c : new ArrayCollection(c);
        this.writeAMF3Object(ac);
    }

    protected void writeAMF3Object(Object o) throws IOException {
        if (this.debug) {
            this.debug("writeAMF3Object(o=", o, ")...");
        }
        this.write(10);
        int index = this.indexOfStoredObjects(o);
        if (index >= 0) {
            this.writeAMF3IntegerData(index << 1);
        } else {
            int i;
            this.addToStoredObjects(o);
            DefaultClassGetter classGetter = new DefaultClassGetter();
            if (this.debug) {
                this.debug("writeAMF3Object() - classGetter=", classGetter);
            }
            Class<?> oClass = classGetter.getClass(o);
            if (this.debug) {
                this.debug("writeAMF3Object() - oClass=", oClass);
            }
            JavaClassDescriptor desc = null;
            IndexedJavaClassDescriptor iDesc = this.getFromStoredClassDescriptors(oClass);
            if (iDesc != null) {
                desc = iDesc.getDescriptor();
                this.writeAMF3IntegerData(iDesc.getIndex() << 2 | 1);
            } else {
                iDesc = this.addToStoredClassDescriptors(oClass);
                desc = iDesc.getDescriptor();
                LazyUtil.removeLazyFields(desc, o);
                this.writeAMF3IntegerData(desc.getPropertiesCount() << 4 | desc.getEncoding() << 2 | 3);
                this.writeAMF3StringData(desc.getName());
                for (i = 0; i < desc.getPropertiesCount(); ++i) {
                    this.writeAMF3StringData(desc.getPropertyName(i));
                }
            }
            if (this.debug) {
                this.debug("writeAMF3Object() - desc=", desc);
            }
            if (desc.isExternalizable()) {
                Externalizer externalizer = desc.getExternalizer();
                if (externalizer != null) {
                    if (this.debug) {
                        this.debug("writeAMF3Object() - using externalizer=", externalizer);
                    }
                    try {
                        externalizer.writeExternal(o, this);
                    }
                    catch (IOException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Could not externalize object: " + String.valueOf(o), e);
                    }
                } else {
                    if (this.debug) {
                        this.debug("writeAMF3Object() - legacy Externalizable=", o);
                    }
                    ((Externalizable)o).writeExternal(this);
                }
            } else {
                if (this.debug) {
                    this.debug("writeAMF3Object() - writing defined properties...");
                }
                for (i = 0; i < desc.getPropertiesCount(); ++i) {
                    Object obj = desc.getPropertyValue(i, o);
                    if (LazyUtil.isProxy(obj)) {
                        this.writeObject(null);
                        continue;
                    }
                    LazyUtil.removeLazyFields(desc, o);
                    this.writeObject(obj);
                }
                if (desc.isDynamic()) {
                    if (this.debug) {
                        this.debug("writeAMF3Object() - writing dynamic properties...");
                    }
                    Map oMap = (Map)o;
                    for (Map.Entry entry : oMap.entrySet()) {
                        String propertyName;
                        Object key = entry.getKey();
                        if (key == null || (propertyName = key.toString()).length() <= 0) continue;
                        if (this.debug) {
                            this.debug("writeAMF3Object() - writing dynamic property: ", propertyName, "=", entry.getValue());
                        }
                        this.writeAMF3StringData(propertyName);
                        this.writeObject(entry.getValue());
                    }
                    this.writeAMF3StringData("");
                }
            }
        }
        if (this.debug) {
            this.debug("writeAMF3Object(o=", o, ") - Done.");
        }
    }

    protected void addToStoredStrings(String s) {
        if (!this.storedStrings.containsKey(s)) {
            Integer index = this.storedStrings.size();
            if (this.debug) {
                this.debug("addToStoredStrings(s=", StringUtil.toString(s), ") at index=", index.toString());
            }
            this.storedStrings.put(s, index);
        }
    }

    protected int indexOfStoredStrings(String s) {
        Integer index = this.storedStrings.get(s);
        if (this.debug) {
            this.debug("indexOfStoredStrings(s=", StringUtil.toString(s), ") -> ", String.valueOf(index != null ? index : -1));
        }
        return index != null ? index : -1;
    }

    protected void addToStoredObjects(Object o) {
        if (o != null && !this.storedObjects.containsKey(o)) {
            Integer index = this.storedObjects.size();
            if (this.debug) {
                this.debug("addToStoredObjects(o=", o, ") at index=", index.toString());
            }
            this.storedObjects.put(o, index);
        }
    }

    protected int indexOfStoredObjects(Object o) {
        Integer index = this.storedObjects.get(o);
        if (this.debug) {
            this.debug("indexOfStoredObjects(o=", o, ") -> ", String.valueOf(index != null ? index : -1));
        }
        return index != null ? index : -1;
    }

    protected IndexedJavaClassDescriptor addToStoredClassDescriptors(Class<?> clazz) {
        String name = JavaClassDescriptor.getClassName(clazz);
        if (this.debug) {
            this.debug("addToStoredClassDescriptors(clazz=", clazz, ")");
        }
        if (this.storedClassDescriptors.containsKey(name)) {
            throw new RuntimeException("Descriptor of \"" + name + "\" is already stored at index: " + this.getFromStoredClassDescriptors(clazz).getIndex());
        }
        DefaultJavaClassDescriptor desc = null;
        if (desc == null) {
            desc = new DefaultJavaClassDescriptor(clazz);
        }
        IndexedJavaClassDescriptor iDesc = new IndexedJavaClassDescriptor(this.storedClassDescriptors.size(), desc);
        if (this.debug) {
            this.debug("addToStoredClassDescriptors() - putting: name=", name, ", iDesc=", iDesc);
        }
        this.storedClassDescriptors.put(name, iDesc);
        return iDesc;
    }

    protected IndexedJavaClassDescriptor getFromStoredClassDescriptors(Class<?> clazz) {
        if (this.debug) {
            this.debug("getFromStoredClassDescriptors(clazz=", clazz, ")");
        }
        String name = JavaClassDescriptor.getClassName(clazz);
        IndexedJavaClassDescriptor iDesc = this.storedClassDescriptors.get(name);
        if (this.debug) {
            this.debug("getFromStoredClassDescriptors() -> ", iDesc);
        }
        return iDesc;
    }

    protected void debug(Object ... msgs) {
        this.debug(null, msgs);
    }

    protected void debug(Throwable t, Object ... msgs) {
        String message = "";
        if (msgs != null && msgs.length > 0) {
            if (msgs.length == 1) {
                message = String.valueOf(msgs[0]);
            } else {
                StringBuilder sb = new StringBuilder();
                for (Object o : msgs) {
                    if (o instanceof String) {
                        sb.append(o);
                        continue;
                    }
                    sb.append(StringUtil.toString(o));
                }
                message = sb.toString();
            }
        }
        if (t != null) {
            log.debug((Object)message, t);
        } else {
            log.debug((Object)message);
        }
    }
}

