/*
 * Decompiled with CFR 0.152.
 */
package com.ats.flex.messaging.amf.io.util.instanciator;

import com.ats.flex.messaging.amf.io.util.instanciator.AbstractInstanciator;
import com.ats.flex.messaging.util.ClassUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class EnumInstanciator
extends AbstractInstanciator<Enum<?>> {
    private static final long serialVersionUID = -6116814787518316453L;
    private final String type;
    private static final List<String> orderedFields;

    public EnumInstanciator(String type) {
        this.type = type;
    }

    @Override
    public List<String> getOrderedFieldNames() {
        return orderedFields;
    }

    @Override
    public Enum<?> newInstance() {
        Enum<?> enumInstance = null;
        try {
            Class<?> enumClass = ClassUtil.forName(this.type);
            String enumValue = (String)this.get("value");
            if (enumValue == null) {
                ?[] enumConstants = enumClass.getEnumConstants();
                enumValue = ((Enum)enumConstants[0]).name();
            }
            enumInstance = (Enum<?>)Enum.valueOf(enumClass, enumValue);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        return enumInstance;
    }

    static {
        ArrayList<String> of = new ArrayList<String>(1);
        of.add("value");
        orderedFields = Collections.unmodifiableList(of);
    }
}

