/*
 * Decompiled with CFR 0.152.
 */
package com.ats.flex.messaging.util;

import java.lang.invoke.CallSite;
import java.lang.reflect.Array;
import java.nio.ByteBuffer;
import java.nio.LongBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class StringUtil {
    public static final String HEX_CHARS = "0123456789ABCDEF";

    public static String toHexString(Number n) {
        if (n == null) {
            return "null";
        }
        byte[] bytes = new byte[8];
        ByteBuffer bytesBuffer = ByteBuffer.wrap(bytes);
        LongBuffer longBuffer = bytesBuffer.asLongBuffer();
        longBuffer.put(0, n.longValue());
        StringBuilder sb = new StringBuilder(16);
        for (int i = 0; i < bytes.length; ++i) {
            int b = bytes[i] & 0xFF;
            if (b == 0 && sb.length() <= 0 && i != bytes.length - 1) continue;
            sb.append(HEX_CHARS.charAt(b >> 4)).append(HEX_CHARS.charAt(b & 0xF));
        }
        return sb.toString();
    }

    public static String toString(Object o) {
        return StringUtil.toString(o, -1);
    }

    public static String toString(Object o, int maxItems) {
        if (o == null) {
            return "null";
        }
        if (o instanceof String) {
            return "\"" + String.valueOf(o) + "\"";
        }
        if (o instanceof Character || o.getClass() == Character.TYPE) {
            return "'" + String.valueOf(o) + "'";
        }
        if (o instanceof Number) {
            if (o instanceof Byte || o instanceof Short || o instanceof Integer || o instanceof Long) {
                return String.valueOf(o) + " <0x" + StringUtil.toHexString((Number)((Object)o)) + ">";
            }
            return String.valueOf(o);
        }
        if (o.getClass().isArray()) {
            Class<?> type = o.getClass().getComponentType();
            if (maxItems < 0) {
                if (type.isPrimitive()) {
                    if (type == Byte.TYPE) {
                        return Arrays.toString((byte[])o);
                    }
                    if (type == Character.TYPE) {
                        return Arrays.toString((char[])o);
                    }
                    if (type == Integer.TYPE) {
                        return Arrays.toString((int[])o);
                    }
                    if (type == Double.TYPE) {
                        return Arrays.toString((double[])o);
                    }
                    if (type == Long.TYPE) {
                        return Arrays.toString((long[])o);
                    }
                    if (type == Float.TYPE) {
                        return Arrays.toString((float[])o);
                    }
                    if (type == Short.TYPE) {
                        return Arrays.toString((short[])o);
                    }
                    if (type == Boolean.TYPE) {
                        return Arrays.toString((boolean[])o);
                    }
                    return "[Array of unknown primitive type: " + String.valueOf(type) + "]";
                }
                return Arrays.toString((Object[])o);
            }
            int max = Math.min(maxItems, Array.getLength(o));
            ArrayList<Object> list = new ArrayList<Object>(max);
            for (int i = 0; i < max; ++i) {
                list.add(Array.get(o, i));
            }
            if (max < Array.getLength(o)) {
                list.add("(first " + max + "/" + Array.getLength(o) + " elements only...)");
            }
            o = list;
        } else if (o instanceof Collection && maxItems >= 0) {
            Collection coll = o;
            int max = Math.min(maxItems, coll.size());
            ArrayList<CallSite> list = new ArrayList<CallSite>(max);
            int i = 0;
            for (Object item : coll) {
                if (i >= max) {
                    list.add((CallSite)((Object)("(first " + max + "/" + coll.size() + " elements only...)")));
                    break;
                }
                list.add((CallSite)item);
                ++i;
            }
            o = list;
        } else if (o instanceof Map && maxItems >= 0) {
            Map map = (Map)((Object)o);
            int max = Math.min(maxItems, map.size());
            HashMap<CallSite, String> copy = new HashMap<CallSite, String>(max);
            int i = 0;
            for (Map.Entry item : map.entrySet()) {
                if (i >= max) {
                    copy.put((CallSite)((Object)("(first " + max + "/" + map.size() + " elements only...)")), "...");
                    break;
                }
                copy.put((CallSite)item.getKey(), (String)item.getValue());
                ++i;
            }
            o = copy;
        }
        return String.valueOf(o);
    }
}

