/*
 * Decompiled with CFR 0.152.
 */
package com.ats;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.objecthunter.exp4j.Expression;
import net.objecthunter.exp4j.ExpressionBuilder;
import net.objecthunter.exp4j.operator.Operator;

public class MathEvaluation {
    private int decimal = -1;
    private boolean comma = false;
    private static final String NUMERIC_FUNCTION = "0123456789.,()abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWYYZ-*/+^!><=$;";
    private static final Pattern IF_THEN_ELSE_REGEXP = Pattern.compile("if\\(([^\\)]*);([^\\)]*);([^\\)]*)\\)");

    public MathEvaluation(boolean comma, int decimal) {
        this.comma = comma;
        this.decimal = decimal;
    }

    private Operator getOperator(String data) {
        if (data.contains("<=")) {
            return new Operator("<=", 2, true, 4){

                public double apply(double[] values) {
                    if (values[0] <= values[1]) {
                        return 1.0;
                    }
                    return 0.0;
                }
            };
        }
        if (data.contains(">=")) {
            return new Operator(">=", 2, true, 4){

                public double apply(double[] values) {
                    if (values[0] >= values[1]) {
                        return 1.0;
                    }
                    return 0.0;
                }
            };
        }
        if (data.contains("<")) {
            return new Operator("<", 2, true, 4){

                public double apply(double[] values) {
                    if (values[0] < values[1]) {
                        return 1.0;
                    }
                    return 0.0;
                }
            };
        }
        if (data.contains(">")) {
            return new Operator(">", 2, true, 4){

                public double apply(double[] values) {
                    if (values[0] > values[1]) {
                        return 1.0;
                    }
                    return 0.0;
                }
            };
        }
        return null;
    }

    private Expression getExpressionWithSymbole(ExpressionBuilder builder) {
        return builder.variables(new String[]{"pi", "e"}).build().setVariable("pi", Math.PI).setVariable("e", Math.E);
    }

    public String eval(String data) {
        StringBuilder numericData = new StringBuilder();
        for (int i = 0; i < data.length(); ++i) {
            String s = data.substring(i, i + 1);
            if (NUMERIC_FUNCTION.indexOf(s) == -1) continue;
            numericData.append(s);
        }
        data = numericData.toString();
        if (data.length() > 0) {
            DecimalFormat df;
            if (this.comma) {
                df = new DecimalFormat("0", DecimalFormatSymbols.getInstance(Locale.FRENCH));
                data = data.replace(",", ".");
            } else {
                df = new DecimalFormat("0", DecimalFormatSymbols.getInstance(Locale.ENGLISH));
                data = data.replace(",", "");
            }
            df.setMaximumFractionDigits(340);
            double calc = 0.0;
            Matcher verif = IF_THEN_ELSE_REGEXP.matcher(data);
            if (verif.find()) {
                try {
                    double check;
                    String regData = verif.group(1);
                    ExpressionBuilder builder = new ExpressionBuilder(regData);
                    Operator operator = this.getOperator(regData);
                    if (operator != null) {
                        builder = builder.operator(operator);
                    }
                    if ((check = this.getExpressionWithSymbole(builder).evaluate()) > 0.0) {
                        regData = verif.group(2);
                        builder = new ExpressionBuilder(regData);
                        operator = this.getOperator(regData);
                        if (operator != null) {
                            builder = builder.operator(operator);
                        }
                        calc = this.getExpressionWithSymbole(builder).evaluate();
                    }
                    regData = verif.group(3);
                    builder = new ExpressionBuilder(regData);
                    operator = this.getOperator(regData);
                    if (operator != null) {
                        builder = builder.operator(operator);
                    }
                    calc = this.getExpressionWithSymbole(builder).evaluate();
                }
                catch (Exception e) {
                    return "NaN";
                }
            } else {
                try {
                    ExpressionBuilder builder = new ExpressionBuilder(data);
                    Operator operator = this.getOperator(data);
                    if (operator != null) {
                        builder = builder.operator(operator);
                    }
                    calc = this.getExpressionWithSymbole(builder).evaluate();
                }
                catch (Exception e) {
                    return "NaN";
                }
            }
            String result = null;
            BigDecimal bd = BigDecimal.valueOf(calc);
            result = this.decimal > -1 ? bd.setScale(this.decimal, RoundingMode.HALF_UP).toPlainString() : bd.toPlainString().replaceFirst("\\.0$", "");
            if (this.comma) {
                return result.replace(".", ",");
            }
            return result.replace(",", ".");
        }
        return "0";
    }
}

