/*
 * Decompiled with CFR 0.152.
 */
package com.ats.driver;

import com.ats.driver.ApplicationProperties;
import com.ats.driver.AtsProxy;
import com.ats.executor.ActionTestScript;
import com.ats.executor.TestBound;
import com.ats.generator.ATS;
import com.ats.tools.AtsClassLoader;
import com.ats.tools.Utils;
import com.ats.tools.performance.external.OctoperfApi;
import com.ats.tools.wait.IWaitGuiReady;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class AtsManager {
    public static final String ATS_FOLDER = ".actiontestscript";
    private static final String DRIVERS_FOLDER = "drivers";
    private static final String ATS_PROPERTIES_FILE = ".atsProperties";
    private static final Double APPLICATION_WIDTH = 1280.0;
    private static final Double APPLICATION_HEIGHT = 960.0;
    private static final Double APPLICATION_X = 10.0;
    private static final Double APPLICATION_Y = 10.0;
    private static final int SCRIPT_TIMEOUT = 60;
    private static final int PAGELOAD_TIMEOUT = 120;
    private static final int WATCHDOG_TIMEOUT = 200;
    private static final int WEBSERVICE_TIMEOUT = 20;
    private static final int MAX_TRY_SEARCH = 15;
    private static final int MAX_TRY_INTERACTABLE = 20;
    private static final int MAX_TRY_PROPERTY = 10;
    private static final int MAX_TRY_WEBSERVICE = 1;
    private static final int MAX_TRY_IMAGE_RECOGNITION = 20;
    private static final int MAX_TRY_SCROLL_SEARCH = 15;
    private static final int MAX_TRY_MOBILE = 5;
    private static final int SCROLL_UNIT = 120;
    private static final int MAX_STALE_OR_JAVASCRIPT_ERROR = 20;
    private static final int CAPTURE_PROXY_TRAFFIC_IDLE = 3;
    private Path driversFolderPath;
    private Properties properties;
    private double applicationWidth = APPLICATION_WIDTH;
    private double applicationHeight = APPLICATION_HEIGHT;
    private double applicationX = APPLICATION_X;
    private double applicationY = APPLICATION_Y;
    private int scriptTimeOut = 60;
    private int pageloadTimeOut = 120;
    private int watchDogTimeOut = 200;
    private int webServiceTimeOut = 20;
    private int maxTrySearch = 15;
    private int maxTryInteractable = 20;
    private int maxTryProperty = 10;
    private int maxTryWebservice = 1;
    private int maxTryMobile = 5;
    private int maxTryImageRecognition = 20;
    private int maxTryScrollSearch = 15;
    private AtsProxy proxy;
    private AtsProxy neoloadProxy;
    private String neoloadDesignApi;
    private OctoperfApi octoperf;
    private ArrayList<String> blackListServers;
    private int trafficIdle = 3;
    private List<ApplicationProperties> applicationsList = new ArrayList<ApplicationProperties>();
    private String error;
    private static volatile AtsManager singleInstance;
    private AtsClassLoader atsClassLoader;

    public static int getScrollUnit() {
        return 120;
    }

    public static int getMaxStaleOrJavaScriptError() {
        return 20;
    }

    private static String getElementText(Node node) {
        return AtsManager.getElementText((Element)node);
    }

    private static String getElementText(Element elem) {
        String textContent;
        if (elem != null && (textContent = elem.getTextContent()) != null && textContent.length() > 0) {
            return textContent.replaceAll("\n", "").replaceAll("\r", "").trim();
        }
        return null;
    }

    private static double getElementDouble(Element elem) {
        String value = elem.getTextContent().replaceAll("\n", "").replaceAll("\r", "").trim();
        try {
            return Double.parseDouble(value);
        }
        catch (NumberFormatException numberFormatException) {
            return 0.0;
        }
    }

    private static int getElementInt(Element elem) {
        String value = elem.getTextContent().replaceAll("\n", "").replaceAll("\r", "").trim();
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AtsManager getInstance() {
        if (singleInstance != null) return singleInstance;
        Class<AtsManager> clazz = AtsManager.class;
        synchronized (AtsManager.class) {
            if (singleInstance != null) return singleInstance;
            singleInstance = new AtsManager();
            singleInstance.init();
            // ** MonitorExit[var0] (shouldn't be in output)
            return singleInstance;
        }
    }

    private AtsManager() {
        if (singleInstance != null) {
            throw new RuntimeException("Use getInstance() method to get the single instance of this class.");
        }
    }

    public static String getAtsHomeFolder() {
        Object atsHome = System.getProperty("ats.home");
        if (!(atsHome != null && ((String)atsHome).length() != 0 || (atsHome = System.getenv("ATS_HOME")) != null && ((String)atsHome).length() != 0)) {
            atsHome = System.getProperty("user.home") + File.separator + ATS_FOLDER;
        }
        return atsHome;
    }

    public void init() {
        String atsHome = AtsManager.getAtsHomeFolder();
        Path atsFolderPath = Paths.get(atsHome, new String[0]);
        if (atsFolderPath.toFile().exists()) {
            Path userHomePath = Paths.get(System.getProperty("user.home"), new String[0]);
            Path atsPropertiesFilePath = userHomePath.resolve(ATS_PROPERTIES_FILE);
            if (!Files.exists(atsPropertiesFilePath, new LinkOption[0]) && !Files.exists(atsPropertiesFilePath = userHomePath.resolve(ATS_FOLDER).resolve(ATS_PROPERTIES_FILE), new LinkOption[0])) {
                atsPropertiesFilePath = atsFolderPath.resolve(ATS_PROPERTIES_FILE);
            }
            this.properties = this.loadProperties(atsPropertiesFilePath);
            this.driversFolderPath = atsFolderPath.resolve(DRIVERS_FOLDER);
        } else {
            this.driversFolderPath = Paths.get("", new String[0]);
            ATS.logWarn("ATS driver folder not found -> " + atsHome);
        }
        if (this.proxy == null) {
            this.proxy = new AtsProxy("system");
        }
        this.atsClassLoader = new AtsClassLoader();
    }

    public IWaitGuiReady getWaitGuiReady() {
        return this.atsClassLoader.getWaitGuiReady();
    }

    public Class<ActionTestScript> loadTestScriptClass(String name) {
        return this.atsClassLoader.loadTestScriptClass(name);
    }

    private Properties loadProperties(Path propertiesPath) {
        File xmlFile = propertiesPath.toFile();
        if (xmlFile.exists()) {
            try {
                DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
                try {
                    DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
                    Document doc = dBuilder.parse(xmlFile);
                    doc.getDocumentElement().normalize();
                    NodeList executeChildren = ((Element)doc.getChildNodes().item(0)).getChildNodes();
                    block151: for (int i = 0; i < executeChildren.getLength(); ++i) {
                        if (!(executeChildren.item(i) instanceof Element)) continue;
                        Element type = (Element)executeChildren.item(i);
                        String url = null;
                        switch (type.getNodeName().toLowerCase()) {
                            case "performance": {
                                NodeList perfChildren = type.getChildNodes();
                                block152: for (int j = 0; j < perfChildren.getLength(); ++j) {
                                    if (!(perfChildren.item(j) instanceof Element)) continue;
                                    Element perfElement = (Element)perfChildren.item(j);
                                    switch (perfElement.getNodeName().toLowerCase()) {
                                        case "idle": {
                                            this.trafficIdle = AtsManager.getElementInt(perfElement);
                                            continue block152;
                                        }
                                        case "octoperf": {
                                            String host = null;
                                            String apiKey = null;
                                            String workspaceName = null;
                                            String projectName = null;
                                            NodeList nl = perfElement.getElementsByTagName("host");
                                            if (nl != null) {
                                                host = AtsManager.getElementText(nl.item(0));
                                            }
                                            if ((nl = perfElement.getElementsByTagName("apiKey")) != null) {
                                                apiKey = AtsManager.getElementText(nl.item(0));
                                            }
                                            if ((nl = perfElement.getElementsByTagName("workspaceName")) != null) {
                                                workspaceName = AtsManager.getElementText(nl.item(0));
                                            }
                                            if ((nl = perfElement.getElementsByTagName("projectName")) != null) {
                                                projectName = AtsManager.getElementText(nl.item(0));
                                            }
                                            if (host == null || apiKey == null) continue block152;
                                            this.octoperf = new OctoperfApi(host, apiKey, workspaceName, projectName);
                                            continue block152;
                                        }
                                        case "blacklist": {
                                            this.blackListServers = new ArrayList();
                                            NodeList blackList = perfElement.getElementsByTagName("url");
                                            for (int k = 0; k < blackList.getLength(); ++k) {
                                                if (!(blackList.item(k) instanceof Element)) continue;
                                                this.blackListServers.add(AtsManager.getElementText(blackList.item(k)));
                                            }
                                            continue block152;
                                        }
                                    }
                                }
                                continue block151;
                            }
                            case "neoload": {
                                NodeList neoloadChildren = type.getChildNodes();
                                for (int j = 0; j < neoloadChildren.getLength(); ++j) {
                                    int k;
                                    if (!(neoloadChildren.item(j) instanceof Element)) continue;
                                    Element neoloadElement = (Element)neoloadChildren.item(j);
                                    String host = null;
                                    String port = null;
                                    Object api = null;
                                    String apiPort = null;
                                    if (neoloadElement.getTagName().equals("recorder")) {
                                        NodeList recorderChildren = neoloadElement.getChildNodes();
                                        for (k = 0; k < recorderChildren.getLength(); ++k) {
                                            if (!(recorderChildren.item(k) instanceof Element)) continue;
                                            Element recorderElement = (Element)recorderChildren.item(k);
                                            if (recorderElement.getNodeName().equals("host")) {
                                                host = AtsManager.getElementText(recorderElement);
                                                continue;
                                            }
                                            if (!recorderElement.getNodeName().equals("port")) continue;
                                            port = AtsManager.getElementText(recorderElement);
                                        }
                                    } else if (neoloadElement.getTagName().equals("design")) {
                                        NodeList designChildren = neoloadElement.getChildNodes();
                                        for (k = 0; k < designChildren.getLength(); ++k) {
                                            if (!(designChildren.item(k) instanceof Element)) continue;
                                            Element designElement = (Element)designChildren.item(k);
                                            if (designElement.getNodeName().equals("api")) {
                                                api = AtsManager.getElementText(designElement);
                                                continue;
                                            }
                                            if (!designElement.getNodeName().equals("port")) continue;
                                            apiPort = AtsManager.getElementText(designElement);
                                        }
                                    }
                                    if (host == null || port == null) continue;
                                    this.neoloadProxy = new AtsProxy(host, Utils.string2Int(port, 8080));
                                    if (api == null || apiPort == null) continue;
                                    if (!((String)api).startsWith("/")) {
                                        api = "/" + (String)api;
                                    }
                                    if (!((String)api).endsWith("/")) {
                                        api = (String)api + "/";
                                    }
                                    this.neoloadDesignApi = "http://" + this.neoloadProxy.getHost() + ":" + apiPort + (String)api;
                                }
                                continue block151;
                            }
                            case "proxy": {
                                NodeList proxyChildren = type.getChildNodes();
                                String proxyType = null;
                                String host = null;
                                int port = 0;
                                block157: for (int j = 0; j < proxyChildren.getLength(); ++j) {
                                    if (!(proxyChildren.item(j) instanceof Element)) continue;
                                    Element proxyElement = (Element)proxyChildren.item(j);
                                    switch (proxyElement.getNodeName().toLowerCase()) {
                                        case "type": {
                                            proxyType = AtsManager.getElementText(proxyElement);
                                            continue block157;
                                        }
                                        case "host": {
                                            host = AtsManager.getElementText(proxyElement);
                                            continue block157;
                                        }
                                        case "url": {
                                            url = AtsManager.getElementText(proxyElement);
                                            continue block157;
                                        }
                                        case "port": {
                                            port = AtsManager.getElementInt(proxyElement);
                                        }
                                    }
                                }
                                if ("auto".equals(proxyType)) {
                                    this.proxy = new AtsProxy("auto");
                                    continue block151;
                                }
                                if ("direct".equals(proxyType)) {
                                    this.proxy = new AtsProxy("direct");
                                    continue block151;
                                }
                                if ("pac".equals(proxyType)) {
                                    this.proxy = new AtsProxy("pac", url);
                                    continue block151;
                                }
                                if ("manual".equals(proxyType) && host != null && port > 0) {
                                    this.proxy = new AtsProxy("manual", host, port);
                                    continue block151;
                                }
                                this.proxy = new AtsProxy("system");
                                continue block151;
                            }
                            case "appbounding": {
                                NodeList boundingChildren = type.getChildNodes();
                                for (int j = 0; j < boundingChildren.getLength(); ++j) {
                                    if (boundingChildren.item(j) instanceof Element) {
                                        Element boundingElement = (Element)boundingChildren.item(j);
                                        switch (boundingElement.getTagName()) {
                                            case "x": {
                                                this.applicationX = AtsManager.getElementDouble(boundingElement);
                                                break;
                                            }
                                            case "y": {
                                                this.applicationY = AtsManager.getElementDouble(boundingElement);
                                                break;
                                            }
                                            case "width": {
                                                this.applicationWidth = AtsManager.getElementDouble(boundingElement);
                                                break;
                                            }
                                            case "height": {
                                                this.applicationHeight = AtsManager.getElementDouble(boundingElement);
                                            }
                                        }
                                        continue;
                                    }
                                    String content = boundingChildren.item(j).getTextContent();
                                    if (!"fullscreen".equalsIgnoreCase(content) && !"max".equalsIgnoreCase(content) && !"maxscreen".equalsIgnoreCase(content) && !"maxsize".equalsIgnoreCase(content)) continue;
                                    this.applicationX = 0.0;
                                    this.applicationY = 0.0;
                                    this.applicationWidth = -1.0;
                                    this.applicationHeight = -1.0;
                                }
                                continue block151;
                            }
                            case "maxtry": {
                                NodeList maxtryChildren = type.getChildNodes();
                                block159: for (int j = 0; j < maxtryChildren.getLength(); ++j) {
                                    if (!(maxtryChildren.item(j) instanceof Element)) continue;
                                    Element maxtryElement = (Element)maxtryChildren.item(j);
                                    switch (maxtryElement.getTagName().toLowerCase()) {
                                        case "searchelement": {
                                            this.maxTrySearch = AtsManager.getElementInt(maxtryElement);
                                            continue block159;
                                        }
                                        case "interactable": {
                                            this.maxTryInteractable = AtsManager.getElementInt(maxtryElement);
                                            continue block159;
                                        }
                                        case "getproperty": {
                                            this.maxTryProperty = AtsManager.getElementInt(maxtryElement);
                                            continue block159;
                                        }
                                        case "webservice": {
                                            this.maxTryWebservice = AtsManager.getElementInt(maxtryElement);
                                            continue block159;
                                        }
                                        case "searchimage": {
                                            this.maxTryImageRecognition = AtsManager.getElementInt(maxtryElement);
                                            continue block159;
                                        }
                                        case "scrollsearch": {
                                            this.maxTryScrollSearch = AtsManager.getElementInt(maxtryElement);
                                        }
                                    }
                                }
                                continue block151;
                            }
                            case "timeout": {
                                NodeList timeoutChildren = type.getChildNodes();
                                block160: for (int j = 0; j < timeoutChildren.getLength(); ++j) {
                                    if (!(timeoutChildren.item(j) instanceof Element)) continue;
                                    Element timeoutElement = (Element)timeoutChildren.item(j);
                                    switch (timeoutElement.getTagName().toLowerCase()) {
                                        case "script": {
                                            this.scriptTimeOut = AtsManager.getElementInt(timeoutElement);
                                            continue block160;
                                        }
                                        case "pageload": {
                                            this.pageloadTimeOut = AtsManager.getElementInt(timeoutElement);
                                            continue block160;
                                        }
                                        case "watchdog": {
                                            this.watchDogTimeOut = AtsManager.getElementInt(timeoutElement);
                                            continue block160;
                                        }
                                        case "webservice": {
                                            this.webServiceTimeOut = AtsManager.getElementInt(timeoutElement);
                                        }
                                    }
                                }
                                continue block151;
                            }
                            case "browsers": {
                                NodeList browsers = type.getElementsByTagName("browser");
                                for (int j = 0; j < browsers.getLength(); ++j) {
                                    String name = null;
                                    String waitAction = null;
                                    String path = null;
                                    String driver = null;
                                    String dataDir = null;
                                    String check = null;
                                    String lang = null;
                                    String debugPort = null;
                                    String[] options = null;
                                    String title = "";
                                    if (!(browsers.item(j) instanceof Element)) continue;
                                    Element browser = (Element)browsers.item(j);
                                    NodeList browserAttributes = browser.getChildNodes();
                                    block162: for (int k = 0; k < browserAttributes.getLength(); ++k) {
                                        if (!(browserAttributes.item(k) instanceof Element)) continue;
                                        Element browserElement = (Element)browserAttributes.item(k);
                                        switch (browserElement.getNodeName().toLowerCase()) {
                                            case "name": {
                                                name = AtsManager.getElementText(browserElement);
                                                continue block162;
                                            }
                                            case "waitaction": {
                                                waitAction = AtsManager.getElementText(browserElement);
                                                continue block162;
                                            }
                                            case "title": {
                                                title = AtsManager.getElementText(browserElement);
                                                continue block162;
                                            }
                                            case "driver": {
                                                driver = AtsManager.getElementText(browserElement);
                                                continue block162;
                                            }
                                            case "path": {
                                                path = AtsManager.getElementText(browserElement);
                                                continue block162;
                                            }
                                            case "userdatadir": {
                                                dataDir = AtsManager.getElementText(browserElement);
                                                continue block162;
                                            }
                                            case "profiledir": {
                                                dataDir = AtsManager.getElementText(browserElement);
                                                continue block162;
                                            }
                                            case "waitproperty": {
                                                check = AtsManager.getElementText(browserElement);
                                                continue block162;
                                            }
                                            case "lang": {
                                                lang = AtsManager.getElementText(browserElement);
                                                continue block162;
                                            }
                                            case "debugport": {
                                                debugPort = AtsManager.getElementText(browserElement);
                                                continue block162;
                                            }
                                            case "options": {
                                                NodeList optionsList = browserElement.getElementsByTagName("option");
                                                int optionsLen = optionsList.getLength();
                                                if (optionsLen <= 0) continue block162;
                                                options = new String[optionsLen];
                                                for (int l = 0; l < optionsLen; ++l) {
                                                    options[l] = optionsList.item(l).getTextContent();
                                                }
                                                continue block162;
                                            }
                                        }
                                    }
                                    if (name == null) continue;
                                    this.addApplicationProperties(ApplicationProperties.BROWSER_TYPE, name, driver, path, waitAction, check, lang, dataDir, title, options, debugPort);
                                }
                                continue block151;
                            }
                            case "applications": {
                                NodeList applications = type.getElementsByTagName("application");
                                for (int j = 0; j < applications.getLength(); ++j) {
                                    String name = null;
                                    String waitAction = null;
                                    Object path = null;
                                    String[] options = null;
                                    if (!(applications.item(j) instanceof Element)) continue;
                                    Element application = (Element)applications.item(j);
                                    NodeList applicationAttributes = application.getChildNodes();
                                    block165: for (int k = 0; k < applicationAttributes.getLength(); ++k) {
                                        if (!(applicationAttributes.item(k) instanceof Element)) continue;
                                        Element applicationElement = (Element)applicationAttributes.item(k);
                                        switch (applicationElement.getNodeName().toLowerCase()) {
                                            case "name": {
                                                name = AtsManager.getElementText(applicationElement);
                                                continue block165;
                                            }
                                            case "waitaction": {
                                                waitAction = AtsManager.getElementText(applicationElement);
                                                continue block165;
                                            }
                                            case "path": {
                                                path = AtsManager.getElementText(applicationElement);
                                                if (((String)path).startsWith("file:///")) continue block165;
                                                path = "file:///" + (String)path;
                                                continue block165;
                                            }
                                            case "options": {
                                                NodeList optionsList = application.getElementsByTagName("option");
                                                int optionsLen = optionsList.getLength();
                                                if (optionsLen <= 0) continue block165;
                                                options = new String[optionsLen];
                                                for (int l = 0; l < optionsLen; ++l) {
                                                    options[l] = optionsList.item(l).getTextContent();
                                                }
                                                continue block165;
                                            }
                                        }
                                    }
                                    if (name == null || path == null) continue;
                                    this.addApplicationProperties(ApplicationProperties.DESKTOP_TYPE, name, (String)path, waitAction, "", null, null, null, options);
                                }
                                continue block151;
                            }
                            case "mobiles": {
                                NodeList mobiles = type.getElementsByTagName("mobile");
                                for (int j = 0; j < mobiles.getLength(); ++j) {
                                    String name = null;
                                    String waitAction = null;
                                    String endpoint = null;
                                    String packageName = null;
                                    if (!(mobiles.item(j) instanceof Element)) continue;
                                    Element mobile = (Element)mobiles.item(j);
                                    NodeList mobileAttributes = mobile.getChildNodes();
                                    block168: for (int k = 0; k < mobileAttributes.getLength(); ++k) {
                                        if (!(mobileAttributes.item(k) instanceof Element)) continue;
                                        Element mobileElement = (Element)mobileAttributes.item(k);
                                        switch (mobileElement.getNodeName().toLowerCase()) {
                                            case "name": {
                                                name = AtsManager.getElementText(mobileElement);
                                                continue block168;
                                            }
                                            case "waitaction": {
                                                waitAction = AtsManager.getElementText(mobileElement);
                                                continue block168;
                                            }
                                            case "endpoint": {
                                                endpoint = AtsManager.getElementText(mobileElement);
                                                continue block168;
                                            }
                                            case "package": {
                                                packageName = AtsManager.getElementText(mobileElement);
                                            }
                                        }
                                    }
                                    if (name == null || endpoint == null || packageName == null) continue;
                                    this.addApplicationProperties(ApplicationProperties.MOBILE_TYPE, name, endpoint + "/" + packageName, waitAction, "", null, null, null, null);
                                }
                                continue block151;
                            }
                            case "apis": {
                                NodeList apis = type.getElementsByTagName("api");
                                for (int j = 0; j < apis.getLength(); ++j) {
                                    String name = null;
                                    String waitAction = null;
                                    if (!(apis.item(j) instanceof Element)) continue;
                                    Element api = (Element)apis.item(j);
                                    NodeList apiAttributes = api.getChildNodes();
                                    block170: for (int k = 0; k < apiAttributes.getLength(); ++k) {
                                        if (!(apiAttributes.item(k) instanceof Element)) continue;
                                        Element apiElement = (Element)apiAttributes.item(k);
                                        switch (apiElement.getNodeName().toLowerCase()) {
                                            case "name": {
                                                name = AtsManager.getElementText(apiElement);
                                                continue block170;
                                            }
                                            case "waitaction": {
                                                waitAction = AtsManager.getElementText(apiElement);
                                                continue block170;
                                            }
                                            case "url": {
                                                url = AtsManager.getElementText(apiElement);
                                            }
                                        }
                                    }
                                    if (name == null || url == null) continue;
                                    this.addApplicationProperties(ApplicationProperties.API_TYPE, name, url, waitAction, "", null, null, null, null);
                                }
                                continue block151;
                            }
                        }
                    }
                }
                catch (ParserConfigurationException e) {
                    this.error = e.getMessage();
                }
                catch (SAXException e) {
                    this.error = e.getMessage();
                }
            }
            catch (IOException e) {
                this.error = e.getMessage();
            }
        }
        return new Properties();
    }

    private void addApplicationProperties(int type, String name, String path, String wait, String check, String lang, String userDataDir, String title, String[] options) {
        this.addApplicationProperties(type, name, null, path, wait, check, lang, userDataDir, title, options, null);
    }

    private void addApplicationProperties(int type, String name, String driver, String path, String wait, String check, String lang, String userDataDir, String title, String[] options, String debugPort) {
        this.applicationsList.add(new ApplicationProperties(type, name, driver, path, Utils.string2Int(wait, -1), Utils.string2Int(check, -1), lang, userDataDir, title, options, Utils.string2Int(debugPort, -1)));
    }

    public String getError() {
        return this.error;
    }

    public ApplicationProperties getApplicationProperties(String name) {
        for (int i = 0; i < this.applicationsList.size(); ++i) {
            ApplicationProperties properties = this.applicationsList.get(i);
            if (!name.equals(properties.getName())) continue;
            return properties;
        }
        return new ApplicationProperties(name);
    }

    public int getScriptTimeOut() {
        return this.scriptTimeOut;
    }

    public int getPageloadTimeOut() {
        return this.pageloadTimeOut;
    }

    public int getWatchDogTimeOut() {
        return this.watchDogTimeOut;
    }

    public int getWebServiceTimeOut() {
        return this.webServiceTimeOut;
    }

    public TestBound getApplicationBound() {
        return new TestBound(this.applicationX, this.applicationY, this.applicationWidth, this.applicationHeight);
    }

    public String getPropertyString(String key) {
        return this.properties.getProperty(key);
    }

    public Path getDriversFolderPath() {
        return this.driversFolderPath;
    }

    public int getMaxTrySearch() {
        return this.maxTrySearch;
    }

    public int getMaxTryInteractable() {
        return this.maxTryInteractable;
    }

    public int getMaxTryImageRecognition() {
        return this.maxTryImageRecognition;
    }

    public int getMaxTryScrollSearch() {
        return this.maxTryScrollSearch;
    }

    public int getMaxTryProperty() {
        return this.maxTryProperty;
    }

    public int getMaxTryMobile() {
        return this.maxTryMobile;
    }

    public int getMaxTryWebservice() {
        return this.maxTryWebservice;
    }

    public String getNeoloadDesignApi() {
        return this.neoloadDesignApi;
    }

    public AtsProxy getNeoloadProxy() {
        if (this.neoloadProxy != null) {
            return this.neoloadProxy;
        }
        return this.getProxy();
    }

    public AtsProxy getProxy() {
        return this.proxy;
    }

    public ArrayList<String> getBlackListServers() {
        return this.blackListServers;
    }

    public OctoperfApi getOctoperf() {
        return this.octoperf;
    }

    public int getTrafficIdle() {
        return this.trafficIdle;
    }
}

