/*
 * Decompiled with CFR 0.152.
 */
package com.ats.executor.drivers.desktop;

import com.ats.element.AtsBaseElement;
import com.ats.element.AtsElement;
import com.ats.element.FoundElement;
import com.ats.executor.TestBound;
import com.ats.executor.drivers.desktop.DesktopData;
import com.ats.executor.drivers.desktop.DesktopWindow;
import com.ats.generator.variables.CalculatedProperty;
import java.beans.Transient;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class DesktopResponse {
    public ArrayList<AtsElement> elements;
    public ArrayList<DesktopWindow> windows;
    public ArrayList<DesktopData> data;
    public int errorCode = 0;
    public String errorMessage = null;
    public byte[] image;

    public DesktopResponse() {
    }

    public DesktopResponse(String error) {
        this.errorMessage = error;
        this.errorCode = -999;
    }

    @Transient
    public List<FoundElement> getFoundElements(TestBound channelDimension) {
        if (this.elements == null) {
            return Collections.emptyList();
        }
        return this.elements.stream().map(e -> new FoundElement((AtsElement)e, channelDimension)).collect(Collectors.toCollection(ArrayList::new));
    }

    @Transient
    public List<DesktopData> getData() {
        if (this.data == null) {
            return Collections.emptyList();
        }
        return this.data;
    }

    @Transient
    public List<DesktopWindow> getWindows() {
        if (this.windows == null) {
            return Collections.emptyList();
        }
        return this.windows;
    }

    @Transient
    public DesktopWindow getWindow() {
        if (this.windows != null && this.windows.size() > 0) {
            return this.windows.get(0);
        }
        return null;
    }

    @Transient
    public FoundElement getParentsElement(TestBound dimension) {
        FoundElement current = null;
        if (this.elements != null) {
            for (AtsElement obj : this.elements) {
                FoundElement elem = new FoundElement(obj, dimension);
                elem.setParent(current);
                current = elem;
            }
        }
        return current;
    }

    @Transient
    public CalculatedProperty[] getAttributes() {
        if (this.data == null) {
            return new CalculatedProperty[0];
        }
        CalculatedProperty[] result = new CalculatedProperty[this.data.size()];
        for (int i = 0; i < this.data.size(); ++i) {
            result[i] = new CalculatedProperty(this.data.get(i).getName(), this.data.get(i).getValue());
        }
        return result;
    }

    @Transient
    public List<FoundElement> getFoundElements(Predicate<AtsBaseElement> predicate, TestBound dimension) {
        if (this.elements == null) {
            return Collections.emptyList();
        }
        return this.elements.parallelStream().filter(predicate).map(e -> new FoundElement((AtsElement)e, dimension)).collect(Collectors.toCollection(ArrayList::new));
    }

    @Transient
    public String getFirstAttribute() {
        if (this.data != null && this.data.size() > 0) {
            return this.data.get(0).getValue();
        }
        return null;
    }
}

