/*
 * Decompiled with CFR 0.152.
 */
package com.ats.executor.drivers.engines;

import com.ats.driver.ApplicationProperties;
import com.ats.driver.AtsManager;
import com.ats.element.AtsBaseElement;
import com.ats.element.DialogBox;
import com.ats.element.FoundElement;
import com.ats.element.TestElement;
import com.ats.executor.ActionStatus;
import com.ats.executor.SendKeyData;
import com.ats.executor.TestBound;
import com.ats.executor.channels.Channel;
import com.ats.executor.drivers.desktop.DesktopDriver;
import com.ats.executor.drivers.engines.DriverEngine;
import com.ats.executor.drivers.engines.IDriverEngine;
import com.ats.executor.drivers.engines.webservices.ApiExecutor;
import com.ats.executor.drivers.engines.webservices.RestApiExecutor;
import com.ats.executor.drivers.engines.webservices.SoapApiExecutor;
import com.ats.generator.objects.MouseDirection;
import com.ats.generator.variables.CalculatedProperty;
import com.ats.graphic.ImageTemplateMatchingSimple;
import com.ats.script.actions.ActionApi;
import com.google.common.base.Charsets;
import com.google.common.io.CharStreams;
import java.awt.Rectangle;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.xml.parsers.ParserConfigurationException;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.Keys;
import org.openqa.selenium.Point;
import org.openqa.selenium.WebElement;
import org.xml.sax.SAXException;

public class ApiDriverEngine
extends DriverEngine
implements IDriverEngine {
    private static final String API = "API";
    private ApiExecutor executor;
    private PrintStream logStream;

    public ApiDriverEngine(Channel channel, ActionStatus status, String path, DesktopDriver desktopDriver, ApplicationProperties props) {
        super(channel, desktopDriver, props, 0, 0);
        try {
            File logsFolder = new File("target" + File.separator + "logs");
            if (!logsFolder.exists()) {
                logsFolder.mkdirs();
            }
            Path logFile = logsFolder.toPath().resolve("ws_" + System.currentTimeMillis() + ".log");
            this.logStream = new PrintStream(logFile.toFile());
            this.logStream.println("Start ATS ws channel ...");
        }
        catch (FileNotFoundException logsFolder) {
            // empty catch block
        }
        int maxTry = AtsManager.getInstance().getMaxTryWebservice();
        int timeout = AtsManager.getInstance().getWebServiceTimeOut();
        OkHttpClient.Builder builder = ApiDriverEngine.createHttpBuilder(timeout, this.logStream, channel.getTopScriptPackage(), this.getClass().getClassLoader());
        if (channel.getPerformance() == 2) {
            channel.setNeoloadDesignApi(AtsManager.getInstance().getNeoloadDesignApi());
            builder.proxy(AtsManager.getInstance().getNeoloadProxy().getHttpProxy());
        } else {
            builder.proxy(AtsManager.getInstance().getProxy().getHttpProxy());
        }
        OkHttpClient client = builder.build();
        if (this.applicationPath == null) {
            this.applicationPath = path;
        }
        Request request = new Request.Builder().url(this.applicationPath).get().build();
        String wsContent = null;
        try {
            Response response = client.newCall(request).execute();
            wsContent = CharStreams.toString((Readable)new InputStreamReader(response.body().byteStream(), Charsets.UTF_8)).trim();
            response.close();
            if (wsContent.endsWith("definitions>")) {
                try {
                    this.executor = new SoapApiExecutor(this.logStream, client, timeout, maxTry, channel, wsContent, this.applicationPath);
                    channel.setApplicationData(API, "SOAP", ((SoapApiExecutor)this.executor).getOperations());
                }
                catch (IOException | ParserConfigurationException | SAXException e) {
                    status.setError(-19, e.getMessage());
                }
            } else {
                channel.setApplicationData(API, "REST");
                this.executor = new RestApiExecutor(this.logStream, client, timeout, maxTry, channel, this.applicationPath);
            }
        }
        catch (IOException e) {
            status.setError(-19, "service is not responding -> " + e.getMessage());
            e.printStackTrace(this.logStream);
        }
    }

    @Override
    public void api(ActionStatus status, ActionApi api) {
        this.executor.execute(status, api);
    }

    @Override
    public String getSource() {
        return this.executor.getSource();
    }

    @Override
    public List<FoundElement> findElements(boolean sysComp, TestElement testObject, String tagName, String[] attributes, String[] attributesValues, Predicate<AtsBaseElement> searchPredicate, WebElement startElement) {
        return this.executor.findElements(this.channel, sysComp, testObject, tagName, attributes, searchPredicate);
    }

    @Override
    public List<FoundElement> findElements(TestElement parent, ImageTemplateMatchingSimple template) {
        return null;
    }

    @Override
    public String getAttribute(ActionStatus status, FoundElement element, String attributeName, int maxTry) {
        return this.executor.getElementAttribute(element.getId(), attributeName, maxTry);
    }

    @Override
    public CalculatedProperty[] getAttributes(FoundElement element, boolean reload) {
        return this.executor.getElementAttributes(element.getId());
    }

    @Override
    public void setSysProperty(String propertyName, String propertyValue) {
    }

    @Override
    public void refreshElementMapLocation() {
    }

    @Override
    public void setWindowToFront() {
    }

    @Override
    public void goToUrl(ActionStatus status, String url) {
    }

    @Override
    public void close(boolean keepRunning) {
        this.logStream.println("Close ATS WebService channel");
    }

    @Override
    public List<FoundElement> findSelectOptions(TestBound dimension, TestElement element) {
        return Collections.emptyList();
    }

    @Override
    public void selectOptionsItem(ActionStatus status, TestElement element, CalculatedProperty selectProperty) {
    }

    @Override
    public void loadParents(FoundElement hoverElement) {
    }

    @Override
    public WebElement getRootElement(Channel cnl) {
        return null;
    }

    @Override
    public void waitAfterAction(ActionStatus status) {
    }

    @Override
    public void updateDimensions() {
    }

    @Override
    public FoundElement getElementFromPoint(Boolean syscomp, Double x, Double y) {
        return null;
    }

    @Override
    public FoundElement getElementFromRect(Boolean syscomp, Double x, Double y, Double w, Double h) {
        return null;
    }

    @Override
    public void switchWindow(ActionStatus status, int index, int tries) {
    }

    @Override
    public void closeWindow(ActionStatus status) {
    }

    @Override
    public Object executeScript(ActionStatus status, String script, Object ... params) {
        return null;
    }

    @Override
    public void scroll(FoundElement element) {
    }

    @Override
    public void scroll(int value) {
    }

    @Override
    public void scroll(FoundElement element, int delta) {
    }

    @Override
    public void middleClick(ActionStatus status, MouseDirection position, TestElement element) {
    }

    @Override
    public void mouseMoveToElement(ActionStatus status, FoundElement foundElement, MouseDirection position, boolean desktopDragDrop, int offsetX, int offsetY) {
    }

    @Override
    public void sendTextData(ActionStatus status, TestElement element, ArrayList<SendKeyData> textActionList) {
    }

    @Override
    public void clearText(ActionStatus status, TestElement testElement, MouseDirection md) {
    }

    @Override
    public void mouseClick(ActionStatus status, FoundElement element, MouseDirection position, int offsetX, int offsetY) {
    }

    @Override
    public void drag(ActionStatus status, FoundElement element, MouseDirection position, int offsetX, int offsetY) {
    }

    @Override
    public void keyDown(Keys key) {
    }

    @Override
    public void keyUp(Keys key) {
    }

    @Override
    public void drop(MouseDirection md, boolean desktopDriver) {
    }

    @Override
    public void moveByOffset(int hDirection, int vDirection) {
    }

    @Override
    public void doubleClick() {
    }

    @Override
    public void rightClick() {
    }

    @Override
    public DialogBox switchToAlert() {
        return null;
    }

    @Override
    public boolean switchToDefaultContent() {
        return true;
    }

    @Override
    public void switchToFrameId(String id) {
    }

    @Override
    public void buttonClick(ActionStatus status, String id) {
    }

    @Override
    public void tap(int count, FoundElement element) {
    }

    @Override
    public void press(int duration, ArrayList<String> paths, FoundElement element) {
    }

    @Override
    public void windowState(ActionStatus status, Channel channel, String state) {
    }

    @Override
    public Object executeJavaScript(ActionStatus status, String script, TestElement element) {
        return null;
    }

    @Override
    public Object executeJavaScript(ActionStatus status, String script, boolean returnValue) {
        return null;
    }

    @Override
    public String getTitle() {
        return "";
    }

    private static OkHttpClient.Builder createHttpBuilder(int timeout, PrintStream logStream, String packageName, ClassLoader classLoader) {
        File[] pfxFiles;
        URL certsFolderUrl;
        Path certsFolderPath = Paths.get("", new String[0]).toAbsolutePath().resolve("src").resolve("assets").resolve("certs");
        File certsFolder = certsFolderPath.toFile();
        if (!certsFolder.exists() && (certsFolderUrl = classLoader.getResource("assets/certs")) != null) {
            certsFolder = new File(certsFolderUrl.getPath());
        }
        File pfxFile = null;
        if (certsFolder.exists() && (pfxFiles = certsFolder.listFiles((dir, name) -> name.toLowerCase().endsWith(".pfx"))).length > 0) {
            pfxFile = pfxFiles[0];
            logStream.println("Using pfx file -> " + pfxFile.getAbsolutePath());
        }
        OkHttpClient.Builder builder = new OkHttpClient.Builder().connectTimeout((long)timeout, TimeUnit.SECONDS).writeTimeout((long)timeout, TimeUnit.SECONDS).readTimeout((long)timeout, TimeUnit.SECONDS).cache(null).followRedirects(true).followSslRedirects(true);
        TrustManager[] trustManager = ApiDriverEngine.getTrustManager();
        try {
            SSLSocketFactory sslSocketFactory = ApiDriverEngine.getSslSocketFactory(pfxFile, trustManager, logStream);
            builder.sslSocketFactory(sslSocketFactory, (X509TrustManager)trustManager[0]);
            builder.hostnameVerifier(new HostnameVerifier(){

                @Override
                public boolean verify(String hostname, SSLSession session) {
                    return true;
                }
            });
        }
        catch (IOException | KeyManagementException | NoSuchAlgorithmException | CertificateException e) {
            e.printStackTrace(logStream);
        }
        return builder;
    }

    private static SSLSocketFactory getSslSocketFactory(File pfxFile, TrustManager[] trustManager, PrintStream errorStream) throws KeyManagementException, NoSuchAlgorithmException, CertificateException, IOException {
        SSLContext sslContext = SSLContext.getInstance("SSL");
        KeyManager[] keyManager = null;
        if (pfxFile != null && pfxFile.exists()) {
            String password = "";
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance("SunX509");
            try {
                KeyStore keyStore = KeyStore.getInstance("PKCS12");
                FileInputStream keyInput = new FileInputStream(pfxFile);
                keyStore.load(keyInput, "".toCharArray());
                ((InputStream)keyInput).close();
                keyManagerFactory.init(keyStore, "".toCharArray());
                keyManager = keyManagerFactory.getKeyManagers();
            }
            catch (KeyStoreException | UnrecoverableKeyException e) {
                e.printStackTrace(errorStream);
            }
        } else {
            errorStream.println("No pfx files found in the project");
        }
        sslContext.init(keyManager, trustManager, new SecureRandom());
        return sslContext.getSocketFactory();
    }

    private static TrustManager[] getTrustManager() {
        X509TrustManager manager = new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }
        };
        return new TrustManager[]{manager};
    }

    @Override
    protected void setPosition(Point pt) {
    }

    @Override
    protected void setSize(Dimension dim) {
    }

    @Override
    public List<String[]> loadSelectOptions(TestElement element) {
        return Collections.emptyList();
    }

    @Override
    public int getNumWindows() {
        return 0;
    }

    @Override
    public String getUrl() {
        return this.executor.getCurrentUrl();
    }

    @Override
    public Rectangle getBoundRect(TestElement testElement) {
        return null;
    }

    @Override
    public void mouseMoveToElement(FoundElement element) {
    }
}

