/*
 * Decompiled with CFR 0.152.
 */
package com.ats.executor.drivers.engines.browsers;

import com.ats.driver.ApplicationProperties;
import com.ats.executor.ActionStatus;
import com.ats.executor.channels.Channel;
import com.ats.executor.drivers.DriverProcess;
import com.ats.executor.drivers.desktop.DesktopDriver;
import com.ats.executor.drivers.engines.WebDriverEngine;
import com.ats.executor.drivers.engines.browsers.BrowserArgumentsParser;
import com.ats.generator.variables.CalculatedValue;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.FileWriter;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import org.openqa.selenium.chrome.ChromeOptions;

public class ChromiumBasedDriverEngine
extends WebDriverEngine {
    public ChromiumBasedDriverEngine(Channel channel, ActionStatus status, String browser, DriverProcess driverProcess, DesktopDriver desktopDriver, ApplicationProperties props) {
        super(channel, browser, driverProcess, desktopDriver, props);
    }

    protected ChromeOptions initOptions(ApplicationProperties props, String browserName, ArrayList<CalculatedValue> arguments) {
        this.browserArguments = new BrowserArgumentsParser(this.channel.getArguments(), props, browserName, this.applicationPath);
        ChromeOptions options = new ChromeOptions();
        if (this.browserArguments.getMoreOptions().length > 0) {
            for (String s : this.browserArguments.getMoreOptions()) {
                options.addArguments(new String[]{s});
            }
        } else {
            options.addArguments(new String[]{"--no-default-browser-check"});
            options.addArguments(new String[]{"--test-type"});
            options.addArguments(new String[]{"--allow-file-access-from-files"});
            options.addArguments(new String[]{"--allow-running-insecure-content"});
            options.addArguments(new String[]{"--allow-file-access-from-files"});
            options.addArguments(new String[]{"--allow-cross-origin-auth-prompt"});
            options.addArguments(new String[]{"--allow-file-access"});
            options.addArguments(new String[]{"--ignore-certificate-errors"});
        }
        options.setHeadless(this.browserArguments.isHeadless());
        if (this.browserArguments.isIncognito()) {
            options.addArguments(new String[]{"--incognito"});
        }
        if (props.getDebugPort() > 0) {
            options.addArguments(new String[]{"--remote-debugging-port=" + props.getDebugPort()});
        }
        if (this.browserArguments.getUserDataPath() != null) {
            this.removeMetricsData(this.browserArguments.getUserDataPath());
            options.addArguments(new String[]{"--user-data-dir=" + this.browserArguments.getUserDataPath()});
        }
        if (this.lang != null) {
            options.addArguments(new String[]{"--lang=" + this.lang});
        }
        if (this.browserArguments.getBinaryPath() != null) {
            options.setBinary(this.browserArguments.getBinaryPath());
        }
        options.setExperimentalOption("excludeSwitches", Collections.singletonList("enable-automation"));
        HashMap<String, Boolean> prefs = new HashMap<String, Boolean>();
        prefs.put("credentials_enable_service", false);
        prefs.put("profile.password_manager_enabled", false);
        options.setExperimentalOption("prefs", prefs);
        return options;
    }

    private void removeMetricsData(String profileFolder) {
        Path atsProfilePath = Paths.get(profileFolder, new String[0]);
        if (atsProfilePath.toFile().exists()) {
            Path preferencesPath;
            Path localStatePath = atsProfilePath.resolve("Local State");
            if (localStatePath.toFile().exists()) {
                try {
                    JsonObject stability;
                    JsonObject localStateObject = JsonParser.parseString((String)new String(Files.readAllBytes(localStatePath))).getAsJsonObject();
                    JsonObject metrics = localStateObject.get("user_experience_metrics").getAsJsonObject();
                    if (metrics != null && (stability = metrics.get("stability").getAsJsonObject()) != null && !stability.get("exited_cleanly").getAsBoolean()) {
                        stability.remove("exited_cleanly");
                        stability.addProperty("exited_cleanly", Boolean.valueOf(true));
                        metrics.remove("stability");
                        metrics.add("stability", (JsonElement)stability);
                        localStateObject.remove("user_experience_metrics");
                        localStateObject.add("user_experience_metrics", (JsonElement)metrics);
                        FileWriter fileWriter = new FileWriter(localStatePath.toFile());
                        new Gson().toJson((JsonElement)localStateObject, (Appendable)fileWriter);
                        fileWriter.close();
                    }
                }
                catch (Exception localStateObject) {
                    // empty catch block
                }
            }
            if ((preferencesPath = atsProfilePath.resolve("Default").resolve("Preferences")).toFile().exists()) {
                try {
                    JsonObject PreferencesObject = JsonParser.parseString((String)new String(Files.readAllBytes(preferencesPath))).getAsJsonObject();
                    JsonObject profile = PreferencesObject.get("profile").getAsJsonObject();
                    if (profile != null) {
                        JsonElement exitType = profile.get("exit_type");
                        if (exitType != null) {
                            profile.remove("exit_type");
                        }
                        profile.addProperty("exit_type", "Normal");
                        PreferencesObject.remove("profile");
                        PreferencesObject.add("profile", (JsonElement)profile);
                        FileWriter fileWriter = new FileWriter(preferencesPath.toFile());
                        new Gson().toJson((JsonElement)PreferencesObject, (Appendable)fileWriter);
                        fileWriter.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }
}

