/*
 * Decompiled with CFR 0.152.
 */
package com.ats.executor.drivers.engines.browsers;

import com.ats.driver.ApplicationProperties;
import com.ats.element.TestElement;
import com.ats.executor.ActionStatus;
import com.ats.executor.SendKeyData;
import com.ats.executor.channels.Channel;
import com.ats.executor.drivers.DriverProcess;
import com.ats.executor.drivers.desktop.DesktopDriver;
import com.ats.executor.drivers.engines.WebDriverEngine;
import com.ats.generator.objects.MouseDirection;
import java.util.ArrayList;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.MutableCapabilities;
import org.openqa.selenium.Point;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.edge.EdgeOptions;

public class EdgeDriverEngine
extends WebDriverEngine {
    private static final String JS_WAIT_READYSTATE = "var interval=setInterval(function(){if(window.document.readyState==='complete'){clearInterval(interval);done();}},200)};";

    public EdgeDriverEngine(Channel channel, ActionStatus status, DriverProcess driverProcess, DesktopDriver windowsDriver, ApplicationProperties props) {
        super(channel, "edge", driverProcess, windowsDriver, props);
        this.searchElementScript = JS_WAIT_READYSTATE + JS_SEARCH_ELEMENT;
        EdgeOptions options = new EdgeOptions();
        options.setCapability("acceptSslCerts", true);
        options.setCapability("acceptInsecureCerts", true);
        this.launchDriver(status, (MutableCapabilities)options);
    }

    @Override
    protected void setPosition(Point pt) {
        this.actionWait();
        super.setPosition(pt);
        this.actionWait();
    }

    @Override
    protected void setSize(Dimension dim) {
        this.actionWait();
        super.setSize(dim);
        this.actionWait();
    }

    @Override
    public void closeWindow(ActionStatus status) {
        this.actionWait();
        super.closeWindow(status);
        this.actionWait();
    }

    @Override
    public void middleClick(ActionStatus status, MouseDirection position, TestElement element) {
        this.middleClickSimulation(status, position, element);
    }

    @Override
    protected boolean switchToWindowHandle(String handle) {
        this.actionWait();
        if (super.switchToWindowHandle(handle)) {
            this.actionWait();
            return true;
        }
        return false;
    }

    @Override
    protected void switchToFrame(WebElement we) {
        this.actionWait();
        super.switchToFrame(we);
        this.actionWait();
    }

    @Override
    public void sendTextData(ActionStatus status, TestElement element, ArrayList<SendKeyData> textActionList) {
        boolean enterKey = false;
        for (SendKeyData sequence : textActionList) {
            element.getWebElement().sendKeys(new CharSequence[]{sequence.getSequenceWeb(true)});
            if (!sequence.isEnterKey()) continue;
            enterKey = true;
        }
        if (enterKey) {
            this.actionWait();
        }
    }

    @Override
    public void goToUrl(ActionStatus status, String url) {
        super.goToUrl(status, url);
        this.waitAfterAction(status);
    }
}

