/*
 * Decompiled with CFR 0.152.
 */
package com.ats.executor.drivers.engines.browsers;

import com.ats.driver.ApplicationProperties;
import com.ats.executor.ActionStatus;
import com.ats.executor.channels.Channel;
import com.ats.executor.drivers.DriverManager;
import com.ats.executor.drivers.desktop.DesktopDriver;
import com.ats.executor.drivers.desktop.DesktopWindow;
import com.ats.executor.drivers.engines.DesktopDriverEngine;
import com.ats.executor.drivers.engines.WebDriverEngine;
import com.ats.executor.drivers.engines.browsers.BrowserArgumentsParser;
import com.ats.tools.Utils;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.Point;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.chrome.ChromeOptions;
import org.openqa.selenium.interactions.Actions;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.remote.RemoteWebDriver;

public class JxDriverEngine
extends WebDriverEngine {
    private static final int DEFAULT_WAIT = 150;
    private static final int DEFAULT_PROPERTY_WAIT = 200;
    private static final String JX_WINDOW_SIZE = "var result=[window.screenX+7.0001, window.screenY+8.0001, window.innerWidth+0.0001, window.innerHeight+0.0001];";
    private ProcessHandle jxProcess;

    public JxDriverEngine(DriverManager driverManager, Path driversPath, String driverName, Channel channel, ActionStatus status, DesktopDriver desktopDriver, ApplicationProperties props) {
        super(channel, desktopDriver, props.getUri(), props, 150, 200);
        this.browserArguments = new BrowserArgumentsParser(channel.getArguments(), props, "jx", this.applicationPath);
        ProcessBuilder builder = new ProcessBuilder(this.getApplicationPath());
        try {
            builder.start();
            status.setPassed(true);
        }
        catch (IOException e1) {
            status.setException(-19, e1);
        }
        this.setDriverProcess(driverManager.getDriverProcess(status, "jx", driverName, null, null));
        if (status.isPassed()) {
            try {
                DesiredCapabilities capabilities = new DesiredCapabilities();
                ChromeOptions options = new ChromeOptions();
                options.setExperimentalOption("debuggerAddress", (Object)"localhost:9222");
                capabilities.setCapability("goog:chromeOptions", (Object)options);
                this.driver = new RemoteWebDriver(this.getDriverProcess().getDriverServerUrl(), (Capabilities)capabilities);
            }
            catch (Exception e) {
                this.close(false);
                status.setError(-19, e.getMessage());
            }
            if (this.driver != null) {
                status.setPassed(true);
                this.actions = new Actions((WebDriver)this.driver);
                this.driver.manage().timeouts().setScriptTimeout(50L, TimeUnit.SECONDS);
                this.driver.manage().timeouts().pageLoadTimeout(60L, TimeUnit.SECONDS);
                String applicationVersion = "N/A";
                String driverVersion = "N/A";
                Map infos = this.driver.getCapabilities().asMap();
                for (Map.Entry entry : infos.entrySet()) {
                    Map chromeData;
                    if ("browserVersion".equals(entry.getKey()) || "version".equals(entry.getKey())) {
                        applicationVersion = entry.getValue().toString();
                        continue;
                    }
                    if (!"chrome".equals(entry.getKey()) || (driverVersion = (String)(chromeData = (Map)entry.getValue()).get("chromedriverVersion")) == null) continue;
                    driverVersion = driverVersion.replaceFirst("\\(.*\\)", "").trim();
                }
                String titleUid = UUID.randomUUID().toString();
                String atsStartPageUri = null;
                try {
                    File tempHtml = File.createTempFile("ats_", ".html");
                    tempHtml.deleteOnExit();
                    Files.write(tempHtml.toPath(), Utils.getAtsBrowserContent(titleUid, channel.getApplication(), this.applicationPath, applicationVersion, driverVersion, channel.getDimension(), this.getActionWait(), this.getPropertyWait(), 20, 20, 20, 20, 20, this.getDesktopDriver(), null), new OpenOption[0]);
                    atsStartPageUri = tempHtml.toURI().toString();
                }
                catch (IOException tempHtml) {
                    // empty catch block
                }
                DesktopWindow window = this.getJxBrowserWindow(atsStartPageUri, props.getTitle());
                if (window != null) {
                    for (int maxTry = 10; maxTry > 0; --maxTry) {
                        Optional<ProcessHandle> opt = ProcessHandle.allProcesses().filter(p -> p.pid() == (long)window.getPid()).findFirst();
                        if (!opt.isPresent()) continue;
                        maxTry = 0;
                        this.jxProcess = opt.get();
                        desktopDriver.setEngine(new DesktopDriverEngine(channel, window));
                        channel.setApplicationData("windows", applicationVersion, driverVersion, window.getPid(), (long)window.getHandle());
                        this.setSize(channel.getDimension().getSize());
                        this.setPosition(channel.getDimension().getPoint());
                        return;
                    }
                    status.setError(-19, "unable to find JxBrowser running process");
                } else {
                    status.setError(-19, "unable to find JxBrowser main window");
                }
            }
        }
    }

    private DesktopWindow getJxBrowserWindow(String atsStartPage, String title) {
        for (int maxTry = 10; maxTry > 0; --maxTry) {
            this.driver.get(atsStartPage);
            DesktopWindow window = this.desktopDriver.getWindowByTitle("jx", title);
            if (window != null && window.getPid() > 0) {
                return window;
            }
            this.channel.sleep(300);
        }
        return null;
    }

    @Override
    protected void setPosition(Point pt) {
        this.getDesktopDriver().moveWindow(this.channel, pt);
    }

    @Override
    protected void setSize(Dimension size) {
        this.getDesktopDriver().resizeWindow(this.channel, size);
    }

    @Override
    public void updateDimensions() {
        DesktopWindow win = this.getDesktopDriver().getWindowByHandle(this.channel.getHandle(this.desktopDriver));
        Double channelX = win.getX();
        Double channelY = win.getY();
        this.channel.getDimension().update(channelX, channelY, win.getWidth(), win.getHeight());
        ArrayList response = (ArrayList)this.runJavaScript(JX_WINDOW_SIZE, new Object[0]);
        this.channel.getSubDimension().update((Double)response.get(0) - channelX, (Double)response.get(1) - channelY, (Double)response.get(2), (Double)response.get(3));
    }

    @Override
    public void close(boolean keepRunning) {
        try {
            this.jxProcess.destroyForcibly();
            this.driver.close();
            this.getDriverProcess().close(keepRunning);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

