/*
 * Decompiled with CFR 0.152.
 */
package com.ats.executor.drivers.engines.browsers.capabilities;

import com.ats.executor.drivers.engines.browsers.BrowserArgumentsParser;
import com.google.common.collect.ImmutableList;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.openqa.selenium.MutableCapabilities;

public class MsEdgeOptions
extends MutableCapabilities {
    private static final String CAPABILITY = "ms:edgeOptions";
    private String binary;
    private List<String> args = new ArrayList<String>();
    private Map<String, Object> experimentalOptions = new HashMap<String, Object>();

    public MsEdgeOptions(BrowserArgumentsParser browserArgs) {
        HashMap<String, Serializable> prefs = new HashMap<String, Serializable>();
        prefs.put("credentials_enable_service", Boolean.valueOf(false));
        HashMap<String, Boolean> profile = new HashMap<String, Boolean>();
        profile.put("password_manager_enabled", false);
        prefs.put("profile", profile);
        this.experimentalOptions.put("excludeSwitches", Collections.singletonList("enable-automation"));
        this.experimentalOptions.put("useAutomationExtension", false);
        this.experimentalOptions.put("prefs", prefs);
        this.args.add("--enable-automation");
        this.binary = browserArgs.getBinaryPath();
        if (browserArgs.isHeadless()) {
            this.args.add("--headless");
        }
        if (browserArgs.isIncognito()) {
            this.args.add("--inprivate");
        }
        if (browserArgs.getUserDataPath() != null) {
            this.args.add("user-data-dir=" + browserArgs.getUserDataPath());
        }
        for (String opt : browserArgs.getMoreOptions()) {
            this.args.add(opt);
        }
    }

    public Map<String, Object> asMap() {
        TreeMap toReturn = new TreeMap(super.asMap());
        TreeMap<String, Object> options = new TreeMap<String, Object>();
        this.experimentalOptions.forEach(options::put);
        if (this.binary != null) {
            options.put("binary", this.binary);
        }
        options.put("args", ImmutableList.copyOf(this.args));
        options.put("extensions", Collections.EMPTY_LIST);
        toReturn.put(CAPABILITY, options);
        return Collections.unmodifiableMap(toReturn);
    }
}

