/*
 * Decompiled with CFR 0.152.
 */
package com.ats.executor.drivers.engines.desktop;

import com.ats.element.DialogBox;
import com.ats.element.FoundElement;
import com.ats.executor.ActionStatus;
import com.ats.executor.TestBound;
import com.ats.executor.drivers.engines.DesktopDriverEngine;
import com.ats.generator.objects.MouseDirection;
import com.ats.generator.variables.CalculatedProperty;
import java.util.List;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import org.openqa.selenium.NoAlertPresentException;

public class DesktopAlert
extends DialogBox {
    private FoundElement dialog;
    private DesktopDriverEngine engine;

    public DesktopAlert(DesktopDriverEngine engine, TestBound dimension) {
        super(engine, dimension);
        this.waitBox = 200;
        List<FoundElement> elements = engine.getDesktopDriver().getDialogBox(dimension);
        if (elements.size() <= 0) {
            throw new NoAlertPresentException();
        }
        this.dialog = elements.get(0);
        this.engine = engine;
    }

    @Override
    public void dismiss(ActionStatus status) {
        if (this.dialog != null) {
            FoundElement closebutton = null;
            List buttons = this.dialog.getChildren().stream().filter(p -> p.getTag().equals("Button")).collect(Collectors.toList());
            if (buttons.size() > 1) {
                closebutton = (FoundElement)buttons.get(1);
            } else {
                FoundElement close;
                List title = this.dialog.getChildren().stream().filter(p -> p.getTag().equals("TitleBar")).collect(Collectors.toList());
                if (title.size() > 0 && "Button".equals((close = ((FoundElement)title.get(0)).getChildren().get(0)).getTag())) {
                    closebutton = close;
                }
            }
            if (closebutton != null) {
                this.engine.mouseMoveToElement(status, closebutton, new MouseDirection(), false, 0, 0);
                this.engine.getDesktopDriver().mouseClick();
            }
        }
    }

    @Override
    public void accept(ActionStatus status) {
        List buttons;
        if (this.dialog != null && (buttons = this.dialog.getChildren().stream().filter(p -> p.getTag().equals("Button")).collect(Collectors.toList())).size() > 0) {
            this.engine.mouseMoveToElement(status, (FoundElement)buttons.get(0), new MouseDirection(), false, 0, 0);
            this.engine.getDesktopDriver().mouseClick();
        }
    }

    @Override
    public void defaultButton(ActionStatus status) {
        if (this.dialog != null) {
            this.engine.mouseMoveToElement(status, this.dialog, new MouseDirection(), false, 0, 0);
        }
    }

    @Override
    public String getText() {
        List<FoundElement> labels;
        if (this.dialog != null && (labels = this.dialog.getChildren().stream().filter(p -> p.getTag().equals("Text")).collect(Collectors.toList())).size() > 0) {
            StringJoiner joiner = new StringJoiner("\n");
            labels.forEach(l -> joiner.add(this.engine.getAttribute(null, (FoundElement)l, "Name", 1)));
            return joiner.toString();
        }
        return "";
    }

    @Override
    public void sendKeys(String text) {
        List edits;
        if (this.dialog != null && (edits = this.dialog.getChildren().stream().filter(p -> p.getTag().equals("Edit")).collect(Collectors.toList())).size() > 0) {
            this.engine.getDesktopDriver().executeScript(null, "SetValue(" + text + ")", (FoundElement)edits.get(0));
        }
    }

    @Override
    public String getTitle() {
        List title;
        if (this.dialog != null && (title = this.dialog.getChildren().stream().filter(p -> p.getTag().equals("TitleBar")).collect(Collectors.toList())).size() > 0) {
            return this.engine.getAttribute(null, (FoundElement)title.get(0), "Value", 1);
        }
        return "";
    }

    @Override
    public CalculatedProperty[] getAttributes() {
        return new CalculatedProperty[]{new CalculatedProperty("text", this.getText()), new CalculatedProperty("title", this.getTitle())};
    }
}

