/*
 * Decompiled with CFR 0.152.
 */
package com.ats.generator;

import java.io.File;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Properties;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class ATS {
    public static String VERSION = ATS.getAtsVersion();
    private String[] args = null;
    private Options options = new Options();
    private File projectFolder = null;
    private File destinationFolder = null;
    private File reportFolder = null;
    private File outputFolder = null;
    private String[] suites = null;
    private boolean compile = false;

    public static void logError(String msg) {
        ATS.print("ERROR", msg);
    }

    public static void logInfo(String msg) {
        ATS.print("INFO", msg);
    }

    public static void logWarn(String msg) {
        ATS.print("WARN", msg);
    }

    private static void print(String type, String msg) {
        System.out.println("[" + type + "] " + msg);
    }

    private static String getAtsVersion() {
        InputStream resourceAsStream = ATS.class.getResourceAsStream("/version.properties");
        Properties prop = new Properties();
        try {
            prop.load(resourceAsStream);
            return prop.getProperty("version");
        }
        catch (Exception exception) {
            return "";
        }
    }

    public ATS(String[] args) {
        this.args = args;
        this.options.addOption("h", "help", false, "Show help");
        this.options.addOption("f", "force", false, "Force Java files generation if files or folder exists");
        this.options.addOption("comp", "compile", false, "Compile generated java files");
        this.options.addOption("prj", "project", true, "ATS project folder");
        this.options.addOption("dest", "destination", true, "Generated Java files destination folder");
        this.options.addOption("rep", "report", true, "Execution report Java files destination folder");
        this.options.addOption("suites", "suiteXmlFiles", true, "Execution suites to launch");
    }

    public void parse() {
        DefaultParser parser = new DefaultParser();
        CommandLine cmd = null;
        try {
            cmd = parser.parse(this.options, this.args);
        }
        catch (ParseException e) {
            ATS.logError("Cannot parse command line : " + e.getMessage());
        }
        if (cmd.hasOption("h")) {
            this.help();
        } else {
            File file;
            boolean force = cmd.hasOption("f");
            this.compile = cmd.hasOption("comp");
            if (cmd.hasOption("suites")) {
                this.suites = cmd.getOptionValue("suites").split(",");
            }
            String prjFolder = ".";
            if (cmd.hasOption("prj")) {
                prjFolder = cmd.getOptionValue("prj");
            }
            if ((file = new File(prjFolder)).exists()) {
                this.projectFolder = new File(file.getAbsolutePath());
            } else {
                Path projectPath = Paths.get(prjFolder, new String[0]);
                this.projectFolder = projectPath.toFile();
            }
            if (this.projectFolder.exists()) {
                ATS.logInfo("Using ATS project folder -> " + this.projectFolder.getAbsolutePath());
            } else {
                ATS.logError("Project folder does not exists -> " + this.projectFolder.getAbsolutePath());
            }
            if (cmd.hasOption("dest")) {
                this.destinationFolder = new File(cmd.getOptionValue("dest"));
                if (this.destinationFolder.exists()) {
                    if (force) {
                        ATS.logWarn("Destination folder exists ! (java files will be deleted)");
                    } else {
                        ATS.logError("Destination folder exists, please delete folder or use '-force' option");
                    }
                }
                ATS.logInfo("Using destination folder -> " + this.destinationFolder.getAbsolutePath());
            }
            if (cmd.hasOption("rep")) {
                this.reportFolder = new File(cmd.getOptionValue("rep"));
                if (this.reportFolder.exists()) {
                    if (force) {
                        ATS.logWarn("Execution report folder found, it will be deleted");
                    } else {
                        ATS.logError("Execution report folder exists, please delete folder or use '-force' option");
                    }
                }
                ATS.logInfo("Using report folder : " + this.reportFolder.getAbsolutePath());
            }
        }
    }

    private void help() {
        HelpFormatter formater = new HelpFormatter();
        formater.printHelp("ATS Java Code Generator", this.options);
    }

    public boolean isCompile() {
        return this.compile;
    }

    public File getProjectFolder() {
        return this.projectFolder;
    }

    public File getDestinationFolder() {
        return this.destinationFolder;
    }

    public File getReportFolder() {
        return this.reportFolder;
    }

    public File getOutputFolder() {
        return this.outputFolder;
    }

    public String[] getSuites() {
        return this.suites;
    }
}

