/*
 * Decompiled with CFR 0.152.
 */
package com.ats.generator.variables;

import com.ats.executor.ActionTestScript;
import com.ats.generator.variables.CalculatedValue;
import com.ats.generator.variables.transform.Transformer;
import com.ats.script.Script;
import java.util.ArrayList;

public class Variable
implements Comparable<Variable> {
    public static final String SCRIPT_LABEL = "var";
    public static final int SCRIPT_LABEL_LENGTH = "var".length();
    private boolean calculation = true;
    private String name = "";
    private CalculatedValue value;
    private Transformer transformation;
    private String data = null;

    public Variable() {
    }

    public Variable(String name, CalculatedValue value) {
        this.setName(name);
        this.setValue(value);
    }

    public Variable(ActionTestScript script, String variablePath) {
        this.setName(this.name);
        this.setValue(new CalculatedValue((Script)script, ""));
    }

    public Variable(String name, CalculatedValue value, Transformer transformer) {
        this.setName(name);
        this.setValue(value);
        this.setTransformation(transformer);
    }

    public String toString() {
        return this.getCalculatedValue();
    }

    public String getCalculatedValue() {
        String result = this.data;
        if (result == null) {
            result = this.value.getCalculated();
        }
        if (this.transformation != null) {
            result = this.transformation.format(result);
        }
        return result;
    }

    public void setData(String value) {
        this.data = value;
    }

    public ArrayList<String> getKeywords() {
        ArrayList<String> keywords = new ArrayList<String>();
        keywords.add(this.name);
        keywords.add(this.value.getKeywords());
        return keywords;
    }

    @Override
    public int compareTo(Variable variable) {
        return Boolean.valueOf(this.isCalculation()).compareTo(variable.isCalculation());
    }

    public boolean equals(CalculatedValue clv) {
        return clv.getCalculated().equals(this.getCalculatedValue());
    }

    public String getJavaCode() {
        String varName = this.getName();
        StringBuilder codeBuilder = new StringBuilder(this.getClass().getSimpleName());
        codeBuilder.append(" ");
        codeBuilder.append(varName);
        codeBuilder.append(" = ");
        codeBuilder.append(SCRIPT_LABEL);
        codeBuilder.append("(\"");
        codeBuilder.append(varName);
        codeBuilder.append("\"");
        if (this.isCalculation()) {
            codeBuilder.append(", ");
            codeBuilder.append(this.value.getJavaCode());
        }
        if (this.transformation != null) {
            codeBuilder.append(", ");
            codeBuilder.append(this.transformation.getJavaCode());
        }
        codeBuilder.append(")");
        return codeBuilder.toString();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String value) {
        this.name = value;
    }

    public CalculatedValue getValue() {
        return this.value;
    }

    public void setValue(CalculatedValue value) {
        this.value = value;
    }

    public Transformer getTransformation() {
        return this.transformation;
    }

    public void setTransformation(Transformer value) {
        this.transformation = value;
    }

    public boolean isCalculation() {
        return this.calculation;
    }

    public void setCalculation(boolean value) {
        this.calculation = value;
    }
}

