/*
 * Decompiled with CFR 0.152.
 */
package com.ats.generator.variables.parameter;

import com.ats.generator.variables.parameter.Parameter;
import com.ats.generator.variables.parameter.ParameterList;
import com.google.common.io.CharStreams;
import com.google.common.io.Closeables;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import com.opencsv.CSVReader;
import com.opencsv.exceptions.CsvException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;

public class ParameterDataFile {
    public static final String CSV_TYPE = "csv";
    public static final String JSON_TYPE = "json";
    public static final String JSON_SIMPLE_TYPE = "jsonSimple";
    public static final String JSON_COMPLEX_TYPE = "jsonComplex";
    private String dataType = "csv";
    private ArrayList<ParameterList> data = new ArrayList();
    private String error = "";
    private boolean editable = true;
    private int maxCols = 0;

    public ParameterDataFile() {
    }

    public ParameterDataFile(URL url) {
        this.editable = !url.getProtocol().startsWith("http");
        String content = null;
        try {
            InputStreamReader stream = new InputStreamReader(url.openStream(), StandardCharsets.UTF_8);
            content = CharStreams.toString((Readable)stream);
            Closeables.closeQuietly((Reader)stream);
        }
        catch (IOException e1) {
            this.error = e1.getMessage();
            return;
        }
        if (url.getPath().endsWith(".csv")) {
            this.readCsvData(content);
        } else {
            JsonElement jsonElement = ParameterDataFile.getJsonElement(content);
            if (jsonElement != null) {
                if (jsonElement.isJsonArray()) {
                    this.dataType = JSON_COMPLEX_TYPE;
                    JsonArray jsonArray = jsonElement.getAsJsonArray();
                    int iteration = 0;
                    for (JsonElement line : jsonArray) {
                        if (line.isJsonObject()) {
                            ParameterList newLine = new ParameterList(iteration);
                            AtomicInteger colIndex = new AtomicInteger(0);
                            line.getAsJsonObject().entrySet().forEach(e -> newLine.addParameter(new Parameter(colIndex.getAndIncrement(), (String)e.getKey(), ((JsonElement)e.getValue()).getAsString())));
                            this.data.add(newLine);
                        }
                        ++iteration;
                    }
                } else if (jsonElement.isJsonObject()) {
                    this.dataType = JSON_TYPE;
                    JsonObject jsonObject = jsonElement.getAsJsonObject();
                    if (jsonObject.has("paramNames") && jsonObject.has("paramValues") && jsonObject.size() == 2) {
                        try {
                            JsonArray paramNames = jsonObject.get("paramNames").getAsJsonArray();
                            JsonArray paramValues = jsonObject.get("paramValues").getAsJsonArray();
                            if (paramNames.size() == paramValues.size()) {
                                for (int i = 0; i < paramValues.size(); ++i) {
                                    JsonArray iterations = paramValues.get(i).getAsJsonArray();
                                    for (int j = 0; j < iterations.size(); ++j) {
                                        String paramName = "";
                                        if (i < paramNames.size()) {
                                            paramName = paramNames.get(i).getAsString();
                                        }
                                        if (this.data.size() < j + 1) {
                                            this.data.add(new ParameterList(j));
                                        }
                                        ParameterList row = this.data.get(j);
                                        row.addParameter(new Parameter(j, paramName, iterations.get(j).getAsString()));
                                    }
                                }
                                return;
                            }
                        }
                        catch (IllegalStateException illegalStateException) {
                            // empty catch block
                        }
                    }
                    this.dataType = JSON_SIMPLE_TYPE;
                    this.parseJsonObject(jsonObject);
                }
            } else {
                this.readCsvData(content);
            }
        }
    }

    private void readCsvData(String content) {
        CSVReader reader = new CSVReader((Reader)new StringReader(content));
        try {
            List csvList = reader.readAll();
            reader.close();
            this.setMaxCols(this.data.size());
            csvList.forEach(l -> ParameterDataFile.addCsvLine(this.data, l));
        }
        catch (CsvException | IOException e) {
            this.error = e.getMessage();
        }
    }

    private void parseJsonObject(JsonObject jsonObject) {
        AtomicInteger colIndex = new AtomicInteger(0);
        jsonObject.keySet().forEach(c -> ParameterDataFile.addCol(this.data, jsonObject, c, colIndex.getAndIncrement()));
    }

    public boolean noError() {
        return this.error == null || this.error.isEmpty();
    }

    private static void addCol(ArrayList<ParameterList> list, JsonObject obj, String colName, int colIndex) {
        JsonArray data = obj.get(colName).getAsJsonArray();
        AtomicInteger line = new AtomicInteger(0);
        data.forEach(e -> ParameterDataFile.addLine(list, e, line.getAndIncrement(), data, colName, colIndex));
    }

    private static void addLine(ArrayList<ParameterList> list, JsonElement elem, int line, JsonArray data, String colName, int colIndex) {
        if (elem != null && elem.isJsonPrimitive()) {
            if (list.size() < line + 1) {
                list.add(new ParameterList(line));
            }
            ParameterList currentLine = list.get(line);
            currentLine.addParameter(new Parameter(colIndex, colName, data.get(line).getAsString()));
        }
    }

    private static void addCsvLine(ArrayList<ParameterList> result, String[] line) {
        AtomicInteger col = new AtomicInteger(0);
        result.add(new ParameterList(result.size(), Arrays.stream(line).map(l -> new Parameter(col.getAndIncrement(), (String)l)).collect(Collectors.toList())));
    }

    private static JsonElement getJsonElement(String content) {
        try {
            return JsonParser.parseString((String)content);
        }
        catch (JsonSyntaxException ex) {
            return null;
        }
    }

    public int getSize() {
        return this.data.size();
    }

    public ParameterList getData(int index) {
        if (this.getSize() > index) {
            return this.data.get(index);
        }
        if (this.getSize() > 0) {
            return this.data.get(0);
        }
        return null;
    }

    public String getDataType() {
        return this.dataType;
    }

    public void setDataType(String type) {
        this.dataType = type;
    }

    public ArrayList<ParameterList> getData() {
        return this.data;
    }

    public void setData(ArrayList<ParameterList> list) {
        this.data = list;
    }

    public String getError() {
        return this.error;
    }

    public void setError(String error) {
        this.error = error;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    public int getMaxCols() {
        return this.maxCols;
    }

    public void setMaxCols(int maxCols) {
        if (maxCols > this.maxCols) {
            this.maxCols = maxCols;
        }
    }
}

