/*
 * Decompiled with CFR 0.152.
 */
package com.ats.recorder;

import com.ats.element.TestElement;
import com.ats.executor.ActionTestScript;
import com.ats.executor.channels.Channel;
import com.ats.executor.channels.EmptyChannel;
import com.ats.executor.drivers.desktop.DesktopResponse;
import com.ats.generator.objects.MouseDirection;
import com.ats.recorder.IVisualRecorder;
import com.ats.recorder.ReportSummary;
import com.ats.script.Project;
import com.ats.script.ScriptHeader;
import com.ats.script.actions.Action;
import com.ats.script.actions.ActionChannelStart;
import com.ats.script.actions.ActionChannelSwitch;
import com.ats.script.actions.ActionExecute;
import com.ats.script.actions.ActionGotoUrl;
import com.ats.script.actions.ActionMouse;
import com.ats.script.actions.ActionMouseDragDrop;
import com.ats.script.actions.ActionMouseKey;
import com.ats.script.actions.ActionMouseScroll;
import com.ats.script.actions.ActionMouseSwipe;
import com.ats.script.actions.ActionScripting;
import com.ats.script.actions.ActionText;
import com.ats.script.actions.ActionWindowResize;
import com.ats.script.actions.ActionWindowState;
import com.ats.script.actions.ActionWindowSwitch;
import com.ats.tools.logger.ExecutionLogger;
import com.ats.tools.report.XmlReport;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;

public class VisualRecorder
implements IVisualRecorder {
    private Channel channel;
    private String outputPath;
    private ScriptHeader scriptHeader;
    private int visualQuality = 3;
    private boolean xml = false;
    private long started;
    private boolean recording = false;
    private ReportSummary summary = new ReportSummary();
    private ActionTestScript topScript;
    private ExecutionLogger logger;

    public VisualRecorder(ActionTestScript topScript, ScriptHeader header, Project project, boolean xml, int quality) {
        this.topScript = topScript;
        this.logger = new ExecutionLogger();
        Path output = project.getReportFolder().resolve(header.getPackagePath());
        output.toFile().mkdirs();
        this.initAndStart(output, header, xml, quality);
    }

    public VisualRecorder(ActionTestScript topScript, File outputFolder, ScriptHeader header, boolean xml, int quality, ExecutionLogger logger) {
        this.topScript = topScript;
        this.logger = logger;
        Path output = outputFolder.toPath();
        this.initAndStart(output, header, xml, quality);
    }

    private void initAndStart(Path output, ScriptHeader header, boolean xml, int quality) {
        this.outputPath = output.toFile().getAbsolutePath();
        this.scriptHeader = header;
        this.xml = xml;
        if (quality > 0) {
            this.visualQuality = quality;
        }
        this.started = System.currentTimeMillis();
    }

    @Override
    public void updateSummary(String testName, int testLine, String data) {
        this.summary.appendData(data);
    }

    @Override
    public void updateSummaryFail(String testName, int testLine, String app, String errorMessage) {
        this.summary.setFailData(testName, testLine, errorMessage);
    }

    @Override
    public void terminate() {
        if (this.channel != null) {
            Path path = Paths.get(this.outputPath, new String[0]);
            this.logger.sendInfo("Stop visual recording", this.scriptHeader.getQualifiedName());
            this.channel.stopVisualRecord(this.topScript.getStatus(), this.summary);
            this.channel.saveVisualReportFile(path, this.scriptHeader.getQualifiedName() + ".atsv", this.logger);
            if (this.xml) {
                XmlReport.createReport(path, this.scriptHeader.getQualifiedName(), this.logger);
            }
        }
    }

    private void setChannel(Channel channel) {
        if (!this.recording && channel != null && !(channel instanceof EmptyChannel)) {
            this.recording = true;
            DesktopResponse resp = channel.startVisualRecord(this.scriptHeader, this.visualQuality, this.started);
            if (resp != null && resp.errorCode < 0) {
                channel.sendLog(resp.errorCode, "Unable to start visual recording", resp.errorMessage);
            }
        }
        this.channel = channel;
    }

    private boolean isSyncAction(String actionName) {
        return actionName == ActionMouse.class.getName() || actionName == ActionGotoUrl.class.getName() || actionName == ActionMouseKey.class.getName() || actionName == ActionMouseScroll.class.getName() || actionName == ActionText.class.getName() || actionName == ActionScripting.class.getName() || actionName == ActionWindowState.class.getName() || actionName == ActionWindowSwitch.class.getName() || actionName == ActionMouseDragDrop.class.getName() || actionName == ActionMouseSwipe.class.getName() || actionName == ActionChannelSwitch.class.getName() || actionName == ActionWindowResize.class.getName();
    }

    @Override
    public void createVisualStartChannelAction(ActionChannelStart action, long duration, String scriptName, int scriptLine) {
        this.setChannel(action.getStatus().getChannel());
        this.channel.createVisualAction(true, action.getClass().getName(), scriptLine, scriptName, System.currentTimeMillis() - this.started - duration, this.isSyncAction(action.getClass().getName()));
        this.channel.sleep(100);
        this.update(0, duration, action.getName(), action.getActionLogsData().toString());
    }

    @Override
    public void createVisualAction(Action action, String scriptName, int scriptLine) {
        this.setChannel(action.getStatus().getChannel());
        this.channel.createVisualAction(action instanceof ActionExecute && ((ActionExecute)action).getStopPolicy() == 0, action.getClass().getName(), scriptLine, scriptName, System.currentTimeMillis() - this.started, this.isSyncAction(action.getClass().getName()));
    }

    @Override
    public void update(int error, long duration, String value, String data) {
        this.channel.updateVisualAction(error, duration, value, data);
    }

    @Override
    public void update(int error, long duration, String value) {
        this.channel.updateVisualAction(error, duration, value);
    }

    @Override
    public void updateScreen(boolean ref) {
        this.channel.sleep(100);
        this.channel.updateVisualAction(ref);
    }

    @Override
    public void update(String value) {
        this.channel.updateVisualAction(value);
    }

    @Override
    public void update(String value, String data) {
        this.channel.updateVisualAction(value, data);
    }

    @Override
    public void update(String type, MouseDirection position) {
        this.channel.updateVisualAction(type, position.getHorizontalPos(), position.getVerticalPos());
    }

    @Override
    public void update(int error, long duration) {
        this.channel.updateVisualAction(error, duration);
    }

    @Override
    public void update(TestElement element) {
        this.channel.updateVisualAction(element);
    }

    @Override
    public void updateScreen(TestElement element) {
        this.channel.updateVisualAction(element);
    }

    @Override
    public void updateScreen(int error, long duration) {
        this.update(error, duration);
    }

    @Override
    public void updateScreen(int error, long duration, String value) {
        this.update(error, duration, value);
    }

    @Override
    public void updateTextScreen(int error, long duration, String value, String data) {
        this.update(error, duration, value, data);
    }

    @Override
    public void updateScreen(int error, long duration, String type, MouseDirection position) {
        this.update(error, duration);
        this.update(type, position);
    }

    @Override
    public void update(int error, long duration, TestElement element) {
        this.update(error, duration);
        this.update(element);
    }

    @Override
    public void update(int error, long duration, String value, String data, TestElement element) {
        this.update(error, duration, value, data);
        this.update(element);
    }
}

