/*
 * Decompiled with CFR 0.152.
 */
package com.ats.script;

import com.ats.generator.GeneratorReport;
import com.ats.generator.parsers.Lexer;
import com.ats.generator.parsers.ScriptParser;
import com.ats.generator.variables.CalculatedValue;
import com.ats.generator.variables.Variable;
import com.ats.generator.variables.parameter.ParameterList;
import com.ats.script.Project;
import com.ats.script.Script;
import com.ats.script.ScriptHeader;
import com.ats.script.actions.Action;
import com.ats.script.actions.ActionCallscript;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import org.ahocorasick.trie.Trie;

public class ScriptLoader
extends Script {
    private ScriptParser parser;
    private ScriptHeader header;
    private String javaCode = null;
    private Charset charset;
    private ArrayList<Action> actions;
    private String projectGav = "";

    public ScriptLoader() {
    }

    public ScriptLoader(Lexer lexer) {
        this.actions = new ArrayList();
        this.parser = new ScriptParser(lexer);
        this.parser.addScript();
    }

    public ScriptLoader(String type, Lexer lexer, File file, Project projectData) {
        this(type, lexer, file, projectData, DEFAULT_CHARSET);
    }

    public ScriptLoader(String type, Lexer lexer, File file, Project prj, Charset charset) {
        ScriptHeader header = new ScriptHeader(prj, file);
        this.setHeader(header);
        this.setCharset(charset);
        this.projectGav = prj.getGav();
        if ("ats".equals(type)) {
            this.setParameterList(new ParameterList(0));
            this.setVariables(new ArrayList<Variable>());
            this.actions = new ArrayList();
            this.parser = new ScriptParser(lexer);
            this.parser.addScript();
            try {
                Stream<String> lines = Files.lines(file.toPath(), this.charset);
                lines.map(String::trim).filter(a -> !a.isEmpty()).filter(a -> !a.startsWith("[")).forEach(a -> this.parser.parse(this, header, (String)a));
                lines.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else if ("java".equals(type)) {
            try {
                this.javaCode = new String(Files.readAllBytes(file.toPath()));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void setCharset(Charset value) {
        this.charset = value;
    }

    public void addAction(Action data, boolean disabled) {
        data.setDisabled(disabled);
        data.setLine(this.actions.size());
        this.actions.add(data);
    }

    public boolean isSubscriptCalled(String scriptName) {
        for (Action action : this.actions) {
            if (!(action instanceof ActionCallscript) || !((ActionCallscript)action).isSubscriptCalled(scriptName)) continue;
            return true;
        }
        return false;
    }

    public boolean getActionsKeywords(Trie trie) {
        for (Action action : this.actions) {
            ArrayList<String> actionKeywords = action.getKeywords();
            for (String keywords : actionKeywords) {
                if (!trie.containsMatch((CharSequence)keywords)) continue;
                return true;
            }
        }
        return false;
    }

    public String getJavaCode(Project project) {
        if (this.javaCode != null) {
            return this.javaCode;
        }
        StringBuilder code = new StringBuilder(this.header.getJavaCode(project));
        code.append("\r\n\r\n\t\t//   ---< Variables >---   //\r\n");
        List<Variable> variables = this.getVariables();
        Collections.sort(variables);
        for (Variable variable : variables) {
            code.append("\r\n\t\t").append(variable.getJavaCode()).append(";");
        }
        code.append("\r\n\r\n\t\t//   ---< Actions >---   //\r\n");
        for (Action action : this.actions) {
            if (action.isDisabled() || action.isScriptComment()) continue;
            code.append("\r\n\t\t").append((CharSequence)action.getJavaCode()).append(");");
        }
        CalculatedValue[] returnValues = this.getReturns();
        if (returnValues != null) {
            code.append("\r\n\r\n\t\t//   ---< Return >---   //\r\n\r\n\t\t").append("rtn").append("(");
            ArrayList<String> returnValuesCode = new ArrayList<String>();
            for (CalculatedValue ret : returnValues) {
                returnValuesCode.add(ret.getJavaCode());
            }
            code.append(String.join((CharSequence)", ", returnValuesCode)).append(");");
        }
        code.append("\r\n\t}\r\n}");
        return code.toString();
    }

    public void generateJavaFile(Project project) {
        if (this.header.getJavaDestinationFolder() != null) {
            File javaFile = this.header.getJavaFile();
            try {
                javaFile.getParentFile().mkdirs();
                BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(javaFile, false), this.charset));
                writer.write(this.getJavaCode(project));
                writer.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public ScriptHeader getHeader() {
        return this.header;
    }

    public void setHeader(ScriptHeader header) {
        this.header = header;
    }

    public Action[] getActions() {
        return this.actions.toArray(new Action[this.actions.size()]);
    }

    public void setActions(Action[] data) {
        this.actions = new ArrayList<Action>(Arrays.asList(data));
    }

    public String getProjectGav() {
        return this.projectGav;
    }

    public void setProjectGav(String value) {
    }

    public Lexer getLexer() {
        return this.parser.getLexer();
    }

    public static void main(String[] args) {
        File scriptFile;
        if (args.length == 1 && (scriptFile = new File(args[0])).exists() && scriptFile.isFile() && scriptFile.getName().toLowerCase().endsWith("ats")) {
            GeneratorReport report = new GeneratorReport();
            Lexer lexer = new Lexer(report);
            lexer.loadScript(scriptFile);
        }
    }
}

