/*
 * Decompiled with CFR 0.152.
 */
package com.ats.script.actions;

import com.ats.executor.ActionStatus;
import com.ats.executor.ActionTestScript;
import com.ats.executor.channels.Channel;
import com.ats.script.Script;
import com.google.gson.JsonObject;
import java.util.ArrayList;

public abstract class Action {
    protected Script script;
    protected ActionStatus status;
    protected int line;
    protected boolean disabled = false;
    private Channel currentChannel;

    public Action() {
    }

    public Action(Script script) {
        this.script = script;
    }

    public StringBuilder getJavaCode() {
        StringBuilder codeBuilder = new StringBuilder("exec");
        codeBuilder.append("(").append(this.getLine()).append(",").append("new ").append(this.getClass().getSimpleName()).append("(this, ");
        return codeBuilder;
    }

    public boolean isScriptComment() {
        return false;
    }

    public ArrayList<String> getKeywords() {
        return new ArrayList<String>();
    }

    public boolean execute(ActionTestScript ts, String testName, int line) {
        this.currentChannel = ts.getCurrentChannel();
        this.status = this.currentChannel.newActionStatus(testName, line);
        this.currentChannel.startHarAction(this, this.status.getTestLine());
        ts.getRecorder().createVisualAction(this, testName, line);
        return true;
    }

    public StringBuilder getActionLogs(String scriptName, int scriptLine, JsonObject data) {
        if (!this.status.isPassed()) {
            data = new JsonObject();
            data.addProperty("status", "non blocking action");
            data.addProperty("message", this.status.getFailMessage());
        }
        data.addProperty("passed", Boolean.valueOf(this.status.isPassed()));
        data.addProperty("duration", (Number)this.status.getDuration());
        return new StringBuilder(this.getClass().getSimpleName()).append(" (").append(scriptName).append(":").append(scriptLine).append(") -> ").append(data.toString());
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }

    public int getLine() {
        return this.line;
    }

    public void setLine(int line) {
        this.line = line;
    }

    public Script getScript() {
        return this.script;
    }

    public void setScript(Script script) {
        this.script = script;
    }

    public ActionStatus getStatus() {
        return this.status;
    }

    public void setStatus(ActionStatus status) {
        this.status = status;
    }

    protected Channel getCurrentChannel() {
        return this.currentChannel;
    }
}

