/*
 * Decompiled with CFR 0.152.
 */
package com.ats.script.actions;

import com.ats.executor.ActionTestScript;
import com.ats.executor.channels.Channel;
import com.ats.generator.variables.CalculatedValue;
import com.ats.script.Script;
import com.ats.script.actions.ActionChannel;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.StringJoiner;

public class ActionChannelStart
extends ActionChannel {
    public static final String SCRIPT_START_LABEL = "channel-start";
    public static final String BASIC_AUTHENTICATION = "Basic";
    public static final int PERF = 1;
    public static final int NEOLOAD = 2;
    public static final String ATTACH = "attach";
    private CalculatedValue application;
    private ArrayList<CalculatedValue> arguments = new ArrayList();
    private int performance = 0;
    private boolean attach = false;
    private String authentication = "";
    private String authenticationValue = "";

    public ActionChannelStart() {
    }

    public ActionChannelStart(Script script, String name, List<String> options, CalculatedValue value, List<String> dataArray) {
        super(script, name);
        this.setApplication(value);
        if (dataArray != null) {
            options.addAll(dataArray);
        }
        options.forEach(o -> this.parseOptions(script, o.trim()));
    }

    private void parseOptions(Script script, String value) {
        if ("neoload".equalsIgnoreCase(value)) {
            this.setPerformance(2);
        } else if (ATTACH.equalsIgnoreCase(value)) {
            this.setAttach(true);
        } else if ("perf".equalsIgnoreCase(value)) {
            this.setPerformance(1);
        } else if (BASIC_AUTHENTICATION.equalsIgnoreCase(value)) {
            this.setAuthentication(BASIC_AUTHENTICATION);
        } else if (BASIC_AUTHENTICATION.equalsIgnoreCase(this.authentication)) {
            this.setAuthenticationValue(value);
        } else {
            this.arguments.add(new CalculatedValue(script, value));
        }
    }

    public ActionChannelStart(Script script, boolean attach, String name, CalculatedValue value, String[] options) {
        this(script, name, Arrays.asList(options), value, null);
        this.setAttach(attach);
    }

    public ActionChannelStart(Script script, boolean attach, String name, CalculatedValue value, String[] options, CalculatedValue ... calculatedValues) {
        this(script, name, Arrays.asList(options), value, null);
        this.setArguments(new ArrayList<CalculatedValue>(Arrays.asList(calculatedValues)));
        this.setAttach(attach);
    }

    @Override
    public boolean execute(ActionTestScript ts, String testName, int testLine) {
        this.setStatus(ts.getCurrentChannel().newActionStatus(testName, testLine));
        ts.getChannelManager().startChannel(this.status, this);
        return true;
    }

    @Override
    public JsonObject getActionLogsData() {
        Channel channel = this.status.getChannel();
        JsonObject data = super.getActionLogsData();
        data.addProperty("app", this.application.getCalculated());
        data.addProperty("appVersion", channel.getApplicationVersion());
        data.addProperty("os", channel.getOs());
        return data;
    }

    @Override
    public ArrayList<String> getKeywords() {
        ArrayList<String> keywords = super.getKeywords();
        keywords.add(this.application.getKeywords());
        return keywords;
    }

    @Override
    public StringBuilder getJavaCode() {
        StringBuilder codeBuilder = super.getJavaCode().append(this.isAttach()).append(", ").append("\"").append(this.getName()).append("\", ").append(this.application.getJavaCode()).append(", new String[]{");
        ArrayList<String> options = new ArrayList<String>();
        if (this.performance == 1) {
            options.add(String.format("\"%s\"", "perf"));
        } else if (this.performance == 2) {
            options.add(String.format("\"%s\"", "neoload"));
        }
        if (this.authentication != null && this.authentication.length() > 0) {
            options.add(String.format("\"%s\"", this.authentication));
            options.add(String.format("\"%s\"", this.authenticationValue));
        }
        codeBuilder.append(String.join((CharSequence)", ", options)).append("}");
        if (this.arguments.size() > 0) {
            codeBuilder.append(", ");
            StringJoiner argumentsJoiner = new StringJoiner(", ");
            for (CalculatedValue calc : this.arguments) {
                argumentsJoiner.add(calc.getJavaCode());
            }
            codeBuilder.append(argumentsJoiner.toString());
        }
        return codeBuilder.append(")");
    }

    public CalculatedValue getApplication() {
        return this.application;
    }

    public void setApplication(CalculatedValue value) {
        this.application = value;
    }

    public String getAuthentication() {
        return this.authentication;
    }

    public void setAuthentication(String value) {
        this.authentication = value;
    }

    public String getAuthenticationValue() {
        return this.authenticationValue;
    }

    public void setAuthenticationValue(String value) {
        this.authenticationValue = value;
    }

    public int getPerformance() {
        return this.performance;
    }

    public void setPerformance(int value) {
        this.performance = value;
    }

    public ArrayList<CalculatedValue> getArguments() {
        return this.arguments;
    }

    public void setArguments(ArrayList<CalculatedValue> arguments) {
        this.arguments = arguments;
    }

    public boolean isAttach() {
        return this.attach;
    }

    public void setAttach(boolean attach) {
        this.attach = attach;
    }
}

