/*
 * Decompiled with CFR 0.152.
 */
package com.ats.script.actions;

import com.ats.element.SearchedElement;
import com.ats.executor.ActionTestScript;
import com.ats.generator.variables.Variable;
import com.ats.script.Script;
import com.ats.script.actions.ActionReturnVariable;
import com.google.gson.JsonObject;
import java.util.ArrayList;

public class ActionProperty
extends ActionReturnVariable {
    public static final String SCRIPT_LABEL = "property";
    private String name;

    public ActionProperty() {
    }

    public ActionProperty(Script script, int stopPolicy, ArrayList<String> options, String name, Variable variable, ArrayList<String> objectArray) {
        super(script, stopPolicy, options, objectArray, variable);
        this.setName(name);
    }

    public ActionProperty(Script script, int stopPolicy, int maxTry, int delay, SearchedElement element, String name, Variable variable) {
        super(script, stopPolicy, maxTry, delay, element, variable);
        this.setName(name);
    }

    @Override
    public StringBuilder getJavaCode() {
        StringBuilder codeBuilder = super.getJavaCode();
        codeBuilder.append(", \"").append(this.name).append("\", ").append(this.variable.getName()).append(")");
        return codeBuilder;
    }

    @Override
    public ArrayList<String> getKeywords() {
        ArrayList<String> keywords = super.getKeywords();
        keywords.add(this.name);
        return keywords;
    }

    @Override
    public void terminateExecution(ActionTestScript ts) {
        super.terminateExecution(ts);
        if (this.status.isPassed()) {
            String attributeValue = this.getTestElement().getAttribute(this.status, this.name);
            this.status.endDuration();
            if (attributeValue == null) {
                this.status.setError(-5, "attribute '" + this.name + "' not found", this.name);
                ts.getRecorder().update(-5, this.status.getDuration(), this.name);
            } else {
                this.status.setMessage(attributeValue);
                this.updateVariableValue(attributeValue);
                ts.getRecorder().update(0, this.status.getDuration(), this.name, attributeValue);
            }
        } else {
            String attributeValue = this.getTestElement().getAttributeNotFound(this.status, this.name);
            this.status.endDuration();
            this.status.setMessage(attributeValue);
            this.updateVariableValue(attributeValue);
            ts.getRecorder().update(0, this.status.getDuration(), this.name, attributeValue);
        }
    }

    @Override
    public StringBuilder getActionLogs(String scriptName, int scriptLine, JsonObject data) {
        data.addProperty(SCRIPT_LABEL, this.name);
        return super.getActionLogs(scriptName, scriptLine, data);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String value) {
        this.name = value;
    }
}

