/*
 * Decompiled with CFR 0.152.
 */
package com.ats.script.actions;

import com.ats.executor.channels.Channel;
import com.ats.generator.objects.BoundData;
import com.ats.script.Script;
import com.ats.script.actions.ActionWindow;
import com.google.gson.JsonObject;

public class ActionWindowResize
extends ActionWindow {
    public static final String SCRIPT_RESIZE_LABEL = "window-resize";
    private static final String X = "x";
    private static final String Y = "y";
    private static final String WIDTH = "width";
    private static final String HEIGHT = "height";
    private BoundData x;
    private BoundData y;
    private BoundData width;
    private BoundData height;

    public ActionWindowResize() {
    }

    public ActionWindowResize(Script script, String size) {
        super(script);
        String[] sizeData;
        block12: for (String data : sizeData = size.split(",")) {
            String[] dataValue = data.split("=");
            if (dataValue.length != 2) continue;
            switch (dataValue[0].trim().toLowerCase()) {
                case "x": {
                    this.x = this.getBoundData(dataValue[1].trim());
                    continue block12;
                }
                case "y": {
                    this.y = this.getBoundData(dataValue[1].trim());
                    continue block12;
                }
                case "width": {
                    this.width = this.getBoundData(dataValue[1].trim());
                    continue block12;
                }
                case "height": {
                    this.height = this.getBoundData(dataValue[1].trim());
                }
            }
        }
    }

    private BoundData getBoundData(String data) {
        try {
            return new BoundData(Integer.parseInt(data));
        }
        catch (NumberFormatException ex) {
            return null;
        }
    }

    public ActionWindowResize(Script script, Integer x, Integer y, Integer width, Integer height) {
        super(script);
        this.setX(this.getBoundDataValue(x));
        this.setY(this.getBoundDataValue(y));
        this.setWidth(this.getBoundDataValue(width));
        this.setHeight(this.getBoundDataValue(height));
    }

    private BoundData getBoundDataValue(Integer value) {
        if (value != null) {
            return new BoundData(value);
        }
        return null;
    }

    private String getBoundDataJavaCode(BoundData value) {
        if (value != null) {
            return "" + value.getValue();
        }
        return null;
    }

    @Override
    public StringBuilder getJavaCode() {
        StringBuilder codeBuilder = super.getJavaCode();
        codeBuilder.append(this.getBoundDataJavaCode(this.x)).append(", ").append(this.getBoundDataJavaCode(this.y)).append(", ").append(this.getBoundDataJavaCode(this.width)).append(", ").append(this.getBoundDataJavaCode(this.height)).append(")");
        return codeBuilder;
    }

    @Override
    public String exec(Channel channel) {
        return channel.setWindowBound(this.x, this.y, this.width, this.height);
    }

    @Override
    public StringBuilder getActionLogs(String scriptName, int scriptLine, JsonObject data) {
        if (this.x != null) {
            data.addProperty(X, (Number)this.x.getValue());
        }
        if (this.y != null) {
            data.addProperty(Y, (Number)this.y.getValue());
        }
        if (this.width != null) {
            data.addProperty(WIDTH, (Number)this.width.getValue());
        }
        if (this.height != null) {
            data.addProperty(HEIGHT, (Number)this.height.getValue());
        }
        data.addProperty("duration", (Number)this.status.getDuration());
        return super.getActionLogs(scriptName, scriptLine, data);
    }

    public BoundData getX() {
        return this.x;
    }

    public void setX(BoundData x) {
        this.x = x;
    }

    public BoundData getY() {
        return this.y;
    }

    public void setY(BoundData y) {
        this.y = y;
    }

    public BoundData getWidth() {
        return this.width;
    }

    public void setWidth(BoundData width) {
        this.width = width;
    }

    public BoundData getHeight() {
        return this.height;
    }

    public void setHeight(BoundData height) {
        this.height = height;
    }
}

