/*
 * Decompiled with CFR 0.152.
 */
package com.ats.script.actions;

import com.ats.executor.channels.Channel;
import com.ats.generator.objects.TryAndDelay;
import com.ats.script.Script;
import com.ats.script.actions.ActionWindow;
import com.google.gson.JsonObject;
import java.util.ArrayList;

public class ActionWindowSwitch
extends ActionWindow {
    public static final String SCRIPT_SWITCH_LABEL = "window-switch";
    private int num = 0;
    private int tries = 0;
    private int delay = 0;

    public ActionWindowSwitch() {
    }

    public ActionWindowSwitch(Script script, int num, ArrayList<String> options) {
        super(script);
        int[] data = TryAndDelay.getTryAndDelay(options);
        this.setNum(num);
        this.setTries(data[0]);
        this.setDelay(data[1]);
    }

    public ActionWindowSwitch(Script script, int tries, int num, int delay) {
        super(script);
        this.setNum(num);
        this.setTries(tries);
        this.setDelay(delay);
    }

    @Override
    public StringBuilder getJavaCode() {
        return super.getJavaCode().append(this.tries).append(", ").append(this.num).append(", ").append(this.delay).append(")");
    }

    @Override
    public String exec(Channel channel) {
        channel.switchWindow(this.status, this.num, this.tries, this.delay);
        return "" + this.num;
    }

    @Override
    public StringBuilder getActionLogs(String scriptName, int scriptLine, JsonObject data) {
        data.addProperty("index", (Number)this.num);
        data.addProperty("tries", (Number)this.tries);
        return super.getActionLogs(scriptName, scriptLine, data);
    }

    public int getDelay() {
        return this.delay;
    }

    public void setDelay(int delay) {
        this.delay = delay;
    }

    public int getNum() {
        return this.num;
    }

    public void setNum(int num) {
        this.num = num;
    }

    public int getTries() {
        return this.tries;
    }

    public void setTries(int tries) {
        this.tries = tries;
    }
}

